/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.shex;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.shex.ShexRecord;

public class ShapeMap {
    protected final List<ShexRecord> associations;

    public static ShapeMap create(List<ShexRecord> associations) {
        associations = new ArrayList<ShexRecord>(associations);
        return new ShapeMap(associations);
    }

    private ShapeMap(List<ShexRecord> associations) {
        this.associations = associations;
    }

    public List<ShexRecord> entries() {
        return Collections.unmodifiableList(this.associations);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static ShapeMap record(Node focus, Node shapeRef) {
        return new Builder().add(focus, shapeRef).build();
    }

    public static ShapeMap record(Triple pattern, Node shapeRef) {
        return new Builder().add(pattern, shapeRef).build();
    }

    public static class Builder {
        private List<ShexRecord> records = new ArrayList<ShexRecord>();

        Builder() {
        }

        Builder(ShapeMap base) {
            base.entries().forEach(this.records::add);
        }

        public Builder add(Node focus, Node shapeRef) {
            this.records.add(new ShexRecord(focus, shapeRef));
            return this;
        }

        public Builder add(Triple pattern, Node shapeRef) {
            this.records.add(new ShexRecord(pattern, shapeRef));
            return this;
        }

        public ShapeMap build() {
            ShapeMap map = ShapeMap.create(this.records);
            this.records.clear();
            return map;
        }
    }
}

