/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.metric.overview;

import org.apache.iotdb.commons.service.metric.enums.Metric;
import org.apache.iotdb.commons.service.metric.enums.Tag;
import org.apache.iotdb.metrics.AbstractMetricService;
import org.apache.iotdb.metrics.impl.DoNothingMetricManager;
import org.apache.iotdb.metrics.metricsets.IMetricSet;
import org.apache.iotdb.metrics.type.Timer;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.apache.iotdb.metrics.utils.MetricType;

public class PipeHeartbeatEventMetrics
implements IMetricSet {
    private Timer publishedToAssignedTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private Timer assignedToProcessedTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private Timer processedToTransferredTimer = DoNothingMetricManager.DO_NOTHING_TIMER;

    public void bindTo(AbstractMetricService metricService) {
        this.bindStageTimer(metricService);
    }

    private void bindStageTimer(AbstractMetricService metricService) {
        this.publishedToAssignedTimer = metricService.getOrCreateTimer(Metric.PIPE_HEARTBEAT_EVENT.toString(), MetricLevel.IMPORTANT, new String[]{Tag.STAGE.toString(), "publishedToAssigned"});
        this.assignedToProcessedTimer = metricService.getOrCreateTimer(Metric.PIPE_HEARTBEAT_EVENT.toString(), MetricLevel.IMPORTANT, new String[]{Tag.STAGE.toString(), "assignedToProcessed"});
        this.processedToTransferredTimer = metricService.getOrCreateTimer(Metric.PIPE_HEARTBEAT_EVENT.toString(), MetricLevel.IMPORTANT, new String[]{Tag.STAGE.toString(), "processedToTransferred"});
    }

    public void unbindFrom(AbstractMetricService metricService) {
        this.unbindStageTimer(metricService);
    }

    private void unbindStageTimer(AbstractMetricService metricService) {
        this.publishedToAssignedTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
        this.assignedToProcessedTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
        this.processedToTransferredTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
        metricService.remove(MetricType.TIMER, Metric.PIPE_HEARTBEAT_EVENT.toString(), new String[]{Tag.STAGE.toString(), "publishedToAssigned"});
        metricService.remove(MetricType.TIMER, Metric.PIPE_HEARTBEAT_EVENT.toString(), new String[]{Tag.STAGE.toString(), "assignedToProcessed"});
        metricService.remove(MetricType.TIMER, Metric.PIPE_HEARTBEAT_EVENT.toString(), new String[]{Tag.STAGE.toString(), "processedToTransferred"});
    }

    public void recordPublishedToAssignedTime(long costTimeInMillis) {
        this.publishedToAssignedTimer.updateMillis(costTimeInMillis);
    }

    public void recordAssignedToProcessedTime(long costTimeInMillis) {
        this.assignedToProcessedTimer.updateMillis(costTimeInMillis);
    }

    public void recordProcessedToTransferredTime(long costTimeInMillis) {
        this.processedToTransferredTimer.updateMillis(costTimeInMillis);
    }

    public static PipeHeartbeatEventMetrics getInstance() {
        return PipeHeartbeatEventMetricsHolder.INSTANCE;
    }

    private PipeHeartbeatEventMetrics() {
    }

    private static class PipeHeartbeatEventMetricsHolder {
        private static final PipeHeartbeatEventMetrics INSTANCE = new PipeHeartbeatEventMetrics();

        private PipeHeartbeatEventMetricsHolder() {
        }
    }
}

