/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.receiver.protocol.pipeconsensus;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.function.TriFunction;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.consensus.ConsensusGroupId;
import org.apache.iotdb.commons.pipe.sink.payload.pipeconsensus.request.PipeConsensusRequestVersion;
import org.apache.iotdb.consensus.IConsensus;
import org.apache.iotdb.consensus.pipe.PipeConsensus;
import org.apache.iotdb.consensus.pipe.consensuspipe.ConsensusPipeName;
import org.apache.iotdb.consensus.pipe.consensuspipe.ConsensusPipeReceiver;
import org.apache.iotdb.consensus.pipe.thrift.TPipeConsensusTransferReq;
import org.apache.iotdb.consensus.pipe.thrift.TPipeConsensusTransferResp;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.consensus.DataRegionConsensusImpl;
import org.apache.iotdb.db.pipe.receiver.protocol.pipeconsensus.PipeConsensusReceiver;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeConsensusReceiverAgent
implements ConsensusPipeReceiver {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeConsensusReceiverAgent.class);
    private static final Map<Byte, TriFunction<PipeConsensus, ConsensusGroupId, ConsensusPipeName, PipeConsensusReceiver>> RECEIVER_CONSTRUCTORS = new HashMap<Byte, TriFunction<PipeConsensus, ConsensusGroupId, ConsensusPipeName, PipeConsensusReceiver>>();
    private static final long WAIT_INITIALIZE_RECEIVER_INTERVAL_IN_MS = 100L;
    private final int thisNodeId = IoTDBDescriptor.getInstance().getConfig().getDataNodeId();
    private final Map<ConsensusGroupId, Map<ConsensusPipeName, AtomicReference<PipeConsensusReceiver>>> replicaReceiverMap = new ConcurrentHashMap<ConsensusGroupId, Map<ConsensusPipeName, AtomicReference<PipeConsensusReceiver>>>();
    private PipeConsensus pipeConsensus;

    public PipeConsensusReceiverAgent() {
        RECEIVER_CONSTRUCTORS.put(PipeConsensusRequestVersion.VERSION_1.getVersion(), (TriFunction<PipeConsensus, ConsensusGroupId, ConsensusPipeName, PipeConsensusReceiver>)((TriFunction)PipeConsensusReceiver::new));
    }

    public void initConsensusInRuntime() {
        IConsensus consensus = DataRegionConsensusImpl.getInstance();
        this.pipeConsensus = consensus instanceof PipeConsensus ? (PipeConsensus)consensus : null;
    }

    public TPipeConsensusTransferResp receive(TPipeConsensusTransferReq req) {
        byte reqVersion = req.getVersion();
        if (RECEIVER_CONSTRUCTORS.containsKey(reqVersion)) {
            ConsensusGroupId consensusGroupId = ConsensusGroupId.Factory.createFromTConsensusGroupId((TConsensusGroupId)req.getConsensusGroupId());
            return this.getReceiver(consensusGroupId, req.getDataNodeId(), reqVersion).receive(req);
        }
        TSStatus status = RpcUtils.getStatus((TSStatusCode)TSStatusCode.PIPE_CONSENSUS_VERSION_ERROR, (String)String.format("Unknown PipeConsensusRequestVersion %s.", reqVersion));
        LOGGER.warn("PipeConsensus: Unknown PipeConsensusRequestVersion, response status = {}.", (Object)status);
        return new TPipeConsensusTransferResp(status);
    }

    private PipeConsensusReceiver getReceiver(ConsensusGroupId consensusGroupId, int leaderDataNodeId, byte reqVersion) {
        AtomicBoolean isFirstGetReceiver;
        ConsensusPipeName consensusPipeName;
        Map consensusPipe2ReceiverMap = this.replicaReceiverMap.computeIfAbsent(consensusGroupId, key -> new ConcurrentHashMap());
        AtomicReference receiverReference = consensusPipe2ReceiverMap.computeIfAbsent(consensusPipeName = new ConsensusPipeName(consensusGroupId, leaderDataNodeId, this.thisNodeId), arg_0 -> PipeConsensusReceiverAgent.lambda$getReceiver$1(isFirstGetReceiver = new AtomicBoolean(false), arg_0));
        if (receiverReference.get() == null) {
            return this.internalSetAndGetReceiver(consensusGroupId, consensusPipeName, reqVersion, isFirstGetReceiver);
        }
        byte receiverThreadLocalVersion = ((PipeConsensusReceiver)receiverReference.get()).getVersion().getVersion();
        if (receiverThreadLocalVersion != reqVersion) {
            LOGGER.warn("The pipeConsensus request version {} is different from the sender request version {}, the receiver will be reset to the sender request version.", (Object)receiverThreadLocalVersion, (Object)reqVersion);
            receiverReference.set(null);
            return this.internalSetAndGetReceiver(consensusGroupId, consensusPipeName, reqVersion, isFirstGetReceiver);
        }
        return (PipeConsensusReceiver)receiverReference.get();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private PipeConsensusReceiver internalSetAndGetReceiver(ConsensusGroupId consensusGroupId, ConsensusPipeName consensusPipeName, byte reqVersion, AtomicBoolean isFirstGetReceiver) {
        Map<ConsensusPipeName, AtomicReference<PipeConsensusReceiver>> consensusPipe2ReciverMap = this.replicaReceiverMap.get(consensusGroupId);
        AtomicReference<PipeConsensusReceiver> receiverReference = consensusPipe2ReciverMap.get(consensusPipeName);
        if (isFirstGetReceiver.get()) {
            if (!RECEIVER_CONSTRUCTORS.containsKey(reqVersion)) throw new UnsupportedOperationException(String.format("Unsupported pipeConsensus request version %d", reqVersion));
            receiverReference.set((PipeConsensusReceiver)RECEIVER_CONSTRUCTORS.get(reqVersion).apply((Object)this.pipeConsensus, (Object)consensusGroupId, (Object)consensusPipeName));
            return receiverReference.get();
        } else {
            this.waitUntilReceiverGetInitiated(receiverReference);
        }
        return receiverReference.get();
    }

    private void waitUntilReceiverGetInitiated(AtomicReference<PipeConsensusReceiver> receiverReference) {
        try {
            while (receiverReference.get() == null) {
                Thread.sleep(100L);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOGGER.warn("PipeConsensusReceiver thread is interrupted when waiting for receiver get initiated, may because system exit.", (Throwable)e);
        }
    }

    public final void handleDropPipeConsensusTask(ConsensusPipeName pipeName) {
        Map consensusPipe2ReciverMap = this.replicaReceiverMap.getOrDefault(pipeName.getConsensusGroupId(), new ConcurrentHashMap());
        AtomicReference receiverReference = consensusPipe2ReciverMap.getOrDefault(pipeName, null);
        if (receiverReference != null) {
            ((PipeConsensusReceiver)receiverReference.get()).handleExit();
            receiverReference.set(null);
        }
        consensusPipe2ReciverMap.remove(pipeName);
    }

    private static /* synthetic */ AtomicReference lambda$getReceiver$1(AtomicBoolean isFirstGetReceiver, ConsensusPipeName key) {
        isFirstGetReceiver.set(true);
        return new AtomicReference<Object>(null);
    }
}

