/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.server;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpRequest;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Objects;
import java.util.function.BiFunction;
import reactor.util.annotation.Nullable;

public final class ConnectionInfo {
    static final int DEFAULT_HTTP_PORT = 80;
    static final int DEFAULT_HTTPS_PORT = 443;
    static final String DEFAULT_HOST_NAME = "localhost";
    final SocketAddress hostAddress;
    final SocketAddress remoteAddress;
    final String scheme;
    final String hostName;
    final int hostPort;
    final boolean isInetAddress;
    @Nullable
    final String forwardedPrefix;

    static ConnectionInfo from(HttpRequest request, boolean secured, SocketAddress localAddress, SocketAddress remoteAddress, @Nullable BiFunction<ConnectionInfo, HttpRequest, ConnectionInfo> forwardedHeaderHandler) {
        String hostName = DEFAULT_HOST_NAME;
        int hostPort = -1;
        String scheme = secured ? "https" : "http";
        String header = request.headers().get((CharSequence)HttpHeaderNames.HOST);
        if (header != null) {
            hostName = header;
            if (!header.isEmpty()) {
                int portIndex;
                int n = portIndex = header.charAt(0) == '[' ? header.indexOf(58, header.indexOf(93)) : header.indexOf(58);
                if (portIndex != -1) {
                    hostName = header.substring(0, portIndex);
                    hostPort = Integer.parseInt(header.substring(portIndex + 1));
                }
            }
        }
        if (!(remoteAddress instanceof InetSocketAddress)) {
            return new ConnectionInfo(localAddress, hostName, hostPort, remoteAddress, scheme, false);
        }
        ConnectionInfo connectionInfo = new ConnectionInfo(localAddress, hostName, hostPort, remoteAddress, scheme, true);
        if (forwardedHeaderHandler != null) {
            return forwardedHeaderHandler.apply(connectionInfo, request);
        }
        return connectionInfo;
    }

    ConnectionInfo(SocketAddress hostAddress, SocketAddress remoteAddress, boolean secured) {
        this(hostAddress, DEFAULT_HOST_NAME, -1, remoteAddress, secured ? "https" : "http", remoteAddress instanceof InetSocketAddress);
    }

    ConnectionInfo(SocketAddress hostAddress, String hostName, int hostPort, SocketAddress remoteAddress, String scheme, boolean isInetAddress) {
        this(hostAddress, hostName, hostPort, remoteAddress, scheme, isInetAddress, null);
    }

    ConnectionInfo(SocketAddress hostAddress, String hostName, int hostPort, SocketAddress remoteAddress, String scheme, boolean isInetAddress, @Nullable String forwardedPrefix) {
        this.hostAddress = hostAddress;
        this.hostName = hostName;
        this.hostPort = hostPort;
        this.isInetAddress = isInetAddress;
        this.remoteAddress = remoteAddress;
        this.scheme = scheme;
        this.forwardedPrefix = forwardedPrefix;
    }

    @Nullable
    public InetSocketAddress getHostAddress() {
        return this.isInetAddress ? (InetSocketAddress)this.hostAddress : null;
    }

    @Nullable
    public InetSocketAddress getRemoteAddress() {
        return this.isInetAddress ? (InetSocketAddress)this.remoteAddress : null;
    }

    public String getScheme() {
        return this.scheme;
    }

    public ConnectionInfo withHostAddress(InetSocketAddress hostAddress) {
        Objects.requireNonNull(hostAddress, "hostAddress");
        return new ConnectionInfo(hostAddress, hostAddress.getHostString(), hostAddress.getPort(), this.remoteAddress, this.scheme, true);
    }

    public ConnectionInfo withHostAddress(InetSocketAddress hostAddress, String hostName, int hostPort) {
        Objects.requireNonNull(hostAddress, "hostAddress");
        Objects.requireNonNull(hostName, "hostName");
        return new ConnectionInfo(hostAddress, hostName, hostPort, this.remoteAddress, this.scheme, true);
    }

    public ConnectionInfo withRemoteAddress(InetSocketAddress remoteAddress) {
        Objects.requireNonNull(remoteAddress, "remoteAddress");
        return new ConnectionInfo(this.hostAddress, this.hostName, this.hostPort, remoteAddress, this.scheme, true);
    }

    public ConnectionInfo withScheme(String scheme) {
        Objects.requireNonNull(scheme, "scheme");
        return new ConnectionInfo(this.hostAddress, this.hostName, this.hostPort, this.remoteAddress, scheme, this.isInetAddress);
    }

    public ConnectionInfo withForwardedPrefix(String forwardedPrefix) {
        Objects.requireNonNull(forwardedPrefix, "forwardedPrefix");
        return new ConnectionInfo(this.hostAddress, this.hostName, this.hostPort, this.remoteAddress, this.scheme, this.isInetAddress, forwardedPrefix);
    }

    public String getHostName() {
        return this.hostName;
    }

    public int getHostPort() {
        return this.hostPort != -1 ? this.hostPort : ConnectionInfo.getDefaultHostPort(this.scheme);
    }

    @Nullable
    public String getForwardedPrefix() {
        return this.forwardedPrefix;
    }

    public static int getDefaultHostPort(String scheme) {
        return scheme.equalsIgnoreCase("https") || scheme.equalsIgnoreCase("wss") ? 443 : 80;
    }
}

