/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.procedure.scheduler;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.iotdb.confignode.procedure.Procedure;
import org.apache.iotdb.confignode.procedure.scheduler.ProcedureScheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractProcedureScheduler
implements ProcedureScheduler {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractProcedureScheduler.class);
    private final ReentrantLock schedulerLock = new ReentrantLock();
    private final Condition schedWaitCond = this.schedulerLock.newCondition();
    private boolean running = false;

    @Override
    public void start() {
        this.schedLock();
        try {
            this.running = true;
        }
        finally {
            this.schedUnlock();
        }
    }

    @Override
    public void stop() {
        this.schedLock();
        try {
            this.running = false;
            this.schedWaitCond.signalAll();
        }
        finally {
            this.schedUnlock();
        }
    }

    @Override
    public void signalAll() {
        this.schedLock();
        try {
            this.schedWaitCond.signalAll();
        }
        finally {
            this.schedUnlock();
        }
    }

    protected abstract void enqueue(Procedure var1, boolean var2);

    @Override
    public void addFront(Procedure procedure) {
        if (procedure.isSuccess()) {
            LOG.warn("Don't add a successful procedure back to the scheduler, it will be ignored");
            return;
        }
        this.push(procedure, true, true);
    }

    @Override
    public void addFront(Procedure procedure, boolean notify) {
        this.push(procedure, true, notify);
    }

    @Override
    public void addBack(Procedure procedure) {
        if (procedure.isSuccess()) {
            LOG.warn("Don't add a successful procedure back to the scheduler, it will be ignored");
            return;
        }
        this.push(procedure, false, true);
    }

    @Override
    public void addBack(Procedure procedure, boolean notify) {
        this.push(procedure, false, notify);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void push(Procedure procedure, boolean addFront, boolean notify) {
        this.schedLock();
        try {
            this.enqueue(procedure, addFront);
            if (notify) {
                this.schedWaitCond.signal();
            }
        }
        finally {
            this.schedUnlock();
        }
    }

    protected abstract Procedure dequeue();

    @Override
    public Procedure poll() {
        return this.poll(-1L);
    }

    @Override
    public Procedure poll(long timeout, TimeUnit unit) {
        return this.poll(unit.toNanos(timeout));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Procedure poll(long nanos) {
        this.schedLock();
        try {
            Procedure pollResult;
            if (!this.running) {
                LOG.debug("the scheduler is not running");
                Procedure procedure = null;
                return procedure;
            }
            if (!this.queueHasRunnables()) {
                if (nanos < 0L) {
                    this.schedWaitCond.await();
                } else {
                    long leftTime = this.schedWaitCond.awaitNanos(nanos);
                    LOG.debug("the scheduler waiting time left {} nanos", (Object)leftTime);
                }
                if (!this.queueHasRunnables()) {
                    Procedure leftTime = null;
                    return leftTime;
                }
            }
            Procedure procedure = pollResult = this.dequeue();
            return procedure;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            Procedure procedure = null;
            return procedure;
        }
        finally {
            this.schedUnlock();
        }
    }

    protected abstract int queueSize();

    protected abstract boolean queueHasRunnables();

    @Override
    public int size() {
        this.schedLock();
        try {
            int n = this.queueSize();
            return n;
        }
        finally {
            this.schedUnlock();
        }
    }

    @Override
    public boolean hasRunnables() {
        this.schedLock();
        try {
            boolean bl = this.queueHasRunnables();
            return bl;
        }
        finally {
            this.schedUnlock();
        }
    }

    protected void schedLock() {
        this.schedulerLock.lock();
    }

    protected void schedUnlock() {
        this.schedulerLock.unlock();
    }
}

