/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.client.async.handlers.heartbeat;

import org.apache.iotdb.ainode.rpc.thrift.TAIHeartbeatResp;
import org.apache.iotdb.commons.client.ThriftClient;
import org.apache.iotdb.commons.cluster.NodeStatus;
import org.apache.iotdb.commons.cluster.NodeType;
import org.apache.iotdb.confignode.manager.load.LoadManager;
import org.apache.iotdb.confignode.manager.load.cache.node.NodeHeartbeatSample;
import org.apache.thrift.async.AsyncMethodCallback;

public class AINodeHeartbeatHandler
implements AsyncMethodCallback<TAIHeartbeatResp> {
    private final int nodeId;
    private final LoadManager loadManager;

    public AINodeHeartbeatHandler(int nodeId, LoadManager loadManager) {
        this.nodeId = nodeId;
        this.loadManager = loadManager;
    }

    public void onComplete(TAIHeartbeatResp aiHeartbeatResp) {
        this.loadManager.getLoadCache().cacheAINodeHeartbeatSample(this.nodeId, new NodeHeartbeatSample(aiHeartbeatResp));
    }

    public void onError(Exception e) {
        if (ThriftClient.isConnectionBroken((Throwable)e)) {
            this.loadManager.forceUpdateNodeCache(NodeType.DataNode, this.nodeId, new NodeHeartbeatSample(NodeStatus.Unknown));
        }
        this.loadManager.getLoadCache().resetHeartbeatProcessing(this.nodeId);
    }
}

