/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.schemaengine.schemaregion.utils;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.commons.path.MeasurementPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.queryengine.execution.fragment.QueryContext;
import org.apache.iotdb.db.schemaengine.schemaregion.utils.ResourceByPathUtils;
import org.apache.iotdb.db.storageengine.dataregion.memtable.DeviceIDFactory;
import org.apache.iotdb.db.storageengine.dataregion.memtable.IMemTable;
import org.apache.iotdb.db.storageengine.dataregion.memtable.IWritableMemChunk;
import org.apache.iotdb.db.storageengine.dataregion.memtable.IWritableMemChunkGroup;
import org.apache.iotdb.db.storageengine.dataregion.memtable.ReadOnlyMemChunk;
import org.apache.iotdb.db.storageengine.dataregion.modification.Modification;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.db.utils.ModificationUtils;
import org.apache.iotdb.db.utils.datastructure.TVList;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.file.metadata.IChunkMetadata;
import org.apache.tsfile.file.metadata.IDeviceID;
import org.apache.tsfile.file.metadata.ITimeSeriesMetadata;
import org.apache.tsfile.file.metadata.TimeseriesMetadata;
import org.apache.tsfile.file.metadata.statistics.Statistics;
import org.apache.tsfile.read.common.TimeRange;
import org.apache.tsfile.read.filter.basic.Filter;
import org.apache.tsfile.utils.Pair;
import org.apache.tsfile.write.writer.RestorableTsFileIOWriter;

class MeasurementResourceByPathUtils
extends ResourceByPathUtils {
    MeasurementPath partialPath;

    protected MeasurementResourceByPathUtils(PartialPath partialPath) {
        this.partialPath = (MeasurementPath)partialPath;
    }

    @Override
    public ITimeSeriesMetadata generateTimeSeriesMetadata(List<ReadOnlyMemChunk> readOnlyMemChunk, List<IChunkMetadata> chunkMetadataList, Filter globalTimeFilter) {
        boolean useFakeStatistics = !readOnlyMemChunk.isEmpty() && IoTDBDescriptor.getInstance().getConfig().isStreamingQueryMemChunk();
        TimeseriesMetadata timeSeriesMetadata = new TimeseriesMetadata();
        timeSeriesMetadata.setMeasurementId(this.partialPath.getMeasurementSchema().getMeasurementId());
        timeSeriesMetadata.setTsDataType(this.partialPath.getMeasurementSchema().getType());
        timeSeriesMetadata.setDataSizeOfChunkMetaDataList(-1);
        long startTime = Long.MAX_VALUE;
        long endTime = Long.MIN_VALUE;
        Statistics seriesStatistics = Statistics.getStatsByType((TSDataType)timeSeriesMetadata.getTsDataType());
        boolean isModified = false;
        for (IChunkMetadata chunkMetadata : chunkMetadataList) {
            boolean bl = isModified = isModified || chunkMetadata.isModified();
            if (!useFakeStatistics) {
                seriesStatistics.mergeStatistics(chunkMetadata.getStatistics());
                continue;
            }
            startTime = Math.min(startTime, chunkMetadata.getStartTime());
            endTime = Math.max(endTime, chunkMetadata.getEndTime());
        }
        for (ReadOnlyMemChunk memChunk : readOnlyMemChunk) {
            if (memChunk.isEmpty()) continue;
            memChunk.sortTvLists();
            if (useFakeStatistics) {
                memChunk.initChunkMetaFromTVListsWithFakeStatistics();
                startTime = Math.min(startTime, memChunk.getChunkMetaData().getStartTime());
                endTime = Math.max(endTime, memChunk.getChunkMetaData().getEndTime());
                continue;
            }
            memChunk.initChunkMetaFromTvLists(globalTimeFilter);
            seriesStatistics.mergeStatistics(memChunk.getChunkMetaData().getStatistics());
        }
        if (useFakeStatistics) {
            seriesStatistics.setStartTime(startTime);
            seriesStatistics.setEndTime(endTime);
        }
        timeSeriesMetadata.setStatistics(seriesStatistics);
        timeSeriesMetadata.setModified(useFakeStatistics || isModified);
        return timeSeriesMetadata;
    }

    @Override
    public ReadOnlyMemChunk getReadOnlyMemChunkFromMemTable(QueryContext context, IMemTable memTable, List<Pair<Modification, IMemTable>> modsToMemtable, long timeLowerBound, Filter globalTimeFilter) throws QueryProcessException, IOException {
        IDeviceID deviceID;
        Map<IDeviceID, IWritableMemChunkGroup> memTableMap = memTable.getMemTableMap();
        if (!memTableMap.containsKey(deviceID = DeviceIDFactory.getInstance().getDeviceID(this.partialPath.getDevicePath())) || !memTableMap.get(deviceID).contains(this.partialPath.getMeasurement())) {
            return null;
        }
        IWritableMemChunk memChunk = memTableMap.get(deviceID).getMemChunkMap().get(this.partialPath.getMeasurement());
        Map<TVList, Integer> tvListQueryMap = this.prepareTvListMapForQuery(context, memChunk, modsToMemtable == null, globalTimeFilter);
        List<TimeRange> deletionList = null;
        if (modsToMemtable != null) {
            deletionList = ModificationUtils.constructDeletionList(this.partialPath, memTable, modsToMemtable, timeLowerBound);
        }
        return new ReadOnlyMemChunk(context, this.partialPath.getMeasurement(), this.partialPath.getMeasurementSchema().getType(), this.partialPath.getMeasurementSchema().getEncodingType(), tvListQueryMap, this.partialPath.getMeasurementSchema().getProps(), deletionList);
    }

    @Override
    public List<IChunkMetadata> getVisibleMetadataListFromWriter(RestorableTsFileIOWriter writer, TsFileResource tsFileResource, QueryContext context, long timeLowerBound) {
        List<Modification> modifications = context.getPathModifications(tsFileResource, (PartialPath)this.partialPath);
        ArrayList<IChunkMetadata> chunkMetadataList = new ArrayList<IChunkMetadata>(writer.getVisibleMetadataList(this.partialPath.getIDeviceID(), this.partialPath.getMeasurement(), this.partialPath.getSeriesType()));
        ModificationUtils.modifyChunkMetaData(chunkMetadataList, modifications);
        chunkMetadataList.removeIf(x -> x.getEndTime() < timeLowerBound);
        return chunkMetadataList;
    }
}

