/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import java.util.Arrays;
import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaRequestMessage;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExtensionObject;
import org.eclipse.milo.opcua.stack.core.types.enumerated.TimestampsToReturn;
import org.eclipse.milo.opcua.stack.core.types.structured.HistoryReadValueId;
import org.eclipse.milo.opcua.stack.core.types.structured.RequestHeader;
import org.eclipse.milo.opcua.stack.core.types.structured.Structure;

public class HistoryReadRequest
extends Structure
implements UaRequestMessage {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=662");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=664");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=663");
    private final RequestHeader requestHeader;
    private final ExtensionObject historyReadDetails;
    private final TimestampsToReturn timestampsToReturn;
    private final Boolean releaseContinuationPoints;
    private final HistoryReadValueId[] nodesToRead;

    public HistoryReadRequest(RequestHeader requestHeader, ExtensionObject historyReadDetails, TimestampsToReturn timestampsToReturn, Boolean releaseContinuationPoints, HistoryReadValueId[] nodesToRead) {
        this.requestHeader = requestHeader;
        this.historyReadDetails = historyReadDetails;
        this.timestampsToReturn = timestampsToReturn;
        this.releaseContinuationPoints = releaseContinuationPoints;
        this.nodesToRead = nodesToRead;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    @Override
    public RequestHeader getRequestHeader() {
        return this.requestHeader;
    }

    public ExtensionObject getHistoryReadDetails() {
        return this.historyReadDetails;
    }

    public TimestampsToReturn getTimestampsToReturn() {
        return this.timestampsToReturn;
    }

    public Boolean getReleaseContinuationPoints() {
        return this.releaseContinuationPoints;
    }

    public HistoryReadValueId[] getNodesToRead() {
        return this.nodesToRead;
    }

    protected HistoryReadRequest(HistoryReadRequestBuilder<?, ?> b) {
        super(b);
        this.requestHeader = ((HistoryReadRequestBuilder)b).requestHeader;
        this.historyReadDetails = ((HistoryReadRequestBuilder)b).historyReadDetails;
        this.timestampsToReturn = ((HistoryReadRequestBuilder)b).timestampsToReturn;
        this.releaseContinuationPoints = ((HistoryReadRequestBuilder)b).releaseContinuationPoints;
        this.nodesToRead = ((HistoryReadRequestBuilder)b).nodesToRead;
    }

    public static HistoryReadRequestBuilder<?, ?> builder() {
        return new HistoryReadRequestBuilderImpl();
    }

    public HistoryReadRequestBuilder<?, ?> toBuilder() {
        return new HistoryReadRequestBuilderImpl().$fillValuesFrom(this);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HistoryReadRequest)) {
            return false;
        }
        HistoryReadRequest other = (HistoryReadRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$releaseContinuationPoints = this.getReleaseContinuationPoints();
        Boolean other$releaseContinuationPoints = other.getReleaseContinuationPoints();
        if (this$releaseContinuationPoints == null ? other$releaseContinuationPoints != null : !((Object)this$releaseContinuationPoints).equals(other$releaseContinuationPoints)) {
            return false;
        }
        RequestHeader this$requestHeader = this.getRequestHeader();
        RequestHeader other$requestHeader = other.getRequestHeader();
        if (this$requestHeader == null ? other$requestHeader != null : !((Object)this$requestHeader).equals(other$requestHeader)) {
            return false;
        }
        ExtensionObject this$historyReadDetails = this.getHistoryReadDetails();
        ExtensionObject other$historyReadDetails = other.getHistoryReadDetails();
        if (this$historyReadDetails == null ? other$historyReadDetails != null : !((Object)this$historyReadDetails).equals(other$historyReadDetails)) {
            return false;
        }
        TimestampsToReturn this$timestampsToReturn = this.getTimestampsToReturn();
        TimestampsToReturn other$timestampsToReturn = other.getTimestampsToReturn();
        if (this$timestampsToReturn == null ? other$timestampsToReturn != null : !this$timestampsToReturn.equals(other$timestampsToReturn)) {
            return false;
        }
        return Arrays.deepEquals(this.getNodesToRead(), other.getNodesToRead());
    }

    protected boolean canEqual(Object other) {
        return other instanceof HistoryReadRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $releaseContinuationPoints = this.getReleaseContinuationPoints();
        result = result * 59 + ($releaseContinuationPoints == null ? 43 : ((Object)$releaseContinuationPoints).hashCode());
        RequestHeader $requestHeader = this.getRequestHeader();
        result = result * 59 + ($requestHeader == null ? 43 : ((Object)$requestHeader).hashCode());
        ExtensionObject $historyReadDetails = this.getHistoryReadDetails();
        result = result * 59 + ($historyReadDetails == null ? 43 : ((Object)$historyReadDetails).hashCode());
        TimestampsToReturn $timestampsToReturn = this.getTimestampsToReturn();
        result = result * 59 + ($timestampsToReturn == null ? 43 : $timestampsToReturn.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getNodesToRead());
        return result;
    }

    @Override
    public String toString() {
        return "HistoryReadRequest(requestHeader=" + this.getRequestHeader() + ", historyReadDetails=" + this.getHistoryReadDetails() + ", timestampsToReturn=" + this.getTimestampsToReturn() + ", releaseContinuationPoints=" + this.getReleaseContinuationPoints() + ", nodesToRead=" + Arrays.deepToString(this.getNodesToRead()) + ")";
    }

    private static final class HistoryReadRequestBuilderImpl
    extends HistoryReadRequestBuilder<HistoryReadRequest, HistoryReadRequestBuilderImpl> {
        private HistoryReadRequestBuilderImpl() {
        }

        @Override
        protected HistoryReadRequestBuilderImpl self() {
            return this;
        }

        @Override
        public HistoryReadRequest build() {
            return new HistoryReadRequest(this);
        }
    }

    public static abstract class HistoryReadRequestBuilder<C extends HistoryReadRequest, B extends HistoryReadRequestBuilder<C, B>>
    extends Structure.StructureBuilder<C, B> {
        private RequestHeader requestHeader;
        private ExtensionObject historyReadDetails;
        private TimestampsToReturn timestampsToReturn;
        private Boolean releaseContinuationPoints;
        private HistoryReadValueId[] nodesToRead;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            HistoryReadRequestBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(HistoryReadRequest instance, HistoryReadRequestBuilder<?, ?> b) {
            b.requestHeader(instance.requestHeader);
            b.historyReadDetails(instance.historyReadDetails);
            b.timestampsToReturn(instance.timestampsToReturn);
            b.releaseContinuationPoints(instance.releaseContinuationPoints);
            b.nodesToRead(instance.nodesToRead);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B requestHeader(RequestHeader requestHeader) {
            this.requestHeader = requestHeader;
            return (B)this.self();
        }

        public B historyReadDetails(ExtensionObject historyReadDetails) {
            this.historyReadDetails = historyReadDetails;
            return (B)this.self();
        }

        public B timestampsToReturn(TimestampsToReturn timestampsToReturn) {
            this.timestampsToReturn = timestampsToReturn;
            return (B)this.self();
        }

        public B releaseContinuationPoints(Boolean releaseContinuationPoints) {
            this.releaseContinuationPoints = releaseContinuationPoints;
            return (B)this.self();
        }

        public B nodesToRead(HistoryReadValueId[] nodesToRead) {
            this.nodesToRead = nodesToRead;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "HistoryReadRequest.HistoryReadRequestBuilder(super=" + super.toString() + ", requestHeader=" + this.requestHeader + ", historyReadDetails=" + this.historyReadDetails + ", timestampsToReturn=" + this.timestampsToReturn + ", releaseContinuationPoints=" + this.releaseContinuationPoints + ", nodesToRead=" + Arrays.deepToString(this.nodesToRead) + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<HistoryReadRequest> {
        @Override
        public Class<HistoryReadRequest> getType() {
            return HistoryReadRequest.class;
        }

        @Override
        public HistoryReadRequest decode(SerializationContext context, UaDecoder decoder) {
            RequestHeader requestHeader = (RequestHeader)decoder.readStruct("RequestHeader", RequestHeader.TYPE_ID);
            ExtensionObject historyReadDetails = decoder.readExtensionObject("HistoryReadDetails");
            TimestampsToReturn timestampsToReturn = decoder.readEnum("TimestampsToReturn", TimestampsToReturn.class);
            Boolean releaseContinuationPoints = decoder.readBoolean("ReleaseContinuationPoints");
            HistoryReadValueId[] nodesToRead = (HistoryReadValueId[])decoder.readStructArray("NodesToRead", HistoryReadValueId.TYPE_ID);
            return new HistoryReadRequest(requestHeader, historyReadDetails, timestampsToReturn, releaseContinuationPoints, nodesToRead);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, HistoryReadRequest value) {
            encoder.writeStruct("RequestHeader", (Object)value.getRequestHeader(), RequestHeader.TYPE_ID);
            encoder.writeExtensionObject("HistoryReadDetails", value.getHistoryReadDetails());
            encoder.writeEnum("TimestampsToReturn", value.getTimestampsToReturn());
            encoder.writeBoolean("ReleaseContinuationPoints", value.getReleaseContinuationPoints());
            encoder.writeStructArray("NodesToRead", (Object[])value.getNodesToRead(), HistoryReadValueId.TYPE_ID);
        }
    }
}

