/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.server.storage.redis;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.seata.common.exception.StoreException;
import org.apache.seata.common.io.FileLoader;
import org.apache.seata.server.storage.redis.JedisPooledFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.exceptions.JedisDataException;
import redis.clients.jedis.exceptions.JedisNoScriptException;

public class LuaParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(LuaParser.class);
    private static final String WHITE_SPACE = " ";
    private static final String ANNOTATION_LUA = "--";
    private static final Map<String, String> LUA_FILE_MAP = new HashMap();
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public static Map<String, String> getEvalShaMapFromFile(String fileName) throws IOException {
        ConcurrentHashMap<String, String> concurrentHashMap;
        block18: {
            File luaFile = FileLoader.load((String)fileName);
            if (luaFile == null) {
                throw new IOException("no lua file: " + fileName);
            }
            StringBuilder luaByFile = new StringBuilder();
            try (FileInputStream fis = new FileInputStream(luaFile);){
                String line;
                BufferedReader br = new BufferedReader(new InputStreamReader(fis));
                while ((line = br.readLine()) != null) {
                    if (line.trim().startsWith(ANNOTATION_LUA)) continue;
                    luaByFile.append(line);
                    luaByFile.append(WHITE_SPACE);
                }
            }
            catch (IOException e) {
                throw new IOException(e);
            }
            LUA_FILE_MAP.put(fileName, luaByFile.toString());
            ConcurrentHashMap<String, String> resultMap = new ConcurrentHashMap<String, String>(1);
            Jedis jedis = JedisPooledFactory.getJedisInstance();
            try {
                resultMap.put(fileName, jedis.scriptLoad(luaByFile.toString()));
                concurrentHashMap = resultMap;
                if (jedis == null) break block18;
            }
            catch (Throwable throwable) {
                try {
                    if (jedis != null) {
                        try {
                            jedis.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (UnsupportedOperationException | JedisDataException e) {
                    throw new IOException(e);
                }
            }
            jedis.close();
        }
        return concurrentHashMap;
    }

    public static <T> T getObjectFromJson(String json, Class<T> classz) {
        try {
            return (T)OBJECT_MAPPER.readValue(json, classz);
        }
        catch (JsonProcessingException e) {
            throw new StoreException(e.getMessage());
        }
    }

    public static <T> List<T> getListFromJson(String json, Class<T> classz) {
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            return (List)objectMapper.readValue(json, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (JsonProcessingException e) {
            throw new StoreException(e.getMessage());
        }
    }

    public static Object jedisEvalSha(Jedis jedis, String luaSHA, String luaFileName, List<String> keys, List<String> args) {
        try {
            return jedis.evalsha(luaSHA, keys, args);
        }
        catch (JedisNoScriptException e) {
            LOGGER.warn("try to reload the lua script and execute,jedis ex: " + e.getMessage());
            jedis.scriptLoad((String)LUA_FILE_MAP.get(luaFileName));
            return jedis.evalsha(luaSHA, keys, args);
        }
    }
}

