/*
 * Decompiled with CFR 0.152.
 */
package io.etcd.jetcd;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.protobuf.ByteString;
import io.etcd.jetcd.ByteSequence;
import io.etcd.jetcd.ClientBuilder;
import io.etcd.jetcd.Util;
import io.etcd.jetcd.api.AuthGrpc;
import io.etcd.jetcd.api.AuthenticateRequest;
import io.etcd.jetcd.api.AuthenticateResponse;
import io.etcd.jetcd.common.exception.ErrorCode;
import io.etcd.jetcd.common.exception.EtcdExceptionFactory;
import io.etcd.jetcd.resolver.SmartNameResolverFactory;
import io.etcd.jetcd.resolver.URIResolverLoader;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ForwardingClientCall;
import io.grpc.ForwardingClientCallListener;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import io.grpc.netty.NegotiationType;
import io.grpc.netty.NettyChannelBuilder;
import io.grpc.stub.AbstractStub;
import java.net.URI;
import java.time.Duration;
import java.util.Collections;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.jodah.failsafe.Failsafe;
import net.jodah.failsafe.Policy;
import net.jodah.failsafe.RetryPolicy;

final class ClientConnectionManager {
    private static final Metadata.Key<String> TOKEN = Metadata.Key.of((String)"token", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
    private final ClientBuilder builder;
    private final AtomicReference<ManagedChannel> channelRef;
    private final AtomicReference<Optional<String>> tokenRef;
    private final ExecutorService executorService;

    ClientConnectionManager(ClientBuilder builder) {
        this(builder, null);
    }

    ClientConnectionManager(ClientBuilder builder, ManagedChannel channel) {
        this.builder = builder;
        this.channelRef = new AtomicReference<ManagedChannel>(channel);
        this.tokenRef = new AtomicReference();
        this.executorService = builder.executorService() == null ? Executors.newCachedThreadPool() : builder.executorService();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ManagedChannel getChannel() {
        ManagedChannel managedChannel = this.channelRef.get();
        if (managedChannel == null) {
            AtomicReference<ManagedChannel> atomicReference = this.channelRef;
            synchronized (atomicReference) {
                managedChannel = this.channelRef.get();
                if (managedChannel == null) {
                    managedChannel = this.defaultChannelBuilder().build();
                    this.channelRef.lazySet(managedChannel);
                }
            }
        }
        return managedChannel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Optional<String> getToken(Channel channel) {
        Optional<String> tk = this.tokenRef.get();
        if (tk == null) {
            AtomicReference<Optional<String>> atomicReference = this.tokenRef;
            synchronized (atomicReference) {
                tk = this.tokenRef.get();
                if (tk == null) {
                    tk = this.generateToken(channel);
                    this.tokenRef.lazySet(tk);
                }
            }
        }
        return tk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshToken(Channel channel) {
        AtomicReference<Optional<String>> atomicReference = this.tokenRef;
        synchronized (atomicReference) {
            Optional<String> tk = this.generateToken(channel);
            this.tokenRef.lazySet(tk);
        }
    }

    ByteSequence getNamespace() {
        return this.builder.namespace();
    }

    ExecutorService getExecutorService() {
        return this.executorService;
    }

    <T extends AbstractStub<T>> T newStub(Function<ManagedChannel, T> supplier) {
        return (T)((AbstractStub)supplier.apply(this.getChannel()));
    }

    synchronized void close() {
        ManagedChannel channel = this.channelRef.get();
        if (channel != null) {
            channel.shutdownNow();
        }
        this.executorService.shutdownNow();
    }

    <T extends AbstractStub<T>, R> CompletableFuture<R> withNewChannel(URI endpoint, Function<ManagedChannel, T> stubCustomizer, Function<T, CompletableFuture<R>> stubConsumer) {
        ManagedChannel channel = this.defaultChannelBuilder().nameResolverFactory(SmartNameResolverFactory.forEndpoints(Util.supplyIfNull(this.builder.authority(), () -> "etcd"), Collections.singleton(endpoint), Util.supplyIfNull(this.builder.uriResolverLoader(), URIResolverLoader::defaultLoader))).build();
        try {
            AbstractStub stub = (AbstractStub)stubCustomizer.apply(channel);
            return stubConsumer.apply(stub).whenComplete((r, t) -> channel.shutdown());
        }
        catch (Exception e) {
            channel.shutdown();
            throw EtcdExceptionFactory.toEtcdException(e);
        }
    }

    @VisibleForTesting
    protected ManagedChannelBuilder<?> defaultChannelBuilder() {
        NettyChannelBuilder channelBuilder = NettyChannelBuilder.forTarget((String)"etcd");
        if (this.builder.maxInboundMessageSize() != null) {
            channelBuilder.maxInboundMessageSize(this.builder.maxInboundMessageSize().intValue());
        }
        if (this.builder.sslContext() != null) {
            channelBuilder.negotiationType(NegotiationType.TLS);
            channelBuilder.sslContext(this.builder.sslContext());
        } else {
            channelBuilder.negotiationType(NegotiationType.PLAINTEXT);
        }
        channelBuilder.nameResolverFactory(SmartNameResolverFactory.forEndpoints(Util.supplyIfNull(this.builder.authority(), () -> "etcd"), this.builder.endpoints(), Util.supplyIfNull(this.builder.uriResolverLoader(), URIResolverLoader::defaultLoader)));
        if (this.builder.loadBalancerPolicy() != null) {
            channelBuilder.defaultLoadBalancingPolicy(this.builder.loadBalancerPolicy());
        } else {
            channelBuilder.defaultLoadBalancingPolicy("pick_first");
        }
        channelBuilder.intercept(new ClientInterceptor[]{new AuthTokenInterceptor()});
        if (this.builder.headers() != null) {
            channelBuilder.intercept(new ClientInterceptor[]{new ClientInterceptor(){

                public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
                    return new ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT>(next.newCall(method, callOptions)){

                        public void start(ClientCall.Listener<RespT> responseListener, Metadata headers) {
                            ClientConnectionManager.this.builder.headers().forEach((arg_0, arg_1) -> ((Metadata)headers).put(arg_0, arg_1));
                            super.start(responseListener, headers);
                        }
                    };
                }
            }});
        }
        if (this.builder.interceptors() != null) {
            channelBuilder.intercept(this.builder.interceptors());
        }
        return channelBuilder;
    }

    private static ListenableFuture<AuthenticateResponse> authenticate(@Nonnull Channel channel, @Nonnull ByteSequence username, @Nonnull ByteSequence password) {
        ByteString user = username.getByteString();
        ByteString pass = password.getByteString();
        Preconditions.checkArgument((!user.isEmpty() ? 1 : 0) != 0, (Object)"username can not be empty.");
        Preconditions.checkArgument((!pass.isEmpty() ? 1 : 0) != 0, (Object)"password can not be empty.");
        return AuthGrpc.newFutureStub(channel).authenticate(AuthenticateRequest.newBuilder().setNameBytes(user).setPasswordBytes(pass).build());
    }

    private Optional<String> generateToken(Channel channel) {
        if (this.builder.user() != null && this.builder.password() != null) {
            try {
                return Optional.of(((AuthenticateResponse)ClientConnectionManager.authenticate(channel, this.builder.user(), this.builder.password()).get()).getToken());
            }
            catch (InterruptedException ite) {
                throw EtcdExceptionFactory.handleInterrupt(ite);
            }
            catch (ExecutionException exee) {
                throw EtcdExceptionFactory.toEtcdException(exee);
            }
        }
        return Optional.empty();
    }

    public <S, T> CompletableFuture<T> execute(Callable<ListenableFuture<S>> task, Function<S, T> resultConvert) {
        return this.execute(task, resultConvert, Util::isRetryable);
    }

    public <S, T> CompletableFuture<T> execute(Callable<ListenableFuture<S>> task, Function<S, T> resultConvert, Predicate<Throwable> doRetry) {
        RetryPolicy retryPolicy = ((RetryPolicy)new RetryPolicy().handleIf(doRetry::test)).onRetriesExceeded(e -> EtcdExceptionFactory.newEtcdException(ErrorCode.ABORTED, "maximum number of auto retries reached")).withBackoff(this.builder.retryDelay(), this.builder.retryMaxDelay(), this.builder.retryChronoUnit());
        if (this.builder.retryMaxDuration() != null) {
            retryPolicy = retryPolicy.withMaxDuration(Duration.parse(this.builder.retryMaxDuration()));
        }
        return Failsafe.with((Policy[])new RetryPolicy[]{retryPolicy}).with(this.executorService).getAsync(() -> ((ListenableFuture)task.call()).get()).thenApply(resultConvert);
    }

    private class AuthTokenInterceptor
    implements ClientInterceptor {
        private AuthTokenInterceptor() {
        }

        public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, final Channel next) {
            return new ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT>(next.newCall(method, callOptions)){

                public void start(ClientCall.Listener<RespT> responseListener, Metadata headers) {
                    ClientConnectionManager.this.getToken(next).ifPresent(t -> headers.put(TOKEN, t));
                    super.start((ClientCall.Listener)new ForwardingClientCallListener.SimpleForwardingClientCallListener<RespT>(responseListener){

                        public void onClose(Status status, Metadata trailers) {
                            if (Util.isInvalidTokenError(status)) {
                                try {
                                    ClientConnectionManager.this.refreshToken(next);
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                            super.onClose(status, trailers);
                        }
                    }, headers);
                }
            };
        }
    }
}

