/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.auth.internal.broker;

import jakarta.annotation.Nullable;
import org.apache.polaris.immutables.PolarisImmutable;
import org.apache.polaris.service.auth.internal.broker.ImmutableTokenResponse;
import org.apache.polaris.service.auth.internal.service.OAuthError;
import org.immutables.value.Value;

@PolarisImmutable
public interface TokenResponse {
    public static TokenResponse of(String accessToken, String tokenType, int expiresIn) {
        return ImmutableTokenResponse.builder().accessToken(accessToken).tokenType(tokenType).expiresIn(expiresIn).build();
    }

    public static TokenResponse of(OAuthError error) {
        return ImmutableTokenResponse.builder().error(error).build();
    }

    @Nullable
    public OAuthError getError();

    @Nullable
    public String getAccessToken();

    @Value.Default
    default public int getExpiresIn() {
        return 0;
    }

    @Nullable
    public String getTokenType();
}

