/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.auth;

import io.smallrye.config.WithDefault;
import java.nio.file.Path;
import java.time.Duration;
import java.util.Optional;
import org.apache.polaris.service.auth.AuthenticationType;

public interface AuthenticationRealmConfiguration {
    @WithDefault(value="internal")
    public AuthenticationType type();

    public AuthenticatorConfiguration authenticator();

    public TokenServiceConfiguration tokenService();

    public TokenBrokerConfiguration tokenBroker();

    public static interface TokenBrokerConfiguration {
        @WithDefault(value="PT1H")
        public Duration maxTokenGeneration();

        @WithDefault(value="rsa-key-pair")
        public String type();

        public Optional<RSAKeyPairConfiguration> rsaKeyPair();

        public Optional<SymmetricKeyConfiguration> symmetricKey();

        public static interface SymmetricKeyConfiguration {
            public Optional<String> secret();

            public Optional<Path> file();
        }

        public static interface RSAKeyPairConfiguration {
            public Path publicKeyFile();

            public Path privateKeyFile();
        }
    }

    public static interface TokenServiceConfiguration {
        @WithDefault(value="default")
        public String type();
    }

    public static interface AuthenticatorConfiguration {
        @WithDefault(value="default")
        public String type();
    }
}

