/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.core.admin.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.polaris.core.admin.model.CatalogRole;

public class CatalogRoles {
    @NotNull
    @Valid
    private final @NotNull @Valid List<@Valid CatalogRole> roles;

    @ApiModelProperty(required=true, value="The list of catalog roles")
    @JsonProperty(value="roles", required=true)
    public List<@Valid CatalogRole> getRoles() {
        return this.roles;
    }

    @JsonCreator
    public CatalogRoles(@JsonProperty(value="roles", required=true) List<@Valid CatalogRole> roles) {
        this.roles = Objects.requireNonNullElse(roles, new ArrayList());
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(List<@Valid CatalogRole> roles) {
        return new Builder(roles);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CatalogRoles catalogRoles = (CatalogRoles)o;
        return Objects.equals(this.roles, catalogRoles.roles);
    }

    public int hashCode() {
        return Objects.hash(this.roles);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CatalogRoles {\n");
        sb.append("    roles: ").append(this.toIndentedString(this.roles)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static final class Builder {
        private List<@Valid CatalogRole> roles;

        private Builder() {
        }

        private Builder(List<@Valid CatalogRole> roles) {
            this.roles = Objects.requireNonNullElse(roles, new ArrayList());
        }

        public Builder setRoles(List<@Valid CatalogRole> roles) {
            this.roles = roles;
            return this;
        }

        public CatalogRoles build() {
            CatalogRoles inst = new CatalogRoles(this.roles);
            return inst;
        }
    }
}

