/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.monitor.aop;

import com.xiaomi.mone.tpc.login.util.UserUtil;
import com.xiaomi.mone.tpc.login.vo.AuthUserVo;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ThreadPoolExecutor;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.ozhera.monitor.aop.HeraRequestMapping;
import org.apache.ozhera.monitor.bo.HeraReqInfo;
import org.apache.ozhera.monitor.service.aop.action.HeraRequestMappingAction;
import org.apache.ozhera.monitor.service.aop.context.HeraRequestMappingContext;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Configuration;

@Aspect
@Configuration
public class HeraRequestMappingAspect {
    private static final Logger log = LoggerFactory.getLogger(HeraRequestMappingAspect.class);
    @Autowired
    private ApplicationContext applicationContext;
    @Resource(name="heraRequestMappingExecutor")
    private ThreadPoolExecutor heraRequestMappingExecutor;

    @Pointcut(value="@annotation(org.apache.ozhera.monitor.aop.HeraRequestMapping)")
    public void operationLog() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="operationLog()")
    public Object doAround(ProceedingJoinPoint joinPoint) throws Throwable {
        try {
            MethodSignature methodSignature = (MethodSignature)joinPoint.getSignature();
            Method method = methodSignature.getMethod();
            Object[] args = joinPoint.getArgs();
            if (args == null) {
                args = new Object[]{};
            }
            String reqUrl = null;
            String user = null;
            for (Object arg : args) {
                if (!(arg instanceof HttpServletRequest)) continue;
                reqUrl = ((HttpServletRequest)arg).getServletPath();
                AuthUserVo userInfo = UserUtil.getUser();
                if (userInfo == null) break;
                user = userInfo.genFullAccount();
                break;
            }
            HeraRequestMapping anno = method.getAnnotation(HeraRequestMapping.class);
            HeraReqInfo heraReqInfo = HeraReqInfo.builder().reqUrl(reqUrl).user(user).moduleName(anno.interfaceName().getModuleName().getCode()).interfaceName(anno.interfaceName().getCode()).build();
            Object beanObj = this.applicationContext.getBean(anno.actionClass());
            if (beanObj instanceof HeraRequestMappingAction) {
                Object object;
                HeraRequestMappingAction beanAction = (HeraRequestMappingAction)beanObj;
                beanAction.beforeAction(args, heraReqInfo);
                Object result = null;
                try {
                    object = result = joinPoint.proceed();
                }
                catch (Throwable throwable) {
                    if (heraReqInfo.getOperLog() != null && heraReqInfo.getOperLog().getId() != null) {
                        Object aResult = result;
                        Object[] aArgs = args;
                        Map map = HeraRequestMappingContext.getAll();
                        this.heraRequestMappingExecutor.execute(new Runnable(){
                            final /* synthetic */ Map val$map;
                            final /* synthetic */ HeraRequestMappingAction val$beanAction;
                            final /* synthetic */ Object[] val$aArgs;
                            final /* synthetic */ HeraReqInfo val$heraReqInfo;
                            final /* synthetic */ Object val$aResult;
                            {
                                this.val$map = map;
                                this.val$beanAction = heraRequestMappingAction;
                                this.val$aArgs = objectArray;
                                this.val$heraReqInfo = heraReqInfo;
                                this.val$aResult = object;
                            }

                            @Override
                            public void run() {
                                HeraRequestMappingContext.putAll((Map)this.val$map);
                                try {
                                    this.val$beanAction.afterAction(this.val$aArgs, this.val$heraReqInfo, this.val$aResult);
                                }
                                finally {
                                    HeraRequestMappingContext.clearAll();
                                }
                            }
                        });
                    }
                    throw throwable;
                }
                if (heraReqInfo.getOperLog() != null && heraReqInfo.getOperLog().getId() != null) {
                    Object aResult = result;
                    Object[] aArgs = args;
                    Map map = HeraRequestMappingContext.getAll();
                    this.heraRequestMappingExecutor.execute(new /* invalid duplicate definition of identical inner class */);
                }
                return object;
            }
            Object object = joinPoint.proceed();
            return object;
        }
        finally {
            HeraRequestMappingContext.clearAll();
        }
    }
}

