/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.dao.impl.jdbc.mysql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import org.nutz.dao.DB;
import org.nutz.dao.Dao;
import org.nutz.dao.Sqls;
import org.nutz.dao.entity.Entity;
import org.nutz.dao.entity.LinkField;
import org.nutz.dao.entity.MappingField;
import org.nutz.dao.entity.PkType;
import org.nutz.dao.entity.annotation.ColType;
import org.nutz.dao.impl.jdbc.AbstractJdbcExpert;
import org.nutz.dao.impl.jdbc.mysql.MysqlJsonAdaptor;
import org.nutz.dao.jdbc.JdbcExpertConfigFile;
import org.nutz.dao.jdbc.ValueAdaptor;
import org.nutz.dao.pager.Pager;
import org.nutz.dao.sql.Pojo;
import org.nutz.dao.sql.Sql;
import org.nutz.dao.util.Pojos;
import org.nutz.log.Log;
import org.nutz.log.Logs;

public class MysqlJdbcExpert
extends AbstractJdbcExpert {
    protected static final String META_ENGINE = "mysql-engine";
    protected static final String META_CHARSET = "mysql-charset";
    protected static final String META_INTLEN = "mysql-intlen";
    private static final Log log = Logs.get();

    public MysqlJdbcExpert(JdbcExpertConfigFile conf) {
        super(conf);
    }

    @Override
    public String getDatabaseType() {
        return DB.MYSQL.name();
    }

    @Override
    public void formatQuery(Pojo pojo) {
        Pager pager = pojo.getContext().getPager();
        if (null != pager && pager.getPageNumber() > 0) {
            pojo.append(Pojos.Items.wrapf(" LIMIT %d, %d", pager.getOffset(), pager.getPageSize()));
        }
    }

    @Override
    public void formatQuery(Sql sql) {
        Pager pager = sql.getContext().getPager();
        if (null != pager && pager.getPageNumber() > 0) {
            sql.setSourceSql(sql.getSourceSql() + String.format(" LIMIT %d, %d", pager.getOffset(), pager.getPageSize()));
        }
    }

    @Override
    public String evalFieldType(MappingField mf) {
        if (mf.getCustomDbType() != null) {
            return mf.getCustomDbType();
        }
        int intLen = 4;
        if (mf.getEntity().hasMeta(META_INTLEN)) {
            intLen = ((Number)mf.getEntity().getMeta(META_INTLEN)).intValue();
        }
        if (mf.getColumnType() == ColType.INT) {
            int width = mf.getWidth();
            if (width <= 0) {
                return "INT(32)";
            }
            if (width <= 2) {
                return "TINYINT(" + width * intLen + ")";
            }
            if (width <= 4) {
                return "MEDIUMINT(" + width * intLen + ")";
            }
            if (width <= 8) {
                return "INT(" + width * intLen + ")";
            }
            return "BIGINT(" + width * intLen + ")";
        }
        if (mf.getColumnType() == ColType.BINARY) {
            return "MediumBlob";
        }
        if (mf.getColumnType() == ColType.MYSQL_JSON) {
            return "JSON";
        }
        return super.evalFieldType(mf);
    }

    @Override
    public boolean createEntity(Dao dao, Entity<?> en) {
        StringBuilder sb = new StringBuilder("CREATE TABLE " + en.getTableName() + "(");
        for (MappingField mf : en.getMappingFields()) {
            if (mf.isReadonly()) continue;
            sb.append('\n').append(mf.getColumnNameInSql());
            sb.append(' ').append(this.evalFieldType(mf));
            if (mf.isName() && en.getPkType() != PkType.NAME) {
                sb.append(" UNIQUE NOT NULL");
            } else {
                if (mf.isUnsigned()) {
                    sb.append(" UNSIGNED");
                }
                if (mf.isNotNull()) {
                    sb.append(" NOT NULL");
                } else if (mf.getColumnType() == ColType.TIMESTAMP) {
                    sb.append(" NULL");
                }
                if (mf.isAutoIncreasement()) {
                    sb.append(" AUTO_INCREMENT");
                }
                if (mf.getColumnType() == ColType.TIMESTAMP) {
                    if (mf.hasDefaultValue()) {
                        sb.append(" ").append(this.getDefaultValue(mf));
                    } else if (mf.isNotNull()) {
                        sb.append(" DEFAULT 0");
                    } else {
                        sb.append(" DEFAULT NULL");
                    }
                } else if (mf.hasDefaultValue()) {
                    this.addDefaultValue(sb, mf);
                }
            }
            if (mf.hasColumnComment()) {
                sb.append(" COMMENT '").append(mf.getColumnComment()).append("'");
            }
            sb.append(',');
        }
        List<MappingField> pks = en.getPks();
        if (!pks.isEmpty()) {
            sb.append('\n');
            sb.append("PRIMARY KEY (");
            for (MappingField pk : pks) {
                sb.append(pk.getColumnNameInSql()).append(',');
            }
            sb.setCharAt(sb.length() - 1, ')');
            sb.append("\n ");
        }
        sb.setCharAt(sb.length() - 1, ')');
        if (en.hasMeta(META_ENGINE)) {
            sb.append(" ENGINE=" + en.getMeta(META_ENGINE));
        }
        if (en.hasMeta(META_CHARSET)) {
            sb.append(" CHARSET=" + en.getMeta(META_CHARSET));
        } else {
            sb.append(" CHARSET=utf8");
        }
        if (en.hasTableComment()) {
            sb.append(" COMMENT='").append(en.getTableComment()).append("'");
        }
        dao.execute(Sqls.create(sb.toString()));
        dao.execute(this.createIndexs(en).toArray(new Sql[0]));
        this.createRelation(dao, en);
        return true;
    }

    @Override
    protected String createResultSetMetaSql(Entity<?> en) {
        return "SELECT * FROM " + en.getViewName() + " LIMIT 1";
    }

    @Override
    public Pojo fetchPojoId(Entity<?> en, MappingField idField) {
        return null;
    }

    @Override
    public ValueAdaptor getAdaptor(MappingField ef) {
        if (ColType.MYSQL_JSON == ef.getColumnType()) {
            return new MysqlJsonAdaptor();
        }
        return super.getAdaptor(ef);
    }

    @Override
    public void checkDataSource(Connection conn) throws SQLException {
        if (log.isDebugEnabled()) {
            String sql = "SHOW VARIABLES LIKE 'character_set%'";
            Statement stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery(sql);
            while (rs.next()) {
                log.debugf("Mysql : %s=%s", rs.getString(1), rs.getString(2));
            }
            rs.close();
            sql = "SHOW VARIABLES LIKE 'binlog_format'";
            stmt = conn.createStatement();
            rs = stmt.executeQuery(sql);
            while (rs.next()) {
                log.debugf("Mysql : %s=%s", rs.getString(1), rs.getString(2));
            }
            rs.close();
            String dbName = "";
            rs = stmt.executeQuery("SELECT DATABASE()");
            if (rs.next()) {
                dbName = rs.getString(1);
                log.debug("Mysql : database=" + dbName);
            }
            rs.close();
            rs = stmt.executeQuery("SELECT USER()");
            if (rs.next()) {
                log.debug("Mysql : user=" + rs.getString(1));
            }
            rs.close();
            stmt.close();
            PreparedStatement pstmt = conn.prepareStatement("SELECT TABLE_NAME FROM information_schema.TABLES where TABLE_SCHEMA = ? and engine = 'MyISAM'");
            pstmt.setString(1, dbName);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                log.debug("Mysql : '" + rs.getString(1) + "' engine=MyISAM");
            }
            rs.close();
            pstmt.close();
        }
    }

    @Override
    public boolean canCommentWhenAddIndex() {
        return true;
    }

    @Override
    protected Sql createRelation(Dao dao, LinkField lf) {
        Sql sql = super.createRelation(dao, lf);
        if (sql == null) {
            return null;
        }
        Entity<?> en = lf.getEntity();
        StringBuilder sb = new StringBuilder(sql.getSourceSql());
        if (en.hasMeta(META_ENGINE)) {
            sb.append(" ENGINE=" + en.getMeta(META_ENGINE));
        }
        if (en.hasMeta(META_CHARSET)) {
            sb.append(" CHARSET=" + en.getMeta(META_CHARSET));
        } else {
            sb.append(" CHARSET=utf8");
        }
        return Sqls.create(sb.toString());
    }
}

