/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.search;

import java.util.HashMap;
import java.util.Map;
import redis.clients.jedis.GeoCoordinate;
import redis.clients.jedis.util.SafeEncoder;

public class RediSearchUtil {
    public static Map<String, String> toStringMap(Map<String, Object> input) {
        HashMap<String, String> output = new HashMap<String, String>(input.size());
        for (Map.Entry<String, Object> entry : input.entrySet()) {
            String str;
            String key = entry.getKey();
            Object obj = entry.getValue();
            if (key == null || obj == null) {
                throw new NullPointerException("A null argument cannot be sent to Redis.");
            }
            if (obj instanceof byte[]) {
                str = SafeEncoder.encode((byte[])obj);
            } else if (obj instanceof GeoCoordinate) {
                GeoCoordinate geo = (GeoCoordinate)obj;
                str = geo.getLongitude() + "," + geo.getLatitude();
            } else {
                str = obj instanceof String ? (String)obj : obj.toString();
            }
            output.put(key, str);
        }
        return output;
    }

    private RediSearchUtil() {
        throw new InstantiationError("Must not instantiate this class");
    }
}

