/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.data.push.rpc.netty;

import com.xiaomi.data.push.rpc.netty.NettyRemotingClient;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.EventLoop;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionListener
implements ChannelFutureListener {
    private static final Logger logger = LoggerFactory.getLogger(ConnectionListener.class);
    private NettyRemotingClient client;

    public ConnectionListener(NettyRemotingClient client) {
        this.client = client;
    }

    public void operationComplete(ChannelFuture channelFuture) {
        if (!channelFuture.isSuccess()) {
            logger.info("Connection Reconnect");
            EventLoop loop = channelFuture.channel().eventLoop();
            loop.schedule(() -> {
                try {
                    this.client.createChannel();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }, 1L, TimeUnit.SECONDS);
        } else {
            logger.info("Connect server success");
        }
    }
}

