/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.log.manager.service.impl;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.lang.Pair;
import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.xiaomi.mone.es.EsClient;
import com.xiaomi.youpin.docean.Ioc;
import com.xiaomi.youpin.docean.common.StringUtils;
import com.xiaomi.youpin.docean.plugin.config.anno.Value;
import com.xiaomi.youpin.docean.plugin.dubbo.anno.Reference;
import com.xiaomi.youpin.docean.plugin.dubbo.anno.Service;
import com.xiaomi.youpin.docean.plugin.es.EsService;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.apache.ozhera.app.api.model.HeraAppEnvData;
import org.apache.ozhera.log.api.enums.LogStorageTypeEnum;
import org.apache.ozhera.log.api.model.dto.TraceLogDTO;
import org.apache.ozhera.log.api.model.vo.TraceLogQuery;
import org.apache.ozhera.log.api.service.LogDataService;
import org.apache.ozhera.log.common.Constant;
import org.apache.ozhera.log.common.Result;
import org.apache.ozhera.log.exception.CommonError;
import org.apache.ozhera.log.manager.common.context.MoneUserContext;
import org.apache.ozhera.log.manager.common.exception.MilogManageException;
import org.apache.ozhera.log.manager.common.utils.ExportUtils;
import org.apache.ozhera.log.manager.common.utils.ManagerUtil;
import org.apache.ozhera.log.manager.dao.MilogLogTailDao;
import org.apache.ozhera.log.manager.dao.MilogLogstoreDao;
import org.apache.ozhera.log.manager.dao.MilogSpaceDao;
import org.apache.ozhera.log.manager.domain.EsCluster;
import org.apache.ozhera.log.manager.domain.SearchLog;
import org.apache.ozhera.log.manager.domain.TraceLog;
import org.apache.ozhera.log.manager.mapper.MilogEsClusterMapper;
import org.apache.ozhera.log.manager.model.dto.EsStatisticResult;
import org.apache.ozhera.log.manager.model.dto.LogDTO;
import org.apache.ozhera.log.manager.model.dto.LogDataDTO;
import org.apache.ozhera.log.manager.model.pojo.MilogEsClusterDO;
import org.apache.ozhera.log.manager.model.pojo.MilogLogStoreDO;
import org.apache.ozhera.log.manager.model.pojo.MilogLogTailDo;
import org.apache.ozhera.log.manager.model.pojo.MilogSpaceDO;
import org.apache.ozhera.log.manager.model.vo.LogContextQuery;
import org.apache.ozhera.log.manager.model.vo.LogQuery;
import org.apache.ozhera.log.manager.model.vo.RegionTraceLogQuery;
import org.apache.ozhera.log.manager.model.vo.TraceAppLogUrlQuery;
import org.apache.ozhera.log.manager.service.EsDataBaseService;
import org.apache.ozhera.log.manager.service.EsDataService;
import org.apache.ozhera.log.manager.service.HeraAppEnvService;
import org.apache.ozhera.log.manager.service.extension.common.CommonExtensionService;
import org.apache.ozhera.log.manager.service.extension.common.CommonExtensionServiceFactory;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StopWatch;
import run.mone.excel.ExportExcel;

@com.xiaomi.youpin.docean.anno.Service
@Service(interfaceClass=LogDataService.class)
public class EsDataServiceImpl
implements EsDataService,
LogDataService,
EsDataBaseService {
    private static final Logger log = LoggerFactory.getLogger(EsDataServiceImpl.class);
    @Resource
    private MilogLogstoreDao logstoreDao;
    @Resource
    private MilogLogTailDao tailDao;
    @Resource
    private MilogSpaceDao spaceDao;
    @Resource
    private EsCluster esCluster;
    @Resource
    private TraceLog traceLog;
    @Resource
    private SearchLog searchLog;
    @Resource
    private MilogEsClusterMapper milogEsClusterMapper;
    @Value(value="$hera.url")
    private String heraUrl;
    @Reference(interfaceClass=LogDataService.class, group="$dubbo.youpin.group", check=false, timeout=5000)
    private LogDataService logDataService;
    private CommonExtensionService commonExtensionService;
    private Set<String> noHighLightSet = new HashSet<String>();
    private Set<String> hidenFiledSet = new HashSet<String>();
    @Resource
    private HeraAppEnvService heraAppEnvService;
    public static List<Pair<String, Pair<String, Integer>>> requiredFields = Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)"message", (Object)Pair.of((Object)"text", (Object)1)), Pair.of((Object)"logsource", (Object)Pair.of((Object)"text", (Object)1)), Pair.of((Object)"tailId", (Object)Pair.of((Object)"integer", (Object)3))});

    public EsDataServiceImpl() {
        this.noHighLightSet.add("logstore");
        this.noHighLightSet.add("tail");
        this.hidenFiledSet.add("mqtag");
        this.hidenFiledSet.add("mqtopic");
        this.hidenFiledSet.add("logstore");
        this.hidenFiledSet.add("linenumber");
        this.hidenFiledSet.add("filename");
    }

    public void init() {
        this.commonExtensionService = CommonExtensionServiceFactory.getCommonExtensionService();
    }

    @Override
    public Result<LogDTO> logQuery(LogQuery logQuery) {
        String operator = MoneUserContext.getCurrentUser() != null ? MoneUserContext.getCurrentUser().getUser() : "system";
        String logInfo = String.format("queryText:%s, user:%s, logQuery:%s", logQuery.getFullTextSearch(), operator, logQuery);
        log.info("query simple param:{}", (Object)logInfo);
        StopWatch stopWatch = new StopWatch("HERA-LOG-QUERY");
        try {
            MilogLogStoreDO milogLogstoreDO = this.logstoreDao.queryById(logQuery.getStoreId());
            if (milogLogstoreDO == null) {
                log.warn("[EsDataService.logQuery] not find logStore:[{}]", (Object)logQuery.getLogstore());
                return Result.failParam((String)("not found[" + logQuery.getLogstore() + "]The corresponding data"));
            }
            LogStorageTypeEnum storageTypeEnum = this.queryLogStorageTypeEnum(milogLogstoreDO.getEsClusterId());
            LogDTO dto = new LogDTO();
            List<String> keyList = ManagerUtil.getKeyList(milogLogstoreDO.getKeyList(), milogLogstoreDO.getColumnTypeList());
            if (LogStorageTypeEnum.DORIS == storageTypeEnum) {
                return this.dorisDataQuery(logQuery, milogLogstoreDO, dto);
            }
            return this.elasticDataQuery(milogLogstoreDO, logQuery, dto, keyList, stopWatch);
        }
        catch (Throwable e) {
            log.error("Log query error, log search error,logQuery:[{}],user:[{}]", new Object[]{logQuery, MoneUserContext.getCurrentUser(), e});
            return Result.failParam((String)e.getMessage());
        }
    }

    private LogStorageTypeEnum queryLogStorageTypeEnum(Long esClusterId) {
        MilogEsClusterDO esClusterDO = (MilogEsClusterDO)this.milogEsClusterMapper.selectById(esClusterId);
        LogStorageTypeEnum storageTypeEnum = LogStorageTypeEnum.queryByName((String)esClusterDO.getLogStorageType());
        return storageTypeEnum;
    }

    private Result<LogDTO> dorisDataQuery(LogQuery logQuery, MilogLogStoreDO milogLogstoreDO, LogDTO dto) {
        try {
            DataSource dataSource = (DataSource)Ioc.ins().getBean(Constant.LOG_STORAGE_SERV_BEAN_PRE + milogLogstoreDO.getEsClusterId());
            List<Map<String, Object>> tableColumnDTOS = this.queryResult(logQuery, milogLogstoreDO, dataSource);
            this.dorisDataToLog(tableColumnDTOS, dto);
            return Result.success((Object)dto);
        }
        catch (Exception e) {
            log.error("Doris data query error", (Throwable)e);
            return Result.failParam((String)e.getMessage());
        }
    }

    private Result<LogDTO> elasticDataQuery(MilogLogStoreDO milogLogstoreDO, LogQuery logQuery, LogDTO dto, List<String> keyList, StopWatch stopWatch) throws IOException {
        EsService esService = this.esCluster.getEsService(milogLogstoreDO.getEsClusterId());
        String esIndexName = this.commonExtensionService.getSearchIndex(logQuery.getStoreId(), milogLogstoreDO.getEsIndex());
        if (esService == null || StringUtils.isEmpty((String)esIndexName)) {
            log.warn("[EsDataService.logQuery] logStore:[{}] configuration exceptions", (Object)logQuery.getLogstore());
            return Result.failParam((String)"logStore configuration exceptions");
        }
        BoolQueryBuilder boolQueryBuilder = this.searchLog.getQueryBuilder(logQuery, ManagerUtil.getKeyColonPrefix(milogLogstoreDO.getKeyList()));
        SearchSourceBuilder builder = this.assembleSearchSourceBuilder(logQuery, keyList, boolQueryBuilder);
        SearchRequest searchRequest = new SearchRequest(new String[]{esIndexName}, builder);
        stopWatch.start("search-query");
        SearchResponse searchResponse = esService.search(searchRequest);
        stopWatch.stop();
        dto.setSourceBuilder(builder);
        if (stopWatch.getLastTaskTimeMillis() > 7000L) {
            log.warn("##LONG-COST-QUERY##{} cost:{} ms, msg:{}", (Object)stopWatch.getLastTaskName(), (Object)stopWatch.getLastTaskTimeMillis());
        }
        stopWatch.start("data-assemble");
        this.transformSearchResponse(searchResponse, dto, keyList);
        stopWatch.stop();
        if (stopWatch.getTotalTimeMillis() > 15000L) {
            log.warn("##LONG-COST-QUERY##{} cost:{} ms, msg:{}", (Object)"gt15s", (Object)stopWatch.getTotalTimeMillis());
        }
        return Result.success((Object)dto);
    }

    private void dorisDataToLog(List<Map<String, Object>> tableColumnDTOS, LogDTO logDTO) {
        ArrayList logDataList = Lists.newArrayList();
        for (Map<String, Object> columnMap : tableColumnDTOS) {
            LogDataDTO logData = new LogDataDTO();
            logData.setValue("timestamp", columnMap.get("timestamp"));
            for (String key : columnMap.keySet()) {
                if (this.hidenFiledSet.contains(key)) continue;
                logData.setValue(key, columnMap.get(key));
            }
            logData.setIp(columnMap.get("logip") == null ? "" : String.valueOf(columnMap.get("logip")));
            logData.setFileName(columnMap.get("filename") == null ? "" : String.valueOf(columnMap.get("filename")));
            logData.setLineNumber(columnMap.get("linenumber") == null ? "" : String.valueOf(columnMap.get("linenumber")));
            logData.setTimestamp(columnMap.get("timestamp") == null ? "" : String.valueOf(columnMap.get("timestamp")));
            logData.setLogOfString(JSON.toJSONString(logData.getLogOfKV()));
            logDataList.add(logData);
        }
        logDTO.setThisSortValue(null);
        logDTO.setLogDataDTOList(logDataList);
    }

    private List<Map<String, Object>> queryResult(LogQuery logQuery, MilogLogStoreDO milogLogstoreDO, DataSource dataSource) throws SQLException {
        ArrayList<Map<String, Object>> columns = new ArrayList<Map<String, Object>>();
        String querySql = EsDataServiceImpl.buildQuerySql(logQuery, milogLogstoreDO);
        try (Statement statement = dataSource.getConnection().createStatement();
             ResultSet resultSet = statement.executeQuery(querySql);){
            ResultSetMetaData metaData = resultSet.getMetaData();
            int columnCount = metaData.getColumnCount();
            while (resultSet.next()) {
                HashMap<String, Object> dataMap = new HashMap<String, Object>();
                for (int i = 1; i <= columnCount; ++i) {
                    dataMap.put(metaData.getColumnName(i), resultSet.getObject(i));
                }
                columns.add(dataMap);
            }
        }
        return columns;
    }

    private static String buildQuerySql(LogQuery logQuery, MilogLogStoreDO milogLogstoreDO) {
        Object sortSql;
        String sqlPrefix = EsDataServiceImpl.getConditional(logQuery);
        Object object = sortSql = StringUtils.isNotEmpty((String)logQuery.getSortKey()) ? String.format("ORDER BY %s", logQuery.getSortKey()) : "";
        if (StringUtils.isNotEmpty((String)sortSql) && !logQuery.getAsc().booleanValue()) {
            sortSql = (String)sortSql + " DESC";
        }
        String limitSql = String.format("LIMIT %s, %s", (logQuery.getPage() - 1) * logQuery.getPageSize(), logQuery.getPageSize());
        if (StringUtils.isNotEmpty((String)logQuery.getFullTextSearch())) {
            return String.format("SELECT * FROM %s WHERE %s AND %s %s %s", milogLogstoreDO.getEsIndex(), sqlPrefix, logQuery.getFullTextSearch(), sortSql, limitSql);
        }
        return String.format("SELECT * FROM %s WHERE %s %s %s", milogLogstoreDO.getEsIndex(), sqlPrefix, sortSql, limitSql);
    }

    private static String buildQuerySqlConditional(LogQuery logQuery, MilogLogStoreDO milogLogstoreDO) {
        String sqlPrefix = EsDataServiceImpl.getConditional(logQuery);
        if (StringUtils.isNotEmpty((String)logQuery.getFullTextSearch())) {
            return String.format("SELECT * FROM %s WHERE %s AND %s", milogLogstoreDO.getEsIndex(), sqlPrefix, logQuery.getFullTextSearch());
        }
        return String.format("SELECT * FROM %s WHERE %s ", milogLogstoreDO.getEsIndex(), sqlPrefix);
    }

    private static String getConditional(LogQuery logQuery) {
        Object sqlPrefix = String.format("timestamp >= %s AND timestamp <= %s", logQuery.getStartTime(), logQuery.getEndTime());
        if (StringUtils.isNotEmpty((String)logQuery.getTail())) {
            String tailIdFields = Arrays.stream(logQuery.getTail().split(",")).map(tail -> org.apache.commons.lang3.StringUtils.wrap((String)tail, (String)"\"")).collect(Collectors.joining(","));
            String tailSql = String.format(" AND tail IN (%s)", tailIdFields);
            sqlPrefix = (String)sqlPrefix + tailSql;
        }
        return sqlPrefix;
    }

    private SearchSourceBuilder assembleSearchSourceBuilder(LogQuery logQuery, List<String> keyList, BoolQueryBuilder boolQueryBuilder) {
        SearchSourceBuilder builder = new SearchSourceBuilder();
        builder.query((QueryBuilder)boolQueryBuilder);
        builder.sort(this.commonExtensionService.getSortedKey(logQuery, logQuery.getSortKey()), logQuery.getAsc() != false ? SortOrder.ASC : SortOrder.DESC);
        if (null != logQuery.getPage()) {
            builder.from((logQuery.getPage() - 1) * logQuery.getPageSize());
        }
        builder.size(logQuery.getPageSize().intValue());
        builder.highlighter(this.getHighlightBuilder(keyList));
        builder.timeout(TimeValue.timeValueMinutes((long)2L));
        return builder;
    }

    private void transformSearchResponse(SearchResponse searchResponse, LogDTO logDTO, List<String> keyList) {
        SearchHit[] hits = searchResponse.getHits().getHits();
        if (hits == null || hits.length == 0) {
            log.info("es query result is empty,es response:{}", (Object)searchResponse);
            return;
        }
        ArrayList logDataList = Lists.newArrayList();
        for (SearchHit hit : hits) {
            LogDataDTO logData = this.hit2DTO(hit, keyList);
            logData.setHighlight(this.getHightlinghtMap(hit));
            logDataList.add(logData);
        }
        logDTO.setThisSortValue(hits[hits.length - 1].getSortValues());
        logDTO.setLogDataDTOList(logDataList);
    }

    private HighlightBuilder getHighlightBuilder(List<String> keyList) {
        HighlightBuilder highlightBuilder = new HighlightBuilder();
        for (Pair<String, Pair<String, Integer>> requiredField : requiredFields) {
            if (keyList.contains(requiredField.getKey())) continue;
            keyList.add((String)requiredField.getKey());
        }
        for (String key : keyList) {
            if (this.noHighLightSet.contains(key)) continue;
            HighlightBuilder.Field highlightField = new HighlightBuilder.Field(key);
            highlightBuilder.field(highlightField);
        }
        return highlightBuilder;
    }

    @Override
    public void insertDoc(String indexName, Map<String, Object> data) throws IOException {
        EsService esService = this.esCluster.getEsService(null);
        esService.insertDoc(indexName, data);
    }

    @Override
    public Result<EsStatisticResult> EsStatistic(LogQuery logQuery) {
        try {
            EsStatisticResult result = new EsStatisticResult();
            result.setName(this.constructEsStatisticRet(logQuery));
            MilogLogStoreDO logStore = this.logstoreDao.queryById(logQuery.getStoreId());
            if (logStore == null) {
                return new Result(CommonError.UnknownError.getCode(), "not found logstore", null);
            }
            String interval = this.searchLog.esHistogramInterval(logQuery.getEndTime() - logQuery.getStartTime());
            String esIndex = this.commonExtensionService.getSearchIndex(logStore.getId(), logStore.getEsIndex());
            LogStorageTypeEnum storageTypeEnum = this.queryLogStorageTypeEnum(logStore.getEsClusterId());
            if (LogStorageTypeEnum.DORIS == storageTypeEnum) {
                this.handleDorisStat(result, logQuery, logStore);
            } else {
                this.handleEsStat(result, logQuery, logStore, esIndex, interval);
            }
            return new Result(CommonError.Success.getCode(), CommonError.Success.getMessage(), (Object)result);
        }
        catch (ElasticsearchStatusException e) {
            log.error("Log query errors and log bar chart statistics report errors:[{}], Error type[{}], logQuery:[{}], user:[{}]", new Object[]{e, e.status(), logQuery, MoneUserContext.getCurrentUser(), e});
            return Result.failParam((String)"ES resource permissions are misconfigured, please check the username password or token");
        }
        catch (Exception e) {
            log.error("Log query errors and log bar chart statistics report errors[{}],logQuery:[{}],user:[{}]", new Object[]{e, logQuery, MoneUserContext.getCurrentUser(), e});
            return Result.failParam((String)"Search term input error, please check");
        }
    }

    private void handleDorisStat(EsStatisticResult result, LogQuery logQuery, MilogLogStoreDO logStore) throws SQLException {
        DataSource dataSource = (DataSource)Ioc.ins().getBean(Constant.LOG_STORAGE_SERV_BEAN_PRE + logStore.getEsClusterId());
        String querySql = EsDataServiceImpl.buildQuerySqlConditional(logQuery, logStore);
        String staticSql = EsDataServiceImpl.buildDorisStatSql(querySql);
        log.info("staticSql:{}", (Object)staticSql);
        ArrayList timestamps = Lists.newArrayList();
        List<Long> counts = this.executeDorisStatQuery(dataSource, staticSql, timestamps);
        result.setCounts(counts);
        result.setTimestamps(timestamps);
        result.setQueryBuilder(staticSql);
        result.calTotalCounts();
    }

    private static String buildDorisStatSql(String querySql) {
        return "SELECT DATE_FORMAT(FROM_UNIXTIME(`timestamp` / 1000), '%Y-%m-%d %H:%i:%s') AS time_bucket, COUNT(*) AS data_count FROM (" + querySql + ") data GROUP BY time_bucket ORDER BY time_bucket";
    }

    private List<Long> executeDorisStatQuery(DataSource dataSource, String staticSql, List<String> timestamps) throws SQLException {
        ArrayList<Long> counts = new ArrayList<Long>();
        try (Statement statement = dataSource.getConnection().createStatement();
             ResultSet resultSet = statement.executeQuery(staticSql);){
            while (resultSet.next()) {
                timestamps.add(resultSet.getString("time_bucket"));
                counts.add(resultSet.getLong("data_count"));
            }
        }
        return counts;
    }

    private void handleEsStat(EsStatisticResult result, LogQuery logQuery, MilogLogStoreDO logStore, String esIndex, String interval) throws IOException {
        EsService esService = this.esCluster.getEsService(logStore.getEsClusterId());
        if (esService == null || StringUtils.isEmpty((String)esIndex)) {
            throw new MilogManageException("Log Store or tail configuration exceptions");
        }
        if (StringUtils.isEmpty((String)interval)) {
            throw new MilogManageException("The minimum time interval is 10s");
        }
        BoolQueryBuilder queryBuilder = this.searchLog.getQueryBuilder(logQuery, ManagerUtil.getKeyColonPrefix(logStore.getKeyList()));
        String histogramField = this.commonExtensionService.queryDateHistogramField(logQuery.getStoreId());
        EsClient.EsRet esRet = esService.dateHistogram(esIndex, histogramField, interval, logQuery.getStartTime().longValue(), logQuery.getEndTime().longValue(), queryBuilder);
        result.setCounts(esRet.getCounts());
        result.setTimestamps(esRet.getTimestamps());
        result.setQueryBuilder(queryBuilder);
        result.calTotalCounts();
    }

    public String constructEsStatisticRet(LogQuery logquery) {
        StringBuilder sb = new StringBuilder();
        if (!StringUtils.isEmpty((String)logquery.getLogstore())) {
            sb.append("logstore:").append(logquery.getLogstore()).append(";");
        }
        if (!StringUtils.isEmpty((String)logquery.getFullTextSearch())) {
            sb.append("fullTextSearch:").append(logquery.getFullTextSearch()).append(";");
        }
        return sb.toString();
    }

    public TraceLogDTO getTraceLog(TraceLogQuery logQuery) {
        try {
            log.info("getTraceLog,param data:{}", (Object)Constant.GSON.toJson((Object)logQuery));
            return this.traceLog.getTraceLog(logQuery.getAppId(), logQuery.getTraceId(), "", logQuery.getGenerationTime(), logQuery.getLevel());
        }
        catch (Exception e) {
            log.error("Log query error, query trace log error, logQuery:[{}]", new Object[]{e, Constant.GSON.toJson((Object)logQuery), e});
            return TraceLogDTO.emptyData();
        }
    }

    public Result<String> getTraceAppLogUrl(TraceAppLogUrlQuery query) {
        List<MilogLogTailDo> tailDoList = this.tailDao.queryByAppId(query.getAppId());
        this.handleEnvId(query);
        if (null != query.getEnvId() && !CollectionUtils.isEmpty(tailDoList)) {
            tailDoList = tailDoList.stream().filter(logTailDo -> Objects.equals(query.getEnvId(), logTailDo.getEnvId())).collect(Collectors.toList());
        }
        if (tailDoList == null || tailDoList.isEmpty()) {
            return Result.failParam((String)"The application is not connected to the log");
        }
        Object tailName = "";
        for (MilogLogTailDo tail : tailDoList) {
            tailName = (String)tailName + tail.getTail() + ",";
        }
        tailName = ((String)tailName).substring(0, ((String)tailName).length() - 1);
        Long storeId = tailDoList.get(0).getStoreId();
        MilogLogStoreDO storeDO = this.logstoreDao.queryById(storeId);
        MilogSpaceDO spaceDO = this.spaceDao.queryById(storeDO.getSpaceId());
        Long startTime = query.getTimestamp() / 1000L - 600000L;
        Long endTime = query.getTimestamp() / 1000L + 600000L;
        String url = String.format("%s/project-milog/user/space-tree?spaceId=%s&inputV=traceId:%s&storeId=%s&tailName=%s&type=search&startTime=%s&endTime=%s", this.heraUrl, spaceDO.getId(), query.getTraceId(), storeDO.getId(), tailName, startTime, endTime);
        return Result.success((Object)url);
    }

    private void handleEnvId(TraceAppLogUrlQuery traceAppLogUrlQuery) {
        List<HeraAppEnvData> heraAppEnvDataList;
        if (null != traceAppLogUrlQuery.getEnvId() && ManagerUtil.isOpenEnv() && org.apache.commons.collections.CollectionUtils.isNotEmpty(heraAppEnvDataList = this.heraAppEnvService.queryEnvById(null, null, traceAppLogUrlQuery.getEnvId()))) {
            traceAppLogUrlQuery.setEnvId(heraAppEnvDataList.getFirst().getId());
        }
    }

    @Override
    public Result<TraceLogDTO> queryRegionTraceLog(RegionTraceLogQuery regionTraceLogQuery) throws IOException {
        return Result.success((Object)this.traceLog.getTraceLog(null, regionTraceLogQuery.getTraceId(), regionTraceLogQuery.getRegion(), "", ""));
    }

    public TraceLogDTO getTraceLogFromDubbo(TraceLogQuery logQuery) throws IOException {
        return this.logDataService.getTraceLog(logQuery);
    }

    public Result<LogDTO> getDocContext(LogContextQuery logContextQuery) {
        SearchRequest searchRequest = null;
        try {
            if (!this.searchLog.isLegalParam(logContextQuery)) {
                return Result.failParam((String)"Required parameters are missing");
            }
            MilogLogStoreDO milogLogstoreDO = this.logstoreDao.getByName(logContextQuery.getLogstore());
            if (milogLogstoreDO.getEsClusterId() == null || StringUtils.isEmpty((String)milogLogstoreDO.getEsIndex())) {
                return Result.failParam((String)"store Configuration exceptions");
            }
            EsService esService = this.esCluster.getEsService(milogLogstoreDO.getEsClusterId());
            String esIndexName = milogLogstoreDO.getEsIndex();
            List<String> keyList = ManagerUtil.getKeyList(milogLogstoreDO.getKeyList(), milogLogstoreDO.getColumnTypeList());
            LogDTO dto = new LogDTO();
            ArrayList<LogDataDTO> logDataList = new ArrayList<LogDataDTO>();
            int times = 1;
            int pageSize = logContextQuery.getPageSize();
            Long lineNumberSearchAfter = logContextQuery.getLineNumber();
            ArrayList<Integer> logOrder = new ArrayList<Integer>();
            logOrder.add(logContextQuery.getType());
            if (0 == logContextQuery.getType()) {
                times = 2;
                pageSize /= 2;
                logOrder.remove(0);
                logOrder.add(2);
                logOrder.add(1);
            }
            for (int t = 0; t < times; ++t) {
                int i;
                BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
                boolQueryBuilder.filter((QueryBuilder)QueryBuilders.termQuery((String)"logip", (String)logContextQuery.getIp()));
                boolQueryBuilder.filter((QueryBuilder)QueryBuilders.termQuery((String)"filename", (String)logContextQuery.getFileName()));
                SearchSourceBuilder builder = new SearchSourceBuilder();
                builder.query((QueryBuilder)boolQueryBuilder);
                if (1 == (Integer)logOrder.get(t)) {
                    builder.sort("timestamp", SortOrder.ASC);
                    builder.sort("linenumber", SortOrder.ASC);
                } else if (2 == (Integer)logOrder.get(t)) {
                    builder.sort("timestamp", SortOrder.DESC);
                    builder.sort("linenumber", SortOrder.DESC);
                }
                if (0 == logContextQuery.getType() && 2 == (Integer)logOrder.get(t)) {
                    builder.searchAfter(new Object[]{logContextQuery.getTimestamp(), lineNumberSearchAfter + 1L});
                } else {
                    builder.searchAfter(new Object[]{logContextQuery.getTimestamp(), lineNumberSearchAfter});
                }
                builder.size(pageSize);
                searchRequest = new SearchRequest(new String[]{esIndexName});
                searchRequest.source(builder);
                SearchResponse searchResponse = esService.search(searchRequest);
                SearchHit[] hits = searchResponse.getHits().getHits();
                if (hits == null || hits.length == 0) continue;
                if (1 == (Integer)logOrder.get(t)) {
                    for (i = 0; i < hits.length; ++i) {
                        logDataList.add(this.hit2DTO(hits[i], keyList));
                    }
                    continue;
                }
                if (2 != (Integer)logOrder.get(t)) continue;
                for (i = hits.length - 1; i >= 0; --i) {
                    logDataList.add(this.hit2DTO(hits[i], keyList));
                }
            }
            dto.setLogDataDTOList(logDataList);
            return Result.success((Object)dto);
        }
        catch (Exception e) {
            log.error("Log query error, log context error, logContextQuery:[{}], searchRequest:[{}], user:[{}]", new Object[]{logContextQuery, searchRequest, MoneUserContext.getCurrentUser(), e});
            return Result.failParam((String)"System error, please try again");
        }
    }

    private LogDataDTO hit2DTO(SearchHit hit, List<String> keyList) {
        LogDataDTO logData = new LogDataDTO();
        Map ferry = hit.getSourceAsMap();
        long time = 0L;
        if (ferry.containsKey("time") && null != ferry.get("time") && StringUtils.isNotBlank((String)ferry.get("time").toString())) {
            try {
                time = DateUtil.parse((CharSequence)ferry.get("time").toString()).toTimestamp().getTime();
            }
            catch (Exception e) {
                log.error("Log query error, log context error,time:{}", ferry.get("time"), (Object)e);
            }
        }
        if (!ferry.containsKey("timestamp") || null == ferry.get("timestamp")) {
            logData.setValue("timestamp", time);
        } else {
            logData.setValue("timestamp", ferry.get("timestamp"));
        }
        for (String key : keyList) {
            if (this.hidenFiledSet.contains(key)) continue;
            logData.setValue(key, ferry.get(key));
        }
        logData.setIp(ferry.get("logip") == null ? "" : String.valueOf(ferry.get("logip")));
        logData.setFileName(ferry.get("filename") == null ? "" : String.valueOf(ferry.get("filename")));
        logData.setLineNumber(ferry.get("linenumber") == null ? "" : String.valueOf(ferry.get("linenumber")));
        logData.setTimestamp(ferry.get("timestamp") == null ? String.valueOf(time) : String.valueOf(ferry.get("timestamp")));
        logData.setLogOfString(JSON.toJSONString(logData.getLogOfKV()));
        return logData;
    }

    public void logExport(LogQuery logQuery) throws Exception {
        int maxLogNum = 10000;
        logQuery.setPageSize(maxLogNum);
        Result<LogDTO> logDTOResult = this.logQuery(logQuery);
        List exportData = logDTOResult.getCode() != CommonError.Success.getCode() || ((LogDTO)logDTOResult.getData()).getLogDataDTOList() == null || ((LogDTO)logDTOResult.getData()).getLogDataDTOList().isEmpty() ? null : ((LogDTO)logDTOResult.getData()).getLogDataDTOList().stream().map(logDataDto -> ExportUtils.SplitTooLongContent(logDataDto)).collect(Collectors.toList());
        HSSFWorkbook excel = ExportExcel.HSSFWorkbook4Map(exportData, (String)this.generateTitle(logQuery));
        String fileName = String.format("%s_log.xls", logQuery.getLogstore());
        this.searchLog.downLogFile(excel, fileName);
    }

    private String generateTitle(LogQuery logQuery) {
        return String.format("%sLogs, search terms:[%s],time range%d-%d", logQuery.getLogstore(), logQuery.getFullTextSearch() == null ? "" : logQuery.getFullTextSearch(), logQuery.getStartTime(), logQuery.getEndTime());
    }
}

