/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.monitor.service.api.impl;

import com.alibaba.nacos.api.config.annotation.NacosValue;
import com.google.gson.Gson;
import java.util.HashMap;
import java.util.List;
import org.apache.ozhera.monitor.result.ErrorCode;
import org.apache.ozhera.monitor.result.Result;
import org.apache.ozhera.monitor.service.api.PrometheusServiceExtension;
import org.apache.ozhera.monitor.service.http.RestTemplateService;
import org.apache.ozhera.monitor.service.model.prometheus.MetricDataSetVector;
import org.apache.ozhera.monitor.service.model.prometheus.MetricResponseVector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnProperty(name={"service.selector.property"}, havingValue="outer")
public class PrometheusServiceImpl
implements PrometheusServiceExtension {
    private static final Logger log = LoggerFactory.getLogger(PrometheusServiceImpl.class);
    private static final String P_QUERY = "query";
    private static final String P_TIME = "time";
    private static final String P_STEP = "step";
    private static final String P_START = "start";
    private static final String P_END = "end";
    @NacosValue(value="${prometheus.url}", autoRefreshed=true)
    private String prometheusUrl;
    @Value(value="${server.type}")
    private String env;
    private static final String URI_QUERY_MOMENT = "/api/v1/query";
    private static final String URI_QUERY_RANGE = "/api/v1/query_range";
    @Autowired
    RestTemplateService restTemplateService;
    private final Gson gson = new Gson();

    @Override
    public Result queryDubboServiceList(String serviceName, String type, String startTime, String endTime) {
        log.info("queryDubboServiceList serviceName:{},type :{},startTime:{},endTime:{}", new Object[]{serviceName, type, startTime, endTime});
        String prometheusEnv = "staging";
        if ("online".equals(this.env)) {
            prometheusEnv = "online";
        }
        Object query = "";
        switch (type) {
            case "http": {
                query = "sum(sum_over_time(" + prometheusEnv + "_hera_aopTotalMethodCount_total{application=\"" + serviceName + "\"}[30s])) by (methodName)";
                break;
            }
            case "dubboConsumer": {
                query = "sum(sum_over_time(" + prometheusEnv + "_hera_dubboBisTotalCount_total{application=\"" + serviceName + "\"}[30s])) by (serviceName)";
                break;
            }
            case "dubbo": {
                query = "sum(sum_over_time(" + prometheusEnv + "_hera_dubboProviderCount_count{application=\"" + serviceName + "\"}[30s]))by (serviceName)";
                break;
            }
            case "gRPCProvider": {
                query = "sum(sum_over_time(" + prometheusEnv + "_hera_grpcServer_total{application=\"" + serviceName + "\"}[30s]))by (serviceName)";
                break;
            }
            case "gRPCConsumer": {
                query = "sum(sum_over_time(" + prometheusEnv + "_hera_grpcClient_total{application=\"" + serviceName + "\"}[30s]))by (serviceName)";
                break;
            }
            default: {
                query = "sum(sum_over_time(" + prometheusEnv + "_hera_dubboProviderCount_count{application=\"" + serviceName + "\"}[30s]))by (serviceName)";
            }
        }
        log.info("PrometheusService.queryDubboServiceList query : {}", query);
        return this.queryDubboServiceListByPrometheus((String)query, type, startTime, endTime);
    }

    private Result queryDubboServiceListByPrometheus(String metric, String type, String startTime, String endTime) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(P_QUERY, metric);
        Long multi = (Long.parseLong(endTime) - Long.parseLong(startTime)) / 3600L;
        if (multi < 1L) {
            multi = 1L;
        }
        map.put(P_STEP, multi * 15L);
        map.put(P_START, startTime);
        map.put(P_END, endTime);
        log.info("queryDubboServiceListByPrometheus map :{},url :{},promql :{}", new Object[]{this.gson.toJson(map), this.prometheusUrl + URI_QUERY_RANGE, metric});
        try {
            String data = this.restTemplateService.getHttpM(this.completeQueryUrl(this.prometheusUrl, URI_QUERY_RANGE), map);
            MetricResponseVector metricResult = (MetricResponseVector)new Gson().fromJson(data, MetricResponseVector.class);
            if (metricResult == null || !"success".equals(metricResult.getStatus())) {
                return Result.fail((ErrorCode)ErrorCode.success);
            }
            List<MetricDataSetVector> resultData = metricResult.getData().getResult();
            if (!resultData.isEmpty()) {
                if ("http".equals(type)) {
                    return Result.success(resultData.stream().map(it -> it.getMetric().getMethodName()));
                }
                return Result.success(resultData.stream().map(it -> it.getMetric().getServiceName()));
            }
            return Result.fail((ErrorCode)ErrorCode.success);
        }
        catch (Exception e) {
            log.error("PrometheusService.queryQpsByPrometheus err :{}", (Object)e.toString());
            return Result.fail((ErrorCode)ErrorCode.success);
        }
    }

    private String completeQueryUrl(String domain, String uri) {
        return new StringBuffer(domain).append(uri).toString();
    }
}

