/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.http;

import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpException;
import cn.hutool.http.HttpResponse;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;

public class HttpInputStream
extends InputStream {
    private InputStream in;

    public HttpInputStream(HttpResponse response) {
        this.init(response);
    }

    @Override
    public int read() throws IOException {
        return this.in.read();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.in.read(b, off, len);
    }

    @Override
    public long skip(long n) throws IOException {
        return this.in.skip(n);
    }

    @Override
    public int available() throws IOException {
        return this.in.available();
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.in.mark(readlimit);
    }

    @Override
    public synchronized void reset() throws IOException {
        this.in.reset();
    }

    @Override
    public boolean markSupported() {
        return this.in.markSupported();
    }

    private void init(HttpResponse response) {
        block8: {
            try {
                this.in = response.status < 400 ? response.httpConnection.getInputStream() : response.httpConnection.getErrorStream();
            }
            catch (IOException e) {
                if (e instanceof FileNotFoundException) break block8;
                throw new HttpException(e);
            }
        }
        if (null == this.in) {
            this.in = new ByteArrayInputStream(StrUtil.format("Error request, response status: {}", response.status).getBytes());
            return;
        }
        if (response.isGzip() && !(response.in instanceof GZIPInputStream)) {
            try {
                this.in = new GZIPInputStream(this.in);
            }
            catch (IOException iOException) {}
        } else if (response.isDeflate() && !(this.in instanceof InflaterInputStream)) {
            this.in = new InflaterInputStream(this.in, new Inflater(true));
        }
    }
}

