/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.prometheus.agent.service.prometheus;

import com.google.gson.Gson;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.StringUtils;
import org.apache.ozhera.prometheus.agent.Impl.ScrapeConfigDao;
import org.apache.ozhera.prometheus.agent.entity.ScrapeConfigEntity;
import org.apache.ozhera.prometheus.agent.enums.ScrapeJobStatusEnum;
import org.apache.ozhera.prometheus.agent.param.prometheus.Scrape_configs;
import org.apache.ozhera.prometheus.agent.param.scrapeConfig.ScrapeConfigDetail;
import org.apache.ozhera.prometheus.agent.param.scrapeConfig.ScrapeConfigParam;
import org.apache.ozhera.prometheus.agent.result.Result;
import org.apache.ozhera.prometheus.agent.vo.PageDataVo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ScrapeJobService {
    private static final Logger log = LoggerFactory.getLogger(ScrapeJobService.class);
    @Autowired
    ScrapeConfigDao dao;
    public static final Gson gson = new Gson();

    public Result CreateScrapeConfig(ScrapeConfigParam param) {
        log.info("ScrapeJobService.CreateScrapeConfig  param : {}", (Object)gson.toJson((Object)param));
        param = this.beforeCreateJob(param);
        ScrapeConfigEntity scrapeConfigEntity = new ScrapeConfigEntity();
        scrapeConfigEntity.setEnv(param.getEnv());
        scrapeConfigEntity.setBody(gson.toJson((Object)this.getScrapeJobBody(param)));
        scrapeConfigEntity.setCreatedBy("xxx");
        scrapeConfigEntity.setCreateTime(new Date());
        scrapeConfigEntity.setJobName(param.getJob_name());
        scrapeConfigEntity.setRegion(param.getRegion());
        scrapeConfigEntity.setPromCluster(param.getPromCluster());
        scrapeConfigEntity.setUpdateTime(new Date());
        scrapeConfigEntity.setZone(param.getZone());
        scrapeConfigEntity.setStatus(ScrapeJobStatusEnum.PENDING.getDesc());
        Long id = this.dao.CreateScrapeConfig(scrapeConfigEntity);
        log.info("ScrapeJobService.CreateScrapeConfig  res : {}", (Object)id);
        return Result.success((Object)String.valueOf(id));
    }

    public Result DeleteScrapeConfig(String id) {
        log.info("ScrapeJobService.DeleteScrapeConfig id : {}", (Object)id);
        int res = this.dao.DeleteScrapeConfig(id);
        log.info("ScrapeJobService.DeleteScrapeConfig res : {}", (Object)res);
        return Result.success((Object)res);
    }

    public Result GetScrapeConfig(String id) {
        log.info("ScrapeJobService.GetScrapeConfig id : {}", (Object)id);
        ScrapeConfigEntity scrapeConfigEntity = this.dao.GetScrapeConfig(id);
        log.info("ScrapeJobService.GetScrapeConfig res : {}", (Object)gson.toJson((Object)scrapeConfigEntity));
        return Result.success((Object)scrapeConfigEntity);
    }

    public Result GetScrapeConfigByName(String name) {
        log.info("ScrapeJobService.GetScrapeConfigByName name : {}", (Object)name);
        ScrapeConfigEntity scrapeConfigEntity = this.dao.GetScrapeConfigByName(name);
        log.info("ScrapeJobService.GetScrapeConfigByName res : {}", (Object)gson.toJson((Object)scrapeConfigEntity));
        return Result.success((Object)scrapeConfigEntity);
    }

    public Result UpdateScrapeConfig(String id, ScrapeConfigParam param) {
        log.info("ScrapeJobService.UpdateScrapeConfig  param : {}", (Object)gson.toJson((Object)param));
        param = this.beforeCreateJob(param);
        ScrapeConfigEntity scrapeConfigEntity = new ScrapeConfigEntity();
        scrapeConfigEntity.setId(Long.valueOf(Long.parseLong(id)));
        scrapeConfigEntity.setBody(gson.toJson((Object)this.getScrapeJobBody(param)));
        scrapeConfigEntity.setUpdateTime(new Date());
        String res = this.dao.UpdateScrapeConfigList(id, scrapeConfigEntity);
        log.info("ScrapeJobService.UpdateScrapeConfig res: {}", (Object)res);
        return Result.success((Object)res);
    }

    public Result GetScrapeConfigList(Integer pageSize, Integer pageNo) {
        log.info("ScrapeJobService.GetScrapeConfigList pageSize : {} pageNo : {}", (Object)pageSize, (Object)pageNo);
        List lists = this.dao.GetScrapeConfigList(pageSize, pageNo);
        PageDataVo pdo = new PageDataVo();
        pdo.setPageNo(pageNo);
        pdo.setPageSize(pageSize);
        pdo.setTotal(this.dao.CountScrapeConfig());
        pdo.setList(lists);
        log.info("ScrapeJobService.GetScrapeConfigs count : {}", (Object)pdo.getTotal());
        return Result.success((Object)pdo);
    }

    public List<ScrapeConfigEntity> getAllScrapeConfigList(String status) {
        List scrapeConfigEntities = this.dao.GetAllScrapeConfigList(status);
        return scrapeConfigEntities;
    }

    public List<ScrapeConfigEntity> getAllCloudScrapeConfigList(String status) {
        List scrapeConfigEntities = this.dao.GetAllCloudScrapeConfigList(status);
        return scrapeConfigEntities;
    }

    public void setPendingScrapeConfig() {
        List<ScrapeConfigEntity> allScrapeConfigList = this.getAllScrapeConfigList(ScrapeJobStatusEnum.SUCCESS.getDesc());
        if (allScrapeConfigList.size() > 0) {
            allScrapeConfigList.forEach(scrapeConfigEntity -> {
                scrapeConfigEntity.setStatus(ScrapeJobStatusEnum.PENDING.getDesc());
                this.dao.UpdateScrapeConfigList(String.valueOf(scrapeConfigEntity.getId()), scrapeConfigEntity);
            });
        }
    }

    public void updateAllScrapeConfigListStatus(String status, List<Scrape_configs> allConfigs) {
        log.info("ScrapeJobService.updateScrapeConfigListStatus  status : {}", (Object)status);
        AtomicInteger failNum = new AtomicInteger(allConfigs.size());
        allConfigs.forEach(config -> {
            int affectRow = this.dao.UpdateScrapeConfigListByJobName(config.getJob_name(), ScrapeJobStatusEnum.SUCCESS.getDesc());
            failNum.addAndGet(-affectRow);
        });
        log.info("ScrapeJobService.updateScrapeConfigListStatus fail num:{}", (Object)failNum.get());
    }

    public void updateAllScrapeConfigDeleteToDone(Scrape_configs config) {
        log.info("ScrapeJobService.updateScrapeConfigListStatus  status : {}", (Object)ScrapeJobStatusEnum.DONE.getDesc());
        int affectRow = this.dao.UpdateScrapeConfigDeleteToDone(config.getJob_name());
        log.info("ScrapeJobService.updateAllScrapeConfigDeleteToDone affectRow num:{}", (Object)affectRow);
    }

    private ScrapeConfigParam beforeCreateJob(ScrapeConfigParam param) {
        if (StringUtils.isBlank((CharSequence)param.getPromCluster())) {
            param.setPromCluster("public");
        }
        if (StringUtils.isBlank((CharSequence)param.getEnv())) {
            param.setEnv("staging");
        }
        return param;
    }

    private ScrapeConfigDetail getScrapeJobBody(ScrapeConfigParam param) {
        ScrapeConfigDetail scrapeConfigDetail = new ScrapeConfigDetail();
        scrapeConfigDetail.setJob_name(param.getJob_name());
        scrapeConfigDetail.setScrape_interval(param.getScrape_interval());
        scrapeConfigDetail.setScrape_timeout(param.getScrape_timeout());
        scrapeConfigDetail.setHttp_sd_configs(param.getHttp_sd_configs());
        scrapeConfigDetail.setRelabel_configs(param.getRelabel_configs());
        scrapeConfigDetail.setStatic_configs(param.getStatic_configs());
        scrapeConfigDetail.setBasic_auth(param.getBasic_auth());
        scrapeConfigDetail.setMetric_relabel_configs(param.getMetric_relabel_configs());
        scrapeConfigDetail.setScheme(param.getScheme());
        scrapeConfigDetail.setMetrics_path(param.getMetrics_path());
        scrapeConfigDetail.setHonor_labels(param.isHonor_labels());
        scrapeConfigDetail.setHonor_timestamps(param.isHonor_timestamps());
        scrapeConfigDetail.setParams(param.getParams());
        return scrapeConfigDetail;
    }
}

