/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.trino.connector.catalog.iceberg;

import io.trino.spi.session.PropertyMetadata;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.gravitino.catalog.property.PropertyConverter;
import org.apache.gravitino.trino.connector.catalog.CatalogConnectorAdapter;
import org.apache.gravitino.trino.connector.catalog.CatalogConnectorMetadataAdapter;
import org.apache.gravitino.trino.connector.catalog.iceberg.IcebergCatalogPropertyConverter;
import org.apache.gravitino.trino.connector.catalog.iceberg.IcebergMetadataAdapter;
import org.apache.gravitino.trino.connector.catalog.iceberg.IcebergPropertyMeta;
import org.apache.gravitino.trino.connector.metadata.GravitinoCatalog;

public class IcebergConnectorAdapter
implements CatalogConnectorAdapter {
    private static final String CONNECTOR_ICEBERG = "iceberg";
    private final IcebergPropertyMeta propertyMetadata = new IcebergPropertyMeta();
    private final PropertyConverter catalogConverter = new IcebergCatalogPropertyConverter();

    @Override
    public Map<String, String> buildInternalConnectorConfig(GravitinoCatalog catalog) throws Exception {
        return this.catalogConverter.gravitinoToEngineProperties(catalog.getProperties());
    }

    @Override
    public String internalConnectorName() {
        return CONNECTOR_ICEBERG;
    }

    @Override
    public CatalogConnectorMetadataAdapter getMetadataAdapter() {
        return new IcebergMetadataAdapter(this.getSchemaProperties(), this.getTableProperties(), Collections.emptyList());
    }

    @Override
    public List<PropertyMetadata<?>> getTableProperties() {
        return this.propertyMetadata.getTablePropertyMetadata();
    }

    @Override
    public List<PropertyMetadata<?>> getSchemaProperties() {
        return this.propertyMetadata.getSchemaPropertyMetadata();
    }
}

