/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.postgres.refresh;

import java.lang.invoke.CallSite;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseMetadataRetriever {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)DatabaseMetadataRetriever.class.getName());

    private DatabaseMetadataRetriever() {
    }

    public static List<DatabaseObject> getObjects(Connection connection, String schema) throws SQLException {
        ArrayList<DatabaseObject> result = new ArrayList<DatabaseObject>();
        String sql = "    SELECT c.oid,\n           c.relname,\n           c.relkind,\n           n.nspname\n      FROM pg_class c\n      JOIN pg_namespace n ON n.oid = c.relnamespace\n     WHERE n.nspname = ?\n       AND c.relkind IN ('r', 'v', 'm')\n";
        try (PreparedStatement ps = connection.prepareStatement(sql);){
            ps.setString(1, schema);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    long oid = rs.getLong("oid");
                    String relName = rs.getString("relname");
                    String relKind = rs.getString("relkind");
                    String nspName = rs.getString("nspname");
                    ObjectType objectType = switch (relKind) {
                        case "r" -> ObjectType.TABLE;
                        case "v" -> ObjectType.VIEW;
                        case "m" -> ObjectType.MATERIALIZED_VIEW;
                        default -> null;
                    };
                    DatabaseObject dbObj = new DatabaseObject(nspName, relName, objectType);
                    result.add(dbObj);
                }
            }
        }
        LOGGER.info("Found " + result.size() + " objects in schema " + schema);
        return result;
    }

    public static List<DatabaseDependency> getDependencies(Connection connection, String schema, List<DatabaseObject> objects) throws SQLException {
        String sql = "    SELECT dependent_ns.nspname   AS dependent_schema,\n           dependent_c.relname    AS dependent_name,\n           source_ns.nspname      AS source_schema,\n           source_c.relname       AS source_name\n      FROM pg_depend d\n      JOIN pg_rewrite r\n        ON r.oid = d.objid\n      JOIN pg_class dependent_c\n        ON r.ev_class = dependent_c.oid\n      JOIN pg_namespace dependent_ns\n        ON dependent_c.relnamespace = dependent_ns.oid\n      JOIN pg_class source_c\n        ON d.refobjid = source_c.oid\n      JOIN pg_namespace source_ns\n        ON source_c.relnamespace = source_ns.oid\n     WHERE dependent_ns.nspname = ?\n       AND source_ns.nspname = ?\n";
        HashMap<CallSite, DatabaseObject> lookupMap = new HashMap<CallSite, DatabaseObject>();
        for (DatabaseObject obj : objects) {
            String key = obj.schemaName() + "." + obj.objectName();
            lookupMap.put((CallSite)((Object)key), obj);
        }
        ArrayList<DatabaseDependency> result = new ArrayList<DatabaseDependency>();
        try (PreparedStatement ps = connection.prepareStatement(sql);){
            ps.setString(1, schema);
            ps.setString(2, schema);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    String dependentSchema = rs.getString("dependent_schema");
                    String dependentName = rs.getString("dependent_name");
                    String sourceSchema = rs.getString("source_schema");
                    String sourceName = rs.getString("source_name");
                    String dependentKey = dependentSchema + "." + dependentName;
                    String sourceKey = sourceSchema + "." + sourceName;
                    DatabaseObject dependentObj = (DatabaseObject)lookupMap.get(dependentKey);
                    DatabaseObject sourceObj = (DatabaseObject)lookupMap.get(sourceKey);
                    if (dependentObj == null || sourceObj == null || dependentObj.equals(sourceObj)) continue;
                    result.add(new DatabaseDependency(sourceObj, dependentObj));
                }
            }
        }
        return result;
    }

    public static List<DatabaseIndex> getIndexes(Connection connection, String schema, String tableName) throws SQLException {
        String sql = "    SELECT indexname, indexdef\n      FROM pg_indexes\n     WHERE schemaname = ?\n       AND tablename  = ?\n";
        ArrayList<DatabaseIndex> result = new ArrayList<DatabaseIndex>();
        try (PreparedStatement ps = connection.prepareStatement(sql);){
            ps.setString(1, schema);
            ps.setString(2, tableName);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    String indexName = rs.getString("indexname");
                    String indexDef = rs.getString("indexdef");
                    result.add(new DatabaseIndex(indexName, indexDef));
                }
            }
        }
        return result;
    }

    public static enum ObjectType {
        TABLE,
        VIEW,
        MATERIALIZED_VIEW;

    }

    public record DatabaseObject(String schemaName, String objectName, ObjectType objectType) {
    }

    public record DatabaseDependency(DatabaseObject source, DatabaseObject dependent) {
    }

    public record DatabaseIndex(String indexName, String indexDef) {
    }
}

