/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.flatgeobuf;

import com.google.flatbuffers.FlatBufferBuilder;
import java.util.Arrays;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import org.apache.baremaps.flatgeobuf.generated.Geometry;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.CoordinateSequenceFilter;
import org.locationtech.jts.geom.CoordinateXYZM;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;

public class GeometryConversions {
    private static final String UNKNOWN_GEOMETRY_TYPE = "Unknown geometry type";

    private GeometryConversions() {
    }

    public static GeometryOffsets writeGeometryPart(FlatBufferBuilder builder, org.locationtech.jts.geom.Geometry geometry, int geometryType) {
        GeometryOffsets go = new GeometryOffsets();
        if (geometry == null) {
            return go;
        }
        if (geometryType == 5) {
            int end = 0;
            MultiLineString mls = (MultiLineString)geometry;
            if (mls.getNumGeometries() > 1) {
                go.ends = new long[mls.getNumGeometries()];
                for (int i = 0; i < mls.getNumGeometries(); ++i) {
                    go.ends[i] = end += mls.getGeometryN(i).getNumPoints();
                }
            }
        } else if (geometryType == 3) {
            Polygon p = (Polygon)geometry;
            go.ends = new long[p.getNumInteriorRing() + 1];
            int end = p.getExteriorRing().getNumPoints();
            go.ends[0] = end;
            for (int i = 0; i < p.getNumInteriorRing(); ++i) {
                go.ends[i + 1] = end += p.getInteriorRingN(i).getNumPoints();
            }
        } else if (geometryType == 6) {
            MultiPolygon mp = (MultiPolygon)geometry;
            int numGeometries = mp.getNumGeometries();
            GeometryOffsets[] gos = new GeometryOffsets[numGeometries];
            for (int i = 0; i < numGeometries; ++i) {
                Polygon p = (Polygon)mp.getGeometryN(i);
                gos[i] = GeometryConversions.writeGeometryPart(builder, (org.locationtech.jts.geom.Geometry)p, 3);
            }
            go.gos = gos;
            return go;
        }
        int numPoints = geometry.getNumPoints();
        Geometry.startXyVector(builder, 2 * numPoints);
        ReverseXYCoordinateSequenceFilter filter = new ReverseXYCoordinateSequenceFilter(builder);
        GeometryConversions.applyInReverseOrder(geometry, filter);
        go.coordsOffset = builder.endVector();
        if (filter.hasZ) {
            Geometry.startZVector(builder, numPoints);
            GeometryConversions.applyInReverseOrder(geometry, new OrdinateCoordinateSequenceFilter(builder, 2));
            go.zOffset = builder.endVector();
        } else {
            go.zOffset = 0;
        }
        if (filter.hasM) {
            Geometry.startMVector(builder, numPoints);
            GeometryConversions.applyInReverseOrder(geometry, new OrdinateCoordinateSequenceFilter(builder, 3));
            go.mOffset = builder.endVector();
        } else {
            go.mOffset = 0;
        }
        if (go.ends != null) {
            go.endsOffset = Geometry.createEndsVector(builder, go.ends);
        }
        go.type = geometryType;
        return go;
    }

    public static int writeGeometry(FlatBufferBuilder builder, org.locationtech.jts.geom.Geometry geometry, byte geometryType) {
        int geometryOffset;
        byte knownGeometryType = geometryType;
        if (geometryType == 0) {
            knownGeometryType = GeometryConversions.toGeometryType(geometry.getClass());
        }
        GeometryOffsets go = GeometryConversions.writeGeometryPart(builder, geometry, knownGeometryType);
        if (go.gos != null && go.gos.length > 0) {
            int[] partOffsets = new int[go.gos.length];
            for (int i = 0; i < go.gos.length; ++i) {
                int partOffset;
                GeometryOffsets goPart = go.gos[i];
                partOffsets[i] = partOffset = Geometry.createGeometry(builder, goPart.endsOffset, goPart.coordsOffset, goPart.zOffset, goPart.mOffset, 0, 0, goPart.type, 0);
            }
            int partsOffset = Geometry.createPartsVector(builder, partOffsets);
            geometryOffset = Geometry.createGeometry(builder, 0, 0, 0, 0, 0, 0, geometryType == 0 ? knownGeometryType : (byte)0, partsOffset);
        } else {
            geometryOffset = Geometry.createGeometry(builder, go.endsOffset, go.coordsOffset, go.zOffset, go.mOffset, 0, 0, geometryType == 0 ? knownGeometryType : (byte)0, 0);
        }
        return geometryOffset;
    }

    private static void applyInReverseOrder(org.locationtech.jts.geom.Geometry geometry, CoordinateSequenceFilter filter) {
        int numGeometries = geometry.getNumGeometries();
        if (numGeometries > 1) {
            for (int i = numGeometries - 1; i >= 0; --i) {
                org.locationtech.jts.geom.Geometry sub = geometry.getGeometryN(i);
                GeometryConversions.applyInReverseOrder(sub, filter);
            }
        } else if (geometry instanceof Polygon) {
            Polygon polygon = (Polygon)geometry;
            for (int i = polygon.getNumInteriorRing() - 1; i >= 0; --i) {
                LinearRing hole = polygon.getInteriorRingN(i);
                GeometryConversions.applyInReverseOrder((org.locationtech.jts.geom.Geometry)hole, filter);
            }
            GeometryConversions.applyInReverseOrder((org.locationtech.jts.geom.Geometry)polygon.getExteriorRing(), filter);
        } else {
            geometry.apply(filter);
        }
    }

    public static org.locationtech.jts.geom.Geometry readGeometry(Geometry geometry, int geometryType) {
        GeometryFactory factory = new GeometryFactory();
        if (geometryType == 6) {
            int partsLength = geometry.partsLength();
            Polygon[] polygons = new Polygon[partsLength];
            for (int i = 0; i < geometry.partsLength(); ++i) {
                polygons[i] = (Polygon)GeometryConversions.readGeometry(geometry.parts(i), 3);
            }
            return factory.createMultiPolygon(polygons);
        }
        int xyLength = geometry.xyLength();
        Coordinate[] coordinates = new Coordinate[xyLength >> 1];
        int c = 0;
        for (int i = 0; i < xyLength; i += 2) {
            if (c < geometry.mLength()) {
                coordinates[c++] = new CoordinateXYZM(geometry.xy(i), geometry.xy(i + 1), i >> 1 < geometry.zLength() ? geometry.z(i >> 1) : Double.NaN, i >> 1 < geometry.mLength() ? geometry.m(i >> 1) : Double.NaN);
                continue;
            }
            coordinates[c++] = new Coordinate(geometry.xy(i), geometry.xy(i + 1), i >> 1 < geometry.zLength() ? geometry.z(i >> 1) : Double.NaN);
        }
        IntFunction<Polygon> makePolygonWithRings = endsLength -> {
            LinearRing[] lrs = new LinearRing[endsLength];
            int s = 0;
            for (int i = 0; i < endsLength; ++i) {
                int e = (int)geometry.ends(i);
                Coordinate[] cs = Arrays.copyOfRange(coordinates, s, e);
                lrs[i] = factory.createLinearRing(cs);
                s = e;
            }
            LinearRing shell = lrs[0];
            LinearRing[] holes = Arrays.copyOfRange(lrs, 1, endsLength);
            return factory.createPolygon(shell, holes);
        };
        Supplier<Polygon> makePolygon = () -> {
            int endsLength = geometry.endsLength();
            if (endsLength > 1) {
                return (Polygon)makePolygonWithRings.apply(endsLength);
            }
            return factory.createPolygon(coordinates);
        };
        switch (geometryType) {
            case 0: {
                return null;
            }
            case 1: {
                if (coordinates.length > 0) {
                    return factory.createPoint(coordinates[0]);
                }
                return factory.createPoint();
            }
            case 4: {
                return factory.createMultiPointFromCoords(coordinates);
            }
            case 2: {
                return factory.createLineString(coordinates);
            }
            case 5: {
                int lengthLengths = geometry.endsLength();
                if (lengthLengths < 2) {
                    return factory.createMultiLineString(new LineString[]{factory.createLineString(coordinates)});
                }
                LineString[] lss = new LineString[lengthLengths];
                int s = 0;
                for (int i = 0; i < lengthLengths; ++i) {
                    int e = (int)geometry.ends(i);
                    Coordinate[] cs = Arrays.copyOfRange(coordinates, s, e);
                    lss[i] = factory.createLineString(cs);
                    s = e;
                }
                return factory.createMultiLineString(lss);
            }
            case 3: {
                return (org.locationtech.jts.geom.Geometry)makePolygon.get();
            }
        }
        throw new IllegalArgumentException(UNKNOWN_GEOMETRY_TYPE);
    }

    public static Class<?> getGeometryClass(int geometryType) {
        switch (geometryType) {
            case 0: {
                return Geometry.class;
            }
            case 1: {
                return Point.class;
            }
            case 4: {
                return MultiPoint.class;
            }
            case 2: {
                return LineString.class;
            }
            case 5: {
                return MultiLineString.class;
            }
            case 3: {
                return Polygon.class;
            }
            case 6: {
                return MultiPolygon.class;
            }
        }
        throw new IllegalArgumentException(UNKNOWN_GEOMETRY_TYPE);
    }

    public static byte toGeometryType(Class<?> geometryClass) {
        if (geometryClass == org.locationtech.jts.geom.Geometry.class) {
            return 0;
        }
        if (MultiPoint.class.isAssignableFrom(geometryClass)) {
            return 4;
        }
        if (Point.class.isAssignableFrom(geometryClass)) {
            return 1;
        }
        if (MultiLineString.class.isAssignableFrom(geometryClass)) {
            return 5;
        }
        if (LineString.class.isAssignableFrom(geometryClass)) {
            return 2;
        }
        if (MultiPolygon.class.isAssignableFrom(geometryClass)) {
            return 6;
        }
        if (Polygon.class.isAssignableFrom(geometryClass)) {
            return 3;
        }
        throw new IllegalArgumentException(UNKNOWN_GEOMETRY_TYPE);
    }

    public static class GeometryOffsets {
        private int coordsOffset;
        private int zOffset;
        private int mOffset;
        private long[] ends = null;
        private int[] lengths = null;
        private int endsOffset = 0;
        private int lengthsOffset = 0;
        private int type = 0;
        private GeometryOffsets[] gos = null;

        public int getCoordsOffset() {
            return this.coordsOffset;
        }

        public int getzOffset() {
            return this.zOffset;
        }

        public int getmOffset() {
            return this.mOffset;
        }

        public long[] getEnds() {
            return this.ends;
        }

        public int[] getLengths() {
            return this.lengths;
        }

        public int getEndsOffset() {
            return this.endsOffset;
        }

        public int getLengthsOffset() {
            return this.lengthsOffset;
        }

        public int getType() {
            return this.type;
        }

        public GeometryOffsets[] getGos() {
            return this.gos;
        }

        public void setCoordsOffset(int coordsOffset) {
            this.coordsOffset = coordsOffset;
        }

        public void setzOffset(int zOffset) {
            this.zOffset = zOffset;
        }

        public void setmOffset(int mOffset) {
            this.mOffset = mOffset;
        }

        public void setEnds(long[] ends) {
            this.ends = ends;
        }

        public void setLengths(int[] lengths) {
            this.lengths = lengths;
        }

        public void setEndsOffset(int endsOffset) {
            this.endsOffset = endsOffset;
        }

        public void setLengthsOffset(int lengthsOffset) {
            this.lengthsOffset = lengthsOffset;
        }

        public void setType(int type) {
            this.type = type;
        }

        public void setGos(GeometryOffsets[] gos) {
            this.gos = gos;
        }
    }

    private static class ReverseXYCoordinateSequenceFilter
    implements CoordinateSequenceFilter {
        private FlatBufferBuilder builder;
        boolean hasZ = false;
        boolean hasM = false;

        ReverseXYCoordinateSequenceFilter(FlatBufferBuilder builder) {
            this.builder = builder;
        }

        public void filter(CoordinateSequence seq, int coordIndex) {
            int reverseSeqIndex = seq.size() - coordIndex - 1;
            double y = seq.getOrdinate(reverseSeqIndex, 1);
            double x = seq.getOrdinate(reverseSeqIndex, 0);
            this.builder.addDouble(y);
            this.builder.addDouble(x);
            if (!this.hasZ && seq.hasZ()) {
                this.hasZ = true;
            }
            if (!this.hasM && seq.hasM()) {
                this.hasM = true;
            }
        }

        public boolean isHasZ() {
            return this.hasZ;
        }

        public boolean isHasM() {
            return this.hasM;
        }

        public boolean isGeometryChanged() {
            return false;
        }

        public boolean isDone() {
            return false;
        }
    }

    private static class OrdinateCoordinateSequenceFilter
    implements CoordinateSequenceFilter {
        private FlatBufferBuilder builder;
        private final int ordinateIndex;

        OrdinateCoordinateSequenceFilter(FlatBufferBuilder builder, int ordinateIndex) {
            this.builder = builder;
            this.ordinateIndex = ordinateIndex;
        }

        public void filter(CoordinateSequence seq, int coordIndex) {
            int reverseSeqIndex = seq.size() - coordIndex - 1;
            this.builder.addDouble(seq.getOrdinate(reverseSeqIndex, this.ordinateIndex));
        }

        public boolean isGeometryChanged() {
            return false;
        }

        public boolean isDone() {
            return false;
        }
    }
}

