/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.flatgeobuf;

import com.google.flatbuffers.FlatBufferBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.baremaps.flatgeobuf.FlatGeoBuf;
import org.apache.baremaps.flatgeobuf.GeometryConversions;
import org.apache.baremaps.flatgeobuf.generated.Column;
import org.apache.baremaps.flatgeobuf.generated.Crs;
import org.apache.baremaps.flatgeobuf.generated.Feature;
import org.apache.baremaps.flatgeobuf.generated.Header;
import org.locationtech.jts.geom.Geometry;

public class FlatGeoBufWriter
implements AutoCloseable {
    private final WritableByteChannel channel;
    private Header header;

    public FlatGeoBufWriter(WritableByteChannel channel) {
        this.channel = channel;
    }

    public void writeHeaderBuffer(Header header) throws IOException {
        FlatGeoBufWriter.writeHeaderBuffer(this.channel, header);
    }

    public void writeHeader(FlatGeoBuf.Header header) throws IOException {
        this.header = FlatGeoBufWriter.asFlatBuffer(header);
        FlatGeoBufWriter.writeHeader(this.channel, header);
    }

    public void writeIndexStream(InputStream inputStream) throws IOException {
        FlatGeoBufWriter.writeIndexStream(this.channel, inputStream);
    }

    public void writeIndexBuffer(ByteBuffer buffer) throws IOException {
        FlatGeoBufWriter.writeIndexBuffer(this.channel, buffer);
    }

    public void writeFeatureBuffer(Feature feature) throws IOException {
        FlatGeoBufWriter.writeFeatureBuffer(this.channel, feature);
    }

    public void writeFeature(FlatGeoBuf.Feature feature) throws IOException {
        FlatGeoBufWriter.writeFeature(this.channel, this.header, feature);
    }

    @Override
    public void close() throws IOException {
        this.channel.close();
    }

    public static void writeHeaderBuffer(WritableByteChannel channel, Header header) throws IOException {
        ByteBuffer headerBuffer = header.getByteBuffer();
        ByteBuffer startBuffer = ByteBuffer.allocate(12).order(ByteOrder.LITTLE_ENDIAN);
        startBuffer.put(FlatGeoBuf.MAGIC_BYTES);
        startBuffer.putInt(headerBuffer.remaining());
        startBuffer.flip();
        while (startBuffer.hasRemaining()) {
            channel.write(startBuffer);
        }
        while (headerBuffer.hasRemaining()) {
            channel.write(headerBuffer);
        }
    }

    public static void writeHeader(WritableByteChannel channel, FlatGeoBuf.Header header) throws IOException {
        Header headerFlatGeoBuf = FlatGeoBufWriter.asFlatBuffer(header);
        FlatGeoBufWriter.writeHeaderBuffer(channel, headerFlatGeoBuf);
    }

    public static Header asFlatBuffer(FlatGeoBuf.Header header) {
        FlatBufferBuilder builder = new FlatBufferBuilder(4096);
        int[] columnsArray = header.columns().stream().mapToInt(c -> {
            int nameOffset = builder.createString((CharSequence)c.name());
            int type = c.type().ordinal();
            return Column.createColumn(builder, nameOffset, type, 0, 0, c.width(), c.precision(), c.scale(), c.nullable(), c.unique(), c.primaryKey(), 0);
        }).toArray();
        int columnsOffset = Header.createColumnsVector(builder, columnsArray);
        int envelopeOffset = 0;
        if (header.envelope() != null) {
            envelopeOffset = Header.createEnvelopeVector(builder, header.envelope().stream().mapToDouble(d -> d).toArray());
        }
        int nameOffset = 0;
        if (header.name() != null) {
            nameOffset = builder.createString((CharSequence)header.name());
        }
        int crsOrgOffset = 0;
        if (header.crs() != null && header.crs().org() != null) {
            crsOrgOffset = builder.createString((CharSequence)header.crs().org());
        }
        int crsNameOffset = 0;
        if (header.crs() != null && header.crs().name() != null) {
            crsNameOffset = builder.createString((CharSequence)header.crs().name());
        }
        int crsDescriptionOffset = 0;
        if (header.crs() != null && header.crs().description() != null) {
            crsDescriptionOffset = builder.createString((CharSequence)header.crs().description());
        }
        int crsWktOffset = 0;
        if (header.crs() != null && header.crs().wkt() != null) {
            crsWktOffset = builder.createString((CharSequence)header.crs().wkt());
        }
        int crsCodeStringOffset = 0;
        if (header.crs() != null && header.crs().codeString() != null) {
            crsCodeStringOffset = builder.createString((CharSequence)header.crs().codeString());
        }
        Crs.startCrs(builder);
        Crs.addOrg(builder, crsOrgOffset);
        if (header.crs() != null) {
            Crs.addCode(builder, header.crs().code());
        }
        Crs.addName(builder, crsNameOffset);
        Crs.addDescription(builder, crsDescriptionOffset);
        Crs.addWkt(builder, crsWktOffset);
        Crs.addCodeString(builder, crsCodeStringOffset);
        int crsOffset = Crs.endCrs(builder);
        Header.startHeader(builder);
        Header.addGeometryType(builder, header.geometryType().getValue());
        Header.addFeaturesCount(builder, header.featuresCount());
        Header.addIndexNodeSize(builder, header.indexNodeSize());
        Header.addColumns(builder, columnsOffset);
        Header.addEnvelope(builder, envelopeOffset);
        Header.addName(builder, nameOffset);
        Header.addCrs(builder, crsOffset);
        int offset = Header.endHeader(builder);
        builder.finish(offset);
        ByteBuffer buffer = builder.dataBuffer().asReadOnlyBuffer();
        return Header.getRootAsHeader(buffer);
    }

    public static void writeFeatureBuffer(WritableByteChannel channel, Feature feature) throws IOException {
        ByteBuffer sizeBuffer = ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN);
        sizeBuffer.putInt(feature.getByteBuffer().remaining());
        sizeBuffer.flip();
        while (sizeBuffer.hasRemaining()) {
            channel.write(sizeBuffer);
        }
        ByteBuffer featureBuffer = feature.getByteBuffer().duplicate();
        while (featureBuffer.hasRemaining()) {
            channel.write(featureBuffer);
        }
    }

    public static void writeFeature(WritableByteChannel channel, Header header, FlatGeoBuf.Feature feature) throws IOException {
        Feature flatBuffer = FlatGeoBufWriter.asFlatBuffer(header, feature);
        FlatGeoBufWriter.writeFeatureBuffer(channel, flatBuffer);
    }

    public static Feature asFlatBuffer(Header header, FlatGeoBuf.Feature feature) {
        FlatBufferBuilder builder = new FlatBufferBuilder(4096);
        ByteBuffer propertiesBuffer = ByteBuffer.allocate(0x100000).order(ByteOrder.LITTLE_ENDIAN);
        List<Object> properties = feature.properties();
        for (int i = 0; i < properties.size(); ++i) {
            Column column = header.columns(i);
            Object value = properties.get(i);
            propertiesBuffer.putShort((short)i);
            FlatGeoBufWriter.writeValue(propertiesBuffer, column, value);
        }
        if (propertiesBuffer.position() > 0) {
            propertiesBuffer.flip();
        }
        int propertiesOffset = Feature.createPropertiesVector(builder, propertiesBuffer);
        Geometry geometry = feature.geometry();
        int geometryOffset = 0;
        if (geometry != null) {
            geometryOffset = GeometryConversions.writeGeometry(builder, geometry, (byte)header.geometryType());
        }
        Feature.startFeature(builder);
        Feature.addGeometry(builder, geometryOffset);
        Feature.addProperties(builder, propertiesOffset);
        Feature.addColumns(builder, 0);
        int offset = Feature.endFeature(builder);
        builder.finish(offset);
        ByteBuffer buffer = builder.dataBuffer().asReadOnlyBuffer();
        return Feature.getRootAsFeature(buffer);
    }

    private static void writeValue(ByteBuffer buffer, Column column, Object value) {
        switch (column.type()) {
            case 2: {
                buffer.put((byte)((Boolean)value != false ? 1 : 0));
                break;
            }
            case 3: {
                buffer.putShort((Short)value);
                break;
            }
            case 4: {
                buffer.putShort((Short)value);
                break;
            }
            case 5: {
                buffer.putInt((Integer)value);
                break;
            }
            case 6: {
                buffer.putInt((Integer)value);
                break;
            }
            case 7: {
                buffer.putLong((Long)value);
                break;
            }
            case 8: {
                buffer.putLong((Long)value);
                break;
            }
            case 9: {
                buffer.putFloat(((Float)value).floatValue());
                break;
            }
            case 10: {
                buffer.putDouble((Double)value);
                break;
            }
            case 11: {
                FlatGeoBufWriter.writeString(buffer, value);
                break;
            }
            case 12: {
                FlatGeoBufWriter.writeJson(buffer, value);
                break;
            }
            case 13: {
                FlatGeoBufWriter.writeDateTime(buffer, value);
                break;
            }
            case 14: {
                FlatGeoBufWriter.writeBinary(buffer, value);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }

    private static void writeString(ByteBuffer buffer, Object value) {
        byte[] bytes = ((String)value).getBytes(StandardCharsets.UTF_8);
        buffer.putInt(bytes.length);
        buffer.put(bytes);
    }

    private static void writeJson(ByteBuffer buffer, Object value) {
        throw new UnsupportedOperationException();
    }

    private static void writeDateTime(ByteBuffer buffer, Object value) {
        throw new UnsupportedOperationException();
    }

    private static void writeBinary(ByteBuffer buffer, Object value) {
        throw new UnsupportedOperationException();
    }

    public static void writeIndexStream(WritableByteChannel channel, InputStream inputStream) throws IOException {
        try (OutputStream outputStream = Channels.newOutputStream(channel);){
            outputStream.write(inputStream.readAllBytes());
        }
    }

    public static void writeIndexBuffer(WritableByteChannel channel, ByteBuffer buffer) throws IOException {
        while (buffer.hasRemaining()) {
            channel.write(buffer);
        }
    }
}

