/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.ipresource;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.SortedMap;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.TreeMap;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.ripe.ipresource.IpResource;
import net.ripe.ipresource.IpResourceSet;
import net.ripe.ipresource.IpResourceType;
import net.ripe.ipresource.UniqueIpResource;

public final class ImmutableResourceSet
implements Iterable<IpResource>,
Serializable {
    public static final ImmutableResourceSet IP_PRIVATE_USE_RESOURCES = ImmutableResourceSet.parse("10.0.0.0/8,172.16.0.0/12,192.168.0.0/16,fc00::/7");
    public static final ImmutableResourceSet ASN_PRIVATE_USE_RESOURCES = ImmutableResourceSet.parse("AS64512-AS65534,AS4200000000-AS4294967294");
    public static final ImmutableResourceSet ALL_PRIVATE_USE_RESOURCES = ASN_PRIVATE_USE_RESOURCES.union(IP_PRIVATE_USE_RESOURCES);
    private static final long serialVersionUID = 1L;
    private static final ImmutableResourceSet EMPTY = new ImmutableResourceSet();
    private static final ImmutableResourceSet UNIVERSAL = ImmutableResourceSet.of(IpResource.ALL_AS_RESOURCES, IpResource.ALL_IPV4_RESOURCES, IpResource.ALL_IPV6_RESOURCES);
    final TreeMap<UniqueIpResource, IpResource> resourcesByEndPoint;

    private ImmutableResourceSet() {
        this.resourcesByEndPoint = new TreeMap();
    }

    private ImmutableResourceSet(TreeMap<UniqueIpResource, IpResource> resourcesByEndPoint) {
        if (resourcesByEndPoint.isEmpty()) {
            throw new IllegalArgumentException("empty resource set must use ImmutableResourceSet.empty()");
        }
        this.resourcesByEndPoint = resourcesByEndPoint;
    }

    public static ImmutableResourceSet of() {
        return ImmutableResourceSet.empty();
    }

    public static ImmutableResourceSet of(IpResource resource) {
        TreeMap<UniqueIpResource, IpResource> resourcesByEndpoint = new TreeMap<UniqueIpResource, IpResource>();
        resourcesByEndpoint.put(resource.getEnd(), ImmutableResourceSet.normalize(resource));
        return new ImmutableResourceSet(resourcesByEndpoint);
    }

    public static ImmutableResourceSet of(IpResource ... resources) {
        return resources.length == 0 ? ImmutableResourceSet.empty() : ImmutableResourceSet.of(Arrays.asList(resources));
    }

    public static ImmutableResourceSet of(Iterable<? extends IpResource> resources) {
        if (resources instanceof ImmutableResourceSet) {
            return (ImmutableResourceSet)resources;
        }
        if (resources instanceof IpResourceSet) {
            return ImmutableResourceSet.of((IpResourceSet)resources);
        }
        return new Builder(resources).build();
    }

    public static ImmutableResourceSet of(IpResourceSet resources) {
        return resources.isEmpty() ? ImmutableResourceSet.empty() : new ImmutableResourceSet(resources.resourcesByEndPoint);
    }

    public static ImmutableResourceSet empty() {
        return EMPTY;
    }

    public static ImmutableResourceSet universal() {
        return UNIVERSAL;
    }

    public static Collector<IpResource, Builder, ImmutableResourceSet> collector() {
        return Collector.of(Builder::new, Builder::add, (a, b) -> a.addAll(((Builder)b).resourcesByEndPoint.values()), Builder::build, Collector.Characteristics.UNORDERED);
    }

    public ImmutableResourceSet add(IpResource value) {
        if (this.contains(value)) {
            return this;
        }
        return new Builder(this).add(value).build();
    }

    public ImmutableResourceSet remove(IpResource value) {
        if (!this.intersects(value)) {
            return this;
        }
        return new Builder(this).remove(value).build();
    }

    public ImmutableResourceSet union(ImmutableResourceSet that) {
        if (this.isEmpty()) {
            return that;
        }
        if (that.isEmpty()) {
            return this;
        }
        if (this.resourcesByEndPoint.size() < that.resourcesByEndPoint.size()) {
            return new Builder(that).addAll(this.resourcesByEndPoint.values()).build();
        }
        return new Builder(this).addAll(that.resourcesByEndPoint.values()).build();
    }

    public ImmutableResourceSet intersection(ImmutableResourceSet that) {
        if (this.isEmpty()) {
            return this;
        }
        if (that.isEmpty()) {
            return that;
        }
        TreeMap<UniqueIpResource, IpResource> temp = new TreeMap<UniqueIpResource, IpResource>();
        Iterator<IpResource> thisIterator = this.iterator();
        Iterator<IpResource> thatIterator = that.iterator();
        IpResource thisResource = thisIterator.next();
        IpResource thatResource = thatIterator.next();
        while (thisResource != null && thatResource != null) {
            int compareTo;
            IpResource intersect = thisResource.intersect(thatResource);
            if (intersect != null) {
                temp.put(intersect.getEnd(), ImmutableResourceSet.normalize(intersect));
            }
            if ((compareTo = thisResource.getEnd().compareTo(thatResource.getEnd())) <= 0) {
                IpResource ipResource = thisResource = thisIterator.hasNext() ? thisIterator.next() : null;
            }
            if (compareTo < 0) continue;
            thatResource = thatIterator.hasNext() ? thatIterator.next() : null;
        }
        return temp.isEmpty() ? ImmutableResourceSet.empty() : new ImmutableResourceSet(temp);
    }

    public ImmutableResourceSet difference(ImmutableResourceSet that) {
        if (!this.intersects(that)) {
            return this;
        }
        return new Builder(this).removeAll(that).build();
    }

    public ImmutableResourceSet complement() {
        return ImmutableResourceSet.universal().difference(this);
    }

    @Override
    public Iterator<IpResource> iterator() {
        return Collections.unmodifiableMap(this.resourcesByEndPoint).values().iterator();
    }

    @Override
    public Spliterator<IpResource> spliterator() {
        return Spliterators.spliterator(this.resourcesByEndPoint.values(), 1029);
    }

    public Stream<IpResource> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    public boolean isEmpty() {
        return this.resourcesByEndPoint.isEmpty();
    }

    public boolean contains(IpResource resource) {
        Map.Entry<UniqueIpResource, IpResource> potentialMatch = this.resourcesByEndPoint.ceilingEntry(resource.getStart());
        return potentialMatch != null && potentialMatch.getValue().contains(resource);
    }

    public boolean contains(Iterable<? extends IpResource> other) {
        for (IpResource ipResource : other) {
            if (this.contains(ipResource)) continue;
            return false;
        }
        return true;
    }

    public boolean containsType(IpResourceType type) {
        for (IpResource resource : this.resourcesByEndPoint.values()) {
            if (type != resource.getType()) continue;
            return true;
        }
        return false;
    }

    public boolean intersects(IpResource resource) {
        Map.Entry<UniqueIpResource, IpResource> potentialMatch = this.resourcesByEndPoint.ceilingEntry(resource.getStart());
        return potentialMatch != null && potentialMatch.getValue().overlaps(resource);
    }

    public boolean intersects(ImmutableResourceSet that) {
        if (this.isEmpty() || that.isEmpty()) {
            return false;
        }
        Iterator<IpResource> thisIterator = this.iterator();
        Iterator<IpResource> thatIterator = that.iterator();
        IpResource thisResource = thisIterator.next();
        IpResource thatResource = thatIterator.next();
        while (thisResource != null && thatResource != null) {
            if (thisResource.overlaps(thatResource)) {
                return true;
            }
            int compareTo = thisResource.getEnd().compareTo(thatResource.getEnd());
            if (compareTo <= 0) {
                IpResource ipResource = thisResource = thisIterator.hasNext() ? thisIterator.next() : null;
            }
            if (compareTo < 0) continue;
            thatResource = thatIterator.hasNext() ? thatIterator.next() : null;
        }
        return false;
    }

    public static ImmutableResourceSet parse(String s) {
        String[] resources = s.split(",");
        Builder builder = new Builder();
        for (String r : resources) {
            String trimmed = r.trim();
            if (trimmed.isEmpty()) continue;
            builder.add(IpResource.parse(trimmed));
        }
        return builder.build();
    }

    public String toString() {
        return this.resourcesByEndPoint.values().stream().map(Objects::toString).collect(Collectors.joining(", "));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ImmutableResourceSet)) {
            return false;
        }
        ImmutableResourceSet other = (ImmutableResourceSet)obj;
        return this.resourcesByEndPoint.equals(other.resourcesByEndPoint);
    }

    public int hashCode() {
        return this.resourcesByEndPoint.hashCode();
    }

    private static IpResource normalize(IpResource resource) {
        return resource.isUnique() ? resource.getStart() : resource;
    }

    public static class Builder {
        private TreeMap<UniqueIpResource, IpResource> resourcesByEndPoint;

        public Builder() {
            this.resourcesByEndPoint = new TreeMap();
        }

        public Builder(ImmutableResourceSet resources) {
            this.resourcesByEndPoint = new TreeMap<UniqueIpResource, IpResource>((SortedMap<UniqueIpResource, IpResource>)resources.resourcesByEndPoint);
        }

        public Builder(IpResourceSet resources) {
            this.resourcesByEndPoint = new TreeMap<UniqueIpResource, IpResource>((SortedMap<UniqueIpResource, IpResource>)resources.resourcesByEndPoint);
        }

        public Builder(Iterable<? extends IpResource> resources) {
            if (resources instanceof ImmutableResourceSet) {
                this.resourcesByEndPoint = new TreeMap<UniqueIpResource, IpResource>((SortedMap<UniqueIpResource, IpResource>)((ImmutableResourceSet)resources).resourcesByEndPoint);
            } else if (resources instanceof IpResourceSet) {
                this.resourcesByEndPoint = new TreeMap<UniqueIpResource, IpResource>((SortedMap<UniqueIpResource, IpResource>)((IpResourceSet)resources).resourcesByEndPoint);
            } else {
                this.resourcesByEndPoint = new TreeMap();
                for (IpResource ipResource : resources) {
                    this.add(ipResource);
                }
            }
        }

        public ImmutableResourceSet build() {
            this.assertNotAlreadyUsed();
            try {
                ImmutableResourceSet immutableResourceSet = this.resourcesByEndPoint.isEmpty() ? ImmutableResourceSet.empty() : new ImmutableResourceSet(this.resourcesByEndPoint);
                return immutableResourceSet;
            }
            finally {
                this.resourcesByEndPoint = null;
            }
        }

        public Builder addAll(Iterable<? extends IpResource> resources) {
            this.assertNotAlreadyUsed();
            for (IpResource ipResource : resources) {
                this.add(ipResource);
            }
            return this;
        }

        public Builder removeAll(Iterable<? extends IpResource> resources) {
            this.assertNotAlreadyUsed();
            for (IpResource ipResource : resources) {
                this.remove(ipResource);
            }
            return this;
        }

        public Builder add(IpResource resource) {
            IpResource potentialMatch;
            this.assertNotAlreadyUsed();
            UniqueIpResource start = resource.getStart();
            if (!start.equals(start.getType().getMinimum())) {
                start = start.predecessor();
            }
            Iterator iterator = this.resourcesByEndPoint.tailMap(start, true).values().iterator();
            while (iterator.hasNext() && resource.isMergeable(potentialMatch = (IpResource)iterator.next())) {
                iterator.remove();
                resource = resource.merge(potentialMatch);
            }
            this.resourcesByEndPoint.put(resource.getEnd(), ImmutableResourceSet.normalize(resource));
            return this;
        }

        public Builder remove(IpResource resource) {
            this.assertNotAlreadyUsed();
            Map.Entry<UniqueIpResource, IpResource> potentialMatch = this.resourcesByEndPoint.ceilingEntry(resource.getStart());
            while (potentialMatch != null && potentialMatch.getValue().overlaps(resource)) {
                this.resourcesByEndPoint.remove(potentialMatch.getKey());
                for (IpResource ipResource : potentialMatch.getValue().subtract(resource)) {
                    this.resourcesByEndPoint.put(ipResource.getEnd(), ImmutableResourceSet.normalize(ipResource));
                }
                potentialMatch = this.resourcesByEndPoint.ceilingEntry(resource.getStart());
            }
            return this;
        }

        private void assertNotAlreadyUsed() {
            if (this.resourcesByEndPoint == null) {
                throw new IllegalStateException("builder can only be used once");
            }
        }
    }
}

