/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.geoparquet;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashMap;
import org.apache.baremaps.geoparquet.GeoParquetException;
import org.apache.baremaps.geoparquet.GeoParquetGroup;
import org.apache.baremaps.geoparquet.GeoParquetMetadata;
import org.apache.hadoop.conf.Configuration;
import org.apache.parquet.hadoop.api.WriteSupport;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.io.api.RecordConsumer;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;

public class GeoParquetWriteSupport
extends WriteSupport<GeoParquetGroup> {
    private Configuration configuration;
    private final MessageType schema;
    private final GeoParquetMetadata metadata;
    private RecordConsumer recordConsumer;
    private final ObjectMapper objectMapper = new ObjectMapper();

    public GeoParquetWriteSupport(MessageType schema, GeoParquetMetadata metadata) {
        this.schema = schema;
        this.metadata = metadata;
    }

    public WriteSupport.WriteContext init(Configuration configuration) {
        HashMap<String, String> extraMetadata = new HashMap<String, String>();
        String geoMetadataJson = this.serializeMetadata(this.metadata);
        extraMetadata.put("geo", geoMetadataJson);
        return new WriteSupport.WriteContext(this.schema, extraMetadata);
    }

    public void prepareForWrite(RecordConsumer recordConsumer) {
        this.recordConsumer = recordConsumer;
    }

    public void write(GeoParquetGroup group) {
        this.recordConsumer.startMessage();
        this.writeGroup(group, (GroupType)this.schema, true);
        this.recordConsumer.endMessage();
    }

    private void writeGroup(GeoParquetGroup group, GroupType groupType, boolean isRoot) {
        if (!isRoot) {
            this.recordConsumer.startGroup();
        }
        for (int i = 0; i < groupType.getFieldCount(); ++i) {
            Type fieldType = groupType.getType(i);
            String fieldName = fieldType.getName();
            int repetitionCount = group.getFieldRepetitionCount(i);
            if (repetitionCount == 0) continue;
            for (int j = 0; j < repetitionCount; ++j) {
                this.recordConsumer.startField(fieldName, i);
                if (fieldType.isPrimitive()) {
                    Object value = group.getValue(i, j);
                    this.writePrimitive(value, fieldType.asPrimitiveType());
                } else {
                    GeoParquetGroup childGroup = group.getGroup(i, j);
                    this.writeGroup(childGroup, fieldType.asGroupType(), false);
                }
                this.recordConsumer.endField(fieldName, i);
            }
        }
        if (!isRoot) {
            this.recordConsumer.endGroup();
        }
    }

    private void writePrimitive(Object value, PrimitiveType primitiveType) {
        if (value == null) {
            return;
        }
        switch (primitiveType.getPrimitiveTypeName()) {
            case INT32: {
                this.recordConsumer.addInteger(((Integer)value).intValue());
                break;
            }
            case INT64: {
                this.recordConsumer.addLong(((Long)value).longValue());
                break;
            }
            case FLOAT: {
                this.recordConsumer.addFloat(((Float)value).floatValue());
                break;
            }
            case DOUBLE: {
                this.recordConsumer.addDouble(((Double)value).doubleValue());
                break;
            }
            case BOOLEAN: {
                this.recordConsumer.addBoolean(((Boolean)value).booleanValue());
                break;
            }
            case BINARY: 
            case FIXED_LEN_BYTE_ARRAY: {
                this.recordConsumer.addBinary((Binary)value);
                break;
            }
            default: {
                throw new GeoParquetException("Unsupported type: " + String.valueOf(primitiveType.getPrimitiveTypeName()));
            }
        }
    }

    private String serializeMetadata(GeoParquetMetadata metadata) {
        try {
            return this.objectMapper.writeValueAsString((Object)metadata);
        }
        catch (JsonProcessingException e) {
            throw new GeoParquetException("Failed to serialize GeoParquet metadata", e);
        }
    }
}

