/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.util.jackson;

import org.apache.flink.annotation.Experimental;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonFactory;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.Module;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.SerializationFeature;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.dataformat.csv.CsvMapper;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;

@Experimental
public final class JacksonMapperFactory {
    public static ObjectMapper createObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        JacksonMapperFactory.registerModules(objectMapper);
        return objectMapper;
    }

    public static ObjectMapper createObjectMapper(JsonFactory jsonFactory) {
        ObjectMapper objectMapper = new ObjectMapper(jsonFactory);
        JacksonMapperFactory.registerModules(objectMapper);
        return objectMapper;
    }

    public static CsvMapper createCsvMapper() {
        CsvMapper csvMapper = new CsvMapper();
        JacksonMapperFactory.registerModules((ObjectMapper)csvMapper);
        return csvMapper;
    }

    private static void registerModules(ObjectMapper mapper) {
        mapper.registerModule((Module)new JavaTimeModule()).registerModule((Module)new Jdk8Module().configureAbsentsAsNulls(true)).disable(SerializationFeature.WRITE_DURATIONS_AS_TIMESTAMPS).disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
    }

    private JacksonMapperFactory() {
    }
}

