/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.v2;

import java.io.Serializable;
import org.apache.spark.SparkEnv$;
import org.apache.spark.TaskContext;
import org.apache.spark.internal.Logging;
import org.apache.spark.scheduler.OutputCommitCoordinator;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.connector.write.DataWriter;
import org.apache.spark.sql.connector.write.DataWriterFactory;
import org.apache.spark.sql.connector.write.WriterCommitMessage;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.execution.datasources.v2.DataWritingSparkTaskResult;
import org.apache.spark.sql.execution.metric.CustomMetrics$;
import org.apache.spark.sql.execution.metric.SQLMetric;
import org.apache.spark.util.Utils$;
import scala.Function0;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.compat.immutable.ArraySeq$;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.LongRef;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001u4q\u0001B\u0003\u0011\u0002\u0007\u0005A\u0003C\u0003&\u0001\u0011\u0005a\u0005C\u0003+\u0001\u0019E1\u0006C\u0003G\u0001\u0011\u0005qI\u0001\tXe&$\u0018N\\4Ta\u0006\u00148\u000eV1tW*\u0011aaB\u0001\u0003mJR!\u0001C\u0005\u0002\u0017\u0011\fG/Y:pkJ\u001cWm\u001d\u0006\u0003\u0015-\t\u0011\"\u001a=fGV$\u0018n\u001c8\u000b\u00051i\u0011aA:rY*\u0011abD\u0001\u0006gB\f'o\u001b\u0006\u0003!E\ta!\u00199bG\",'\"\u0001\n\u0002\u0007=\u0014xm\u0001\u0001\u0016\u0005U\u00014\u0003\u0002\u0001\u00179\t\u0002\"a\u0006\u000e\u000e\u0003aQ\u0011!G\u0001\u0006g\u000e\fG.Y\u0005\u00037a\u0011a!\u00118z%\u00164\u0007CA\u000f!\u001b\u0005q\"BA\u0010\u000e\u0003!Ig\u000e^3s]\u0006d\u0017BA\u0011\u001f\u0005\u001daunZ4j]\u001e\u0004\"aF\u0012\n\u0005\u0011B\"\u0001D*fe&\fG.\u001b>bE2,\u0017A\u0002\u0013j]&$H\u0005F\u0001(!\t9\u0002&\u0003\u0002*1\t!QK\\5u\u0003%9(/\u001b;f\rVt7\rF\u0002(Y\u0011CQ!\f\u0002A\u00029\naa\u001e:ji\u0016\u0014\bCA\u00181\u0019\u0001!Q!\r\u0001C\u0002I\u0012\u0011aV\t\u0003gY\u0002\"a\u0006\u001b\n\u0005UB\"a\u0002(pi\"Lgn\u001a\t\u0004oqrT\"\u0001\u001d\u000b\u0005eR\u0014!B<sSR,'BA\u001e\f\u0003%\u0019wN\u001c8fGR|'/\u0003\u0002>q\tQA)\u0019;b/JLG/\u001a:\u0011\u0005}\u0012U\"\u0001!\u000b\u0005\u0005[\u0011\u0001C2bi\u0006d\u0017p\u001d;\n\u0005\r\u0003%aC%oi\u0016\u0014h.\u00197S_^DQ!\u0012\u0002A\u0002y\n1A]8x\u0003\r\u0011XO\u001c\u000b\u0007\u00112\u000bv+\u001a6\u0011\u0005%SU\"A\u0003\n\u0005-+!A\u0007#bi\u0006<&/\u001b;j]\u001e\u001c\u0006/\u0019:l)\u0006\u001c8NU3tk2$\b\"B'\u0004\u0001\u0004q\u0015!D<sSR,'OR1di>\u0014\u0018\u0010\u0005\u00028\u001f&\u0011\u0001\u000b\u000f\u0002\u0012\t\u0006$\u0018m\u0016:ji\u0016\u0014h)Y2u_JL\b\"\u0002*\u0004\u0001\u0004\u0019\u0016aB2p]R,\u0007\u0010\u001e\t\u0003)Vk\u0011!D\u0005\u0003-6\u00111\u0002V1tW\u000e{g\u000e^3yi\")\u0001l\u0001a\u00013\u0006!\u0011\u000e^3s!\rQ&M\u0010\b\u00037\u0002t!\u0001X0\u000e\u0003uS!AX\n\u0002\rq\u0012xn\u001c;?\u0013\u0005I\u0012BA1\u0019\u0003\u001d\u0001\u0018mY6bO\u0016L!a\u00193\u0003\u0011%#XM]1u_JT!!\u0019\r\t\u000b\u0019\u001c\u0001\u0019A4\u0002)U\u001cXmQ8n[&$8i\\8sI&t\u0017\r^8s!\t9\u0002.\u0003\u0002j1\t9!i\\8mK\u0006t\u0007\"B6\u0004\u0001\u0004a\u0017!D2vgR|W.T3ue&\u001c7\u000f\u0005\u0003ncR<hB\u00018p!\ta\u0006$\u0003\u0002q1\u00051\u0001K]3eK\u001aL!A]:\u0003\u00075\u000b\u0007O\u0003\u0002q1A\u0011Q.^\u0005\u0003mN\u0014aa\u0015;sS:<\u0007C\u0001=|\u001b\u0005I(B\u0001>\n\u0003\u0019iW\r\u001e:jG&\u0011A0\u001f\u0002\n'FcU*\u001a;sS\u000e\u0004")
public interface WritingSparkTask<W extends DataWriter<InternalRow>>
extends Logging,
scala.Serializable {
    public void writeFunc(W var1, InternalRow var2);

    public static /* synthetic */ DataWritingSparkTaskResult run$(WritingSparkTask $this, DataWriterFactory writerFactory, TaskContext context, Iterator iter, boolean useCommitCoordinator, Map customMetrics) {
        return $this.run(writerFactory, context, (Iterator<InternalRow>)iter, useCommitCoordinator, (Map<String, SQLMetric>)customMetrics);
    }

    default public DataWritingSparkTaskResult run(DataWriterFactory writerFactory, TaskContext context, Iterator<InternalRow> iter, boolean useCommitCoordinator, Map<String, SQLMetric> customMetrics) {
        int stageId = context.stageId();
        int stageAttempt = context.stageAttemptNumber();
        int partId = context.partitionId();
        long taskId = context.taskAttemptId();
        int attemptId = context.attemptNumber();
        DataWriter dataWriter = writerFactory.createWriter(partId, taskId);
        LongRef count = LongRef.create((long)0L);
        return (DataWritingSparkTaskResult)Utils$.MODULE$.tryWithSafeFinallyAndFailureCallbacks((Function0 & Serializable & scala.Serializable)() -> {
            WriterCommitMessage writerCommitMessage;
            while (iter.hasNext()) {
                if (count$1.elem % (long)CustomMetrics$.MODULE$.NUM_ROWS_PER_UPDATE() == 0L) {
                    CustomMetrics$.MODULE$.updateMetrics((Seq)ArraySeq$.MODULE$.unsafeWrapArray((Object)dataWriter.currentMetricsValues()), customMetrics);
                }
                ++count$1.elem;
                this.writeFunc(dataWriter, (InternalRow)iter.next());
            }
            CustomMetrics$.MODULE$.updateMetrics((Seq)ArraySeq$.MODULE$.unsafeWrapArray((Object)dataWriter.currentMetricsValues()), customMetrics);
            if (useCommitCoordinator) {
                OutputCommitCoordinator coordinator = SparkEnv$.MODULE$.get().outputCommitCoordinator();
                boolean commitAuthorized = coordinator.canCommit(stageId, stageAttempt, partId, attemptId);
                if (!commitAuthorized) {
                    Throwable commitDeniedException = QueryExecutionErrors$.MODULE$.commitDeniedError(partId, taskId, attemptId, stageId, stageAttempt);
                    this.logInfo((Function0 & Serializable & scala.Serializable)() -> commitDeniedException.getMessage());
                    throw commitDeniedException;
                }
                this.logInfo((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(59).append("Commit authorized for partition ").append(partId).append(" (task ").append(taskId).append(", attempt ").append(attemptId).append(", ").append("stage ").append(stageId).append(".").append(stageAttempt).append(")").toString());
                writerCommitMessage = dataWriter.commit();
            } else {
                this.logInfo((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(36).append("Writer for partition ").append(context.partitionId()).append(" is committing.").toString());
                writerCommitMessage = dataWriter.commit();
            }
            WriterCommitMessage msg = writerCommitMessage;
            this.logInfo((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(47).append("Committed partition ").append(partId).append(" (task ").append(taskId).append(", attempt ").append(attemptId).append(", ").append("stage ").append(stageId).append(".").append(stageAttempt).append(")").toString());
            return new DataWritingSparkTaskResult(count$1.elem, msg);
        }, (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.logError((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(57).append("Aborting commit for partition ").append(partId).append(" (task ").append(taskId).append(", attempt ").append(attemptId).append(", ").append("stage ").append(stageId).append(".").append(stageAttempt).append(")").toString());
            dataWriter.abort();
            this.logError((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(56).append("Aborted commit for partition ").append(partId).append(" (task ").append(taskId).append(", attempt ").append(attemptId).append(", ").append("stage ").append(stageId).append(".").append(stageAttempt).append(")").toString());
        }, (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> dataWriter.close());
    }

    public static void $init$(WritingSparkTask $this) {
    }
}

