/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.metastorage.cache;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.apache.ignite3.configuration.ConfigurationValue;
import org.apache.ignite3.internal.failure.FailureContext;
import org.apache.ignite3.internal.failure.FailureProcessor;
import org.apache.ignite3.internal.hlc.ClockService;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.logger.IgniteLogger;
import org.apache.ignite3.internal.logger.Loggers;
import org.apache.ignite3.internal.manager.ComponentContext;
import org.apache.ignite3.internal.manager.IgniteComponent;
import org.apache.ignite3.internal.metastorage.impl.ElectionListener;
import org.apache.ignite3.internal.network.InternalClusterNode;
import org.apache.ignite3.internal.util.CompletableFutures;

public class IdempotentCacheVacuumizer
implements IgniteComponent,
ElectionListener {
    private static final IgniteLogger LOG = Loggers.forClass(IdempotentCacheVacuumizer.class);
    private final AtomicBoolean triggerVacuumization;
    private final String nodeName;
    private final ScheduledExecutorService scheduler;
    private final Consumer<HybridTimestamp> vacuumizationAction;
    private final ConfigurationValue<Long> idempotentCacheTtl;
    private final ClockService clockService;
    private final FailureProcessor failureProcessor;
    private final long initialDelay;
    private final long delay;
    private final TimeUnit unit;
    private volatile ScheduledFuture<?> scheduledFuture;

    public IdempotentCacheVacuumizer(String nodeName, ScheduledExecutorService scheduler, Consumer<HybridTimestamp> vacuumizationAction, ConfigurationValue<Long> idempotentCacheTtl, ClockService clockService, FailureProcessor failureProcessor, long initialDelay, long delay, TimeUnit unit) {
        this.nodeName = nodeName;
        this.triggerVacuumization = new AtomicBoolean(false);
        this.scheduler = scheduler;
        this.vacuumizationAction = vacuumizationAction;
        this.idempotentCacheTtl = idempotentCacheTtl;
        this.clockService = clockService;
        this.failureProcessor = failureProcessor;
        this.initialDelay = initialDelay;
        this.delay = delay;
        this.unit = unit;
    }

    @Override
    public CompletableFuture<Void> startAsync(ComponentContext componentContext) {
        this.scheduledFuture = this.scheduler.scheduleWithFixedDelay(() -> {
            if (this.triggerVacuumization.get()) {
                try {
                    HybridTimestamp evictionTimestamp = this.clockService.current().subtractPhysicalTime((Long)this.idempotentCacheTtl.value() + this.clockService.maxClockSkewMillis());
                    this.vacuumizationAction.accept(evictionTimestamp);
                }
                catch (Exception e) {
                    String errorMessage = "An exception occurred while executing idempotent cache vacuumization action. Idempotent cache vacuumizer won't be stopped.";
                    this.failureProcessor.process(new FailureContext(e, errorMessage));
                }
            }
        }, this.initialDelay, this.delay, this.unit);
        return CompletableFutures.nullCompletedFuture();
    }

    @Override
    public CompletableFuture<Void> stopAsync(ComponentContext componentContext) {
        if (this.scheduledFuture != null) {
            this.scheduledFuture.cancel(false);
        }
        return CompletableFutures.nullCompletedFuture();
    }

    @Override
    public void onLeaderElected(InternalClusterNode newLeader) {
        if (newLeader.name().equals(this.nodeName)) {
            this.startLocalVacuumizationTriggering();
        } else {
            this.suspendLocalVacuumizationTriggering();
        }
    }

    void startLocalVacuumizationTriggering() {
        this.triggerVacuumization.set(true);
        LOG.info("Idempotent cache vacuumizer started.", new Object[0]);
    }

    void suspendLocalVacuumizationTriggering() {
        this.triggerVacuumization.set(false);
        LOG.info("Idempotent cache vacuumizer suspended.", new Object[0]);
    }
}

