/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.access;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.access.IteratorCompleteNodeGen;
import com.oracle.truffle.js.nodes.access.PropertyGetNode;
import com.oracle.truffle.js.nodes.cast.JSToBooleanNode;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.Strings;

@GenerateUncached
public abstract class IteratorCompleteNode
extends JavaScriptBaseNode {
    protected IteratorCompleteNode() {
    }

    public abstract boolean execute(Object var1);

    @Specialization
    protected boolean iteratorComplete(Object iterResult, @Cached(value="createGetDoneNode()", uncached="getNullNode()") PropertyGetNode getDoneNode, @Cached(inline=true) JSToBooleanNode toBooleanNode) {
        Object done = getDoneNode != null ? getDoneNode.getValue(iterResult) : JSRuntime.get(iterResult, Strings.DONE);
        return toBooleanNode.executeBoolean(this, done);
    }

    @NeverDefault
    public static IteratorCompleteNode create() {
        return IteratorCompleteNodeGen.create();
    }

    @NeverDefault
    public static IteratorCompleteNode getUncached() {
        return IteratorCompleteNodeGen.getUncached();
    }

    @NeverDefault
    PropertyGetNode createGetDoneNode() {
        return PropertyGetNode.create(Strings.DONE, this.getLanguage().getJSContext());
    }
}

