/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.security.authorization;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hive.ql.ddl.privilege.PrincipalDesc;
import org.apache.hadoop.hive.ql.ddl.privilege.PrivilegeDesc;
import org.apache.hadoop.hive.ql.ddl.privilege.PrivilegeObjectDesc;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.security.authorization.AuthorizationUtils;
import org.apache.hadoop.hive.ql.security.authorization.Privilege;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAuthorizationTranslator;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HivePrincipal;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HivePrivilege;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HivePrivilegeObject;
import org.apache.hadoop.hive.ql.session.SessionState;

public class DefaultHiveAuthorizationTranslator
implements HiveAuthorizationTranslator {
    @Override
    public HivePrincipal getHivePrincipal(PrincipalDesc principal) throws HiveException {
        if (principal == null) {
            return null;
        }
        return AuthorizationUtils.getHivePrincipal(principal.getName(), principal.getType());
    }

    @Override
    public HivePrivilege getHivePrivilege(PrivilegeDesc privilege) {
        Privilege priv = privilege.getPrivilege();
        return new HivePrivilege(priv.toString(), privilege.getColumns(), priv.getScopeList());
    }

    @Override
    public HivePrivilegeObject getHivePrivilegeObject(PrivilegeObjectDesc privSubjectDesc) throws HiveException {
        String[] dbTable;
        HivePrivilegeObject.HivePrivilegeObjectType objectType = null;
        ArrayList<String> partSpec = null;
        List<String> columns = null;
        if (privSubjectDesc == null) {
            dbTable = new String[]{null, null};
        } else {
            dbTable = privSubjectDesc.getTable() ? Utilities.getDbTableName(privSubjectDesc.getObject()) : new String[]{privSubjectDesc.getObject(), null};
            if (privSubjectDesc.getPartSpec() != null) {
                partSpec = new ArrayList<String>(privSubjectDesc.getPartSpec().values());
            }
            columns = privSubjectDesc.getColumns();
            objectType = AuthorizationUtils.getPrivObjectType(privSubjectDesc);
        }
        return new HivePrivilegeObject(objectType, SessionState.get().getCurrentCatalog(), dbTable[0], dbTable[1], partSpec, columns);
    }
}

