/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions.gen;

import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.StringExpr;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.metadata.HiveException;

public abstract class FilterStringGroupScalarLessEqualStringGroupColumnBase
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    protected final byte[] value;

    public FilterStringGroupScalarLessEqualStringGroupColumnBase(byte[] value, int colNum) {
        super(colNum, -1);
        this.value = value;
    }

    public FilterStringGroupScalarLessEqualStringGroupColumnBase() {
        this.value = null;
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) throws HiveException {
        int n = batch.size;
        if (n == 0) {
            return;
        }
        if (this.childExpressions != null) {
            super.evaluateChildren(batch);
        }
        BytesColumnVector inputColVector = (BytesColumnVector)batch.cols[this.inputColumnNum[0]];
        int[] sel = batch.selected;
        boolean[] inputIsNull = inputColVector.isNull;
        byte[][] vector = inputColVector.vector;
        int[] length = inputColVector.length;
        int[] start = inputColVector.start;
        if (inputColVector.noNulls) {
            if (inputColVector.isRepeating) {
                if (StringExpr.compare((byte[])this.value, (int)0, (int)this.value.length, (byte[])vector[0], (int)start[0], (int)length[0]) > 0) {
                    batch.size = 0;
                }
            } else if (batch.selectedInUse) {
                int newSize = 0;
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    if (StringExpr.compare((byte[])this.value, (int)0, (int)this.value.length, (byte[])vector[i], (int)start[i], (int)length[i]) > 0) continue;
                    sel[newSize++] = i;
                }
                batch.size = newSize;
            } else {
                int newSize = 0;
                for (int i = 0; i != n; ++i) {
                    if (StringExpr.compare((byte[])this.value, (int)0, (int)this.value.length, (byte[])vector[i], (int)start[i], (int)length[i]) > 0) continue;
                    sel[newSize++] = i;
                }
                if (newSize < n) {
                    batch.size = newSize;
                    batch.selectedInUse = true;
                }
            }
        } else if (inputColVector.isRepeating) {
            if (!inputIsNull[0]) {
                if (StringExpr.compare((byte[])this.value, (int)0, (int)this.value.length, (byte[])vector[0], (int)start[0], (int)length[0]) > 0) {
                    batch.size = 0;
                }
            } else {
                batch.size = 0;
            }
        } else if (batch.selectedInUse) {
            int newSize = 0;
            for (int j = 0; j != n; ++j) {
                int i = sel[j];
                if (inputIsNull[i] || StringExpr.compare((byte[])this.value, (int)0, (int)this.value.length, (byte[])vector[i], (int)start[i], (int)length[i]) > 0) continue;
                sel[newSize++] = i;
            }
            batch.size = newSize;
        } else {
            int newSize = 0;
            for (int i = 0; i != n; ++i) {
                if (inputIsNull[i] || StringExpr.compare((byte[])this.value, (int)0, (int)this.value.length, (byte[])vector[i], (int)start[i], (int)length[i]) > 0) continue;
                sel[newSize++] = i;
            }
            if (newSize < n) {
                batch.size = newSize;
                batch.selectedInUse = true;
            }
        }
    }

    @Override
    public String vectorExpressionParameters() {
        return "val " + FilterStringGroupScalarLessEqualStringGroupColumnBase.displayUtf8Bytes(this.value) + ", " + this.getColumnParamString(1, this.inputColumnNum[0]);
    }
}

