/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.view.materialized.show;

import java.io.DataOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.ddl.DDLOperation;
import org.apache.hadoop.hive.ql.ddl.DDLOperationContext;
import org.apache.hadoop.hive.ql.ddl.ShowUtils;
import org.apache.hadoop.hive.ql.ddl.view.materialized.show.ShowMaterializedViewsDesc;
import org.apache.hadoop.hive.ql.ddl.view.materialized.show.ShowMaterializedViewsFormatter;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.udf.UDFLike;

public class ShowMaterializedViewsOperation
extends DDLOperation<ShowMaterializedViewsDesc> {
    public ShowMaterializedViewsOperation(DDLOperationContext context, ShowMaterializedViewsDesc desc) {
        super(context, desc);
    }

    @Override
    public int execute() throws HiveException {
        if (!this.context.getDb().databaseExists(((ShowMaterializedViewsDesc)this.desc).getDbName())) {
            throw new HiveException(ErrorMsg.DATABASE_NOT_EXISTS, new String[]{((ShowMaterializedViewsDesc)this.desc).getDbName()});
        }
        List<Table> viewObjects = new ArrayList<Table>(this.context.getDb().getMaterializedViewObjectsByPattern(((ShowMaterializedViewsDesc)this.desc).getDbName(), null));
        if (((ShowMaterializedViewsDesc)this.desc).getPattern() != null) {
            Pattern pattern = Pattern.compile(UDFLike.likePatternToRegExp(((ShowMaterializedViewsDesc)this.desc).getPattern()), 2);
            viewObjects = viewObjects.stream().filter(object -> pattern.matcher(object.getTableName()).matches()).collect(Collectors.toList());
        }
        Collections.sort(viewObjects, Comparator.comparing(Table::getTableName));
        LOG.debug("Found {} materialized view(s) matching the SHOW MATERIALIZED VIEWS statement.", (Object)viewObjects.size());
        try (DataOutputStream os = ShowUtils.getOutputStream(new Path(((ShowMaterializedViewsDesc)this.desc).getResFile()), this.context);){
            Collections.sort(viewObjects, Comparator.comparing(Table::getTableName));
            ShowMaterializedViewsFormatter formatter = ShowMaterializedViewsFormatter.getFormatter(this.context.getConf());
            formatter.showMaterializedViews(os, viewObjects);
        }
        catch (Exception e) {
            throw new HiveException((Throwable)e, ErrorMsg.GENERIC_ERROR, new String[]{"in database" + ((ShowMaterializedViewsDesc)this.desc).getDbName()});
        }
        return 0;
    }
}

