/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.beeline.hs2connection;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hive.beeline.hs2connection.BeelineSiteParseException;
import org.apache.hive.beeline.hs2connection.HS2ConnectionFileParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeelineSiteParser
implements HS2ConnectionFileParser {
    public static final String BEELINE_CONNECTION_NAMED_JDBC_URL_PREFIX = "beeline.hs2.jdbc.url.";
    public static final String DEFAULT_NAMED_JDBC_URL_PROPERTY_KEY = "default";
    public static final String DEFAULT_BEELINE_SITE_FILE_NAME = "beeline-site.xml";
    public static final String DEFAULT_BEELINE_SITE_LOCATION = System.getProperty("user.home") + File.separator + (System.getProperty("os.name").toLowerCase().indexOf("windows") != -1 ? "" : ".") + "beeline" + File.separator;
    public static final String ETC_HIVE_CONF_LOCATION = File.separator + "etc" + File.separator + "hive" + File.separator + "conf";
    private final List<String> locations = new ArrayList<String>();
    private static final Logger log = LoggerFactory.getLogger(BeelineSiteParser.class);

    public BeelineSiteParser() {
        this.locations.add(DEFAULT_BEELINE_SITE_LOCATION + DEFAULT_BEELINE_SITE_FILE_NAME);
        if (System.getenv("HIVE_CONF_DIR") != null) {
            this.locations.add(System.getenv("HIVE_CONF_DIR") + File.separator + DEFAULT_BEELINE_SITE_FILE_NAME);
        }
        this.locations.add(ETC_HIVE_CONF_LOCATION + File.separator + DEFAULT_BEELINE_SITE_FILE_NAME);
    }

    @VisibleForTesting
    BeelineSiteParser(List<String> testLocations) {
        if (testLocations == null) {
            return;
        }
        this.locations.addAll(testLocations);
    }

    @Override
    public Properties getConnectionProperties() throws BeelineSiteParseException {
        Properties props = new Properties();
        String fileLocation = this.getFileLocation();
        if (fileLocation == null) {
            log.debug("Could not find Beeline configuration file: {}", (Object)DEFAULT_BEELINE_SITE_FILE_NAME);
            return props;
        }
        log.info("Beeline configuration file at: {}", (Object)fileLocation);
        Configuration conf = new Configuration(false);
        conf.addResource(new Path(new File(fileLocation).toURI()));
        try {
            for (Map.Entry kv : conf) {
                String key = (String)kv.getKey();
                if (!key.startsWith(BEELINE_CONNECTION_NAMED_JDBC_URL_PREFIX)) continue;
                props.setProperty(key.substring(BEELINE_CONNECTION_NAMED_JDBC_URL_PREFIX.length()), conf.get(key));
            }
        }
        catch (Exception e) {
            throw new BeelineSiteParseException(e.getMessage(), e);
        }
        return props;
    }

    public Properties getConnectionProperties(String propertyValue) throws BeelineSiteParseException {
        Properties props = new Properties();
        String fileLocation = this.getFileLocation();
        if (fileLocation == null) {
            log.debug("Could not find Beeline configuration file: {}", (Object)DEFAULT_BEELINE_SITE_FILE_NAME);
            return props;
        }
        log.info("Beeline configuration file at: {}", (Object)fileLocation);
        Configuration conf = new Configuration(false);
        conf.addResource(new Path(new File(fileLocation).toURI()));
        try {
            for (Map.Entry kv : conf) {
                String key = (String)kv.getKey();
                if (!key.startsWith(BEELINE_CONNECTION_NAMED_JDBC_URL_PREFIX) || !propertyValue.equalsIgnoreCase((String)kv.getValue())) continue;
                props.setProperty(key.substring(BEELINE_CONNECTION_NAMED_JDBC_URL_PREFIX.length()), conf.get(key));
            }
        }
        catch (Exception e) {
            throw new BeelineSiteParseException(e.getMessage(), e);
        }
        return props;
    }

    @Override
    public boolean configExists() {
        return this.getFileLocation() != null;
    }

    String getFileLocation() {
        for (String location : this.locations) {
            if (!new File(location).exists()) continue;
            return location;
        }
        return null;
    }
}

