/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.pig;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.type.Date;
import org.apache.hadoop.hive.common.type.HiveChar;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.common.type.HiveVarchar;
import org.apache.hadoop.hive.common.type.Timestamp;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hive.hcatalog.common.HCatConstants;
import org.apache.hive.hcatalog.common.HCatException;
import org.apache.hive.hcatalog.common.HCatUtil;
import org.apache.hive.hcatalog.data.HCatRecord;
import org.apache.hive.hcatalog.data.Pair;
import org.apache.hive.hcatalog.data.schema.HCatFieldSchema;
import org.apache.hive.hcatalog.data.schema.HCatSchema;
import org.apache.pig.LoadPushDown;
import org.apache.pig.PigException;
import org.apache.pig.ResourceSchema;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.DefaultDataBag;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.logicalLayer.schema.Schema;
import org.apache.pig.impl.util.UDFContext;
import org.apache.pig.impl.util.Utils;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PigHCatUtil {
    private static final Logger LOG = LoggerFactory.getLogger(PigHCatUtil.class);
    static final int PIG_EXCEPTION_CODE = 1115;
    private static final String DEFAULT_DB = "default";
    private final Map<Pair<String, String>, Table> hcatTableCache = new HashMap<Pair<String, String>, Table>();
    private static final TupleFactory tupFac = TupleFactory.getInstance();
    private static boolean pigHasBooleanSupport = false;

    PigHCatUtil() {
    }

    public static boolean pigHasBooleanSupport() {
        return pigHasBooleanSupport;
    }

    public static Pair<String, String> getDBTableNames(String location) throws IOException {
        try {
            return HCatUtil.getDbAndTableName((String)location);
        }
        catch (IOException e) {
            String locationErrMsg = "The input location in load statement should be of the form <databasename>.<table name> or <table name>. Got " + location;
            throw new PigException(locationErrMsg, 1115);
        }
    }

    public static String getHCatServerUri(Job job) {
        return job.getConfiguration().get(HiveConf.ConfVars.METASTORE_URIS.varname);
    }

    public static String getHCatServerPrincipal(Job job) {
        return job.getConfiguration().get(HCatConstants.HCAT_METASTORE_PRINCIPAL);
    }

    private static IMetaStoreClient getHiveMetaClient(String serverUri, String serverKerberosPrincipal, Class<?> clazz, Job job) throws Exception {
        HiveConf hiveConf = new HiveConf(job.getConfiguration(), clazz);
        if (serverUri != null) {
            hiveConf.setVar(HiveConf.ConfVars.METASTORE_URIS, serverUri.trim());
        }
        if (serverKerberosPrincipal != null) {
            hiveConf.setBoolVar(HiveConf.ConfVars.METASTORE_USE_THRIFT_SASL, true);
            hiveConf.setVar(HiveConf.ConfVars.METASTORE_KERBEROS_PRINCIPAL, serverKerberosPrincipal);
        }
        try {
            return HCatUtil.getHiveMetastoreClient((HiveConf)hiveConf);
        }
        catch (Exception e) {
            throw new Exception("Could not instantiate a HiveMetaStoreClient connecting to server uri:[" + serverUri + "]", e);
        }
    }

    HCatSchema getHCatSchema(List<LoadPushDown.RequiredField> fields, String signature, Class<?> classForUDFCLookup) throws IOException {
        if (fields == null) {
            return null;
        }
        Properties props = UDFContext.getUDFContext().getUDFProperties(classForUDFCLookup, new String[]{signature});
        HCatSchema hcatTableSchema = (HCatSchema)props.get("hcat.table.schema");
        ArrayList<HCatFieldSchema> fcols = new ArrayList<HCatFieldSchema>();
        for (LoadPushDown.RequiredField rf : fields) {
            fcols.add((HCatFieldSchema)hcatTableSchema.getFields().get(rf.getIndex()));
        }
        return new HCatSchema(fcols);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Table getTable(String location, String hcatServerUri, String hcatServerPrincipal, Job job) throws IOException {
        Pair loc_server = new Pair((Object)location, (Object)hcatServerUri);
        Table hcatTable = this.hcatTableCache.get(loc_server);
        if (hcatTable != null) {
            return hcatTable;
        }
        Pair<String, String> dbTablePair = PigHCatUtil.getDBTableNames(location);
        String dbName = (String)dbTablePair.first;
        String tableName = (String)dbTablePair.second;
        Table table = null;
        IMetaStoreClient client = null;
        try {
            client = PigHCatUtil.getHiveMetaClient(hcatServerUri, hcatServerPrincipal, PigHCatUtil.class, job);
            table = HCatUtil.getTable((IMetaStoreClient)client, (String)dbName, (String)tableName);
        }
        catch (NoSuchObjectException nsoe) {
            try {
                throw new PigException("Table not found : " + nsoe.getMessage(), 1115);
                catch (Exception e) {
                    throw new IOException(e);
                }
            }
            catch (Throwable throwable) {
                HCatUtil.closeHiveClientQuietly(client);
                throw throwable;
            }
        }
        HCatUtil.closeHiveClientQuietly((IMetaStoreClient)client);
        this.hcatTableCache.put((Pair<String, String>)loc_server, table);
        return table;
    }

    public static ResourceSchema getResourceSchema(HCatSchema hcatSchema) throws IOException {
        ArrayList<ResourceSchema.ResourceFieldSchema> rfSchemaList = new ArrayList<ResourceSchema.ResourceFieldSchema>();
        for (HCatFieldSchema hfs : hcatSchema.getFields()) {
            ResourceSchema.ResourceFieldSchema rfSchema = PigHCatUtil.getResourceSchemaFromFieldSchema(hfs);
            rfSchemaList.add(rfSchema);
        }
        ResourceSchema rSchema = new ResourceSchema();
        rSchema.setFields(rfSchemaList.toArray(new ResourceSchema.ResourceFieldSchema[rfSchemaList.size()]));
        return rSchema;
    }

    private static ResourceSchema.ResourceFieldSchema getResourceSchemaFromFieldSchema(HCatFieldSchema hfs) throws IOException {
        ResourceSchema.ResourceFieldSchema rfSchema = hfs.getType() == HCatFieldSchema.Type.STRUCT ? new ResourceSchema.ResourceFieldSchema().setName(hfs.getName()).setDescription(hfs.getComment()).setType(PigHCatUtil.getPigType(hfs)).setSchema(PigHCatUtil.getTupleSubSchema(hfs)) : (hfs.getType() == HCatFieldSchema.Type.ARRAY ? new ResourceSchema.ResourceFieldSchema().setName(hfs.getName()).setDescription(hfs.getComment()).setType(PigHCatUtil.getPigType(hfs)).setSchema(PigHCatUtil.getBagSubSchema(hfs)) : new ResourceSchema.ResourceFieldSchema().setName(hfs.getName()).setDescription(hfs.getComment()).setType(PigHCatUtil.getPigType(hfs)).setSchema(null));
        return rfSchema;
    }

    protected static ResourceSchema getBagSubSchema(HCatFieldSchema hfs) throws IOException {
        Properties props = UDFContext.getUDFContext().getClientSystemProps();
        String innerTupleName = "innertuple";
        if (props != null && props.containsKey("hcat.pig.inner.tuple.name")) {
            innerTupleName = props.getProperty("hcat.pig.inner.tuple.name").replaceAll("FIELDNAME", hfs.getName());
        }
        String innerFieldName = "innerfield";
        if (props != null && props.containsKey("hcat.pig.inner.field.name")) {
            innerFieldName = props.getProperty("hcat.pig.inner.field.name").replaceAll("FIELDNAME", hfs.getName());
        }
        ResourceSchema.ResourceFieldSchema[] bagSubFieldSchemas = new ResourceSchema.ResourceFieldSchema[]{new ResourceSchema.ResourceFieldSchema().setName(innerTupleName).setDescription("The tuple in the bag").setType((byte)110)};
        HCatFieldSchema arrayElementFieldSchema = hfs.getArrayElementSchema().get(0);
        if (arrayElementFieldSchema.getType() == HCatFieldSchema.Type.STRUCT) {
            bagSubFieldSchemas[0].setSchema(PigHCatUtil.getTupleSubSchema(arrayElementFieldSchema));
        } else if (arrayElementFieldSchema.getType() == HCatFieldSchema.Type.ARRAY) {
            ResourceSchema s = new ResourceSchema();
            List<ResourceSchema.ResourceFieldSchema> lrfs = Arrays.asList(PigHCatUtil.getResourceSchemaFromFieldSchema(arrayElementFieldSchema));
            s.setFields(lrfs.toArray(new ResourceSchema.ResourceFieldSchema[lrfs.size()]));
            bagSubFieldSchemas[0].setSchema(s);
        } else {
            ResourceSchema.ResourceFieldSchema[] innerTupleFieldSchemas = new ResourceSchema.ResourceFieldSchema[]{new ResourceSchema.ResourceFieldSchema().setName(innerFieldName).setDescription("The inner field in the tuple in the bag").setType(PigHCatUtil.getPigType(arrayElementFieldSchema)).setSchema(null)};
            bagSubFieldSchemas[0].setSchema(new ResourceSchema().setFields(innerTupleFieldSchemas));
        }
        return new ResourceSchema().setFields(bagSubFieldSchemas);
    }

    private static ResourceSchema getTupleSubSchema(HCatFieldSchema hfs) throws IOException {
        ResourceSchema s = new ResourceSchema();
        ArrayList<ResourceSchema.ResourceFieldSchema> lrfs = new ArrayList<ResourceSchema.ResourceFieldSchema>();
        for (HCatFieldSchema subField : hfs.getStructSubSchema().getFields()) {
            lrfs.add(PigHCatUtil.getResourceSchemaFromFieldSchema(subField));
        }
        s.setFields(lrfs.toArray(new ResourceSchema.ResourceFieldSchema[lrfs.size()]));
        return s;
    }

    public static byte getPigType(HCatFieldSchema hfs) throws IOException {
        return PigHCatUtil.getPigType(hfs.getType());
    }

    public static byte getPigType(HCatFieldSchema.Type type) throws IOException {
        if (type == HCatFieldSchema.Type.STRING || type == HCatFieldSchema.Type.CHAR || type == HCatFieldSchema.Type.VARCHAR) {
            return 55;
        }
        if (type == HCatFieldSchema.Type.INT || type == HCatFieldSchema.Type.SMALLINT || type == HCatFieldSchema.Type.TINYINT) {
            return 10;
        }
        if (type == HCatFieldSchema.Type.ARRAY) {
            return 120;
        }
        if (type == HCatFieldSchema.Type.STRUCT) {
            return 110;
        }
        if (type == HCatFieldSchema.Type.MAP) {
            return 100;
        }
        if (type == HCatFieldSchema.Type.BIGINT) {
            return 15;
        }
        if (type == HCatFieldSchema.Type.FLOAT) {
            return 20;
        }
        if (type == HCatFieldSchema.Type.DOUBLE) {
            return 25;
        }
        if (type == HCatFieldSchema.Type.BINARY) {
            return 50;
        }
        if (type == HCatFieldSchema.Type.BOOLEAN && pigHasBooleanSupport) {
            return 5;
        }
        if (type == HCatFieldSchema.Type.DECIMAL) {
            return 70;
        }
        if (type == HCatFieldSchema.Type.DATE || type == HCatFieldSchema.Type.TIMESTAMP) {
            return 30;
        }
        throw new PigException("HCatalog column type '" + type.toString() + "' is not supported in Pig as a column type", 1115);
    }

    public static Tuple transformToTuple(HCatRecord hr, HCatSchema hs) throws Exception {
        if (hr == null) {
            return null;
        }
        return PigHCatUtil.transformToTuple(hr.getAll(), hs);
    }

    public static Object extractPigObject(Object o, HCatFieldSchema hfs) throws Exception {
        if (o == null) {
            return null;
        }
        HCatFieldSchema.Type itemType = hfs.getType();
        return switch (itemType) {
            case HCatFieldSchema.Type.BINARY -> new DataByteArray((byte[])o);
            case HCatFieldSchema.Type.STRUCT -> PigHCatUtil.transformToTuple((List)o, hfs);
            case HCatFieldSchema.Type.ARRAY -> PigHCatUtil.transformToBag((List)o, hfs);
            case HCatFieldSchema.Type.MAP -> PigHCatUtil.transformToPigMap((Map)o, hfs);
            case HCatFieldSchema.Type.DECIMAL -> ((HiveDecimal)o).bigDecimalValue();
            case HCatFieldSchema.Type.CHAR -> ((HiveChar)o).getValue();
            case HCatFieldSchema.Type.VARCHAR -> ((HiveVarchar)o).getValue();
            case HCatFieldSchema.Type.DATE -> {
                Date d = (Date)o;
                yield new DateTime(d.getYear(), d.getMonth(), d.getDay(), 0, 0, DateTimeZone.UTC);
            }
            case HCatFieldSchema.Type.TIMESTAMP -> new DateTime(((Timestamp)o).toEpochMilli(), DateTimeZone.UTC);
            default -> o;
        };
    }

    private static Tuple transformToTuple(List<?> objList, HCatFieldSchema hfs) throws Exception {
        try {
            return PigHCatUtil.transformToTuple(objList, hfs.getStructSubSchema());
        }
        catch (Exception e) {
            if (hfs.getType() != HCatFieldSchema.Type.STRUCT) {
                throw new Exception("Expected Struct type, got " + String.valueOf(hfs.getType()), e);
            }
            throw e;
        }
    }

    private static Tuple transformToTuple(List<?> objList, HCatSchema hs) throws Exception {
        if (objList == null) {
            return null;
        }
        Tuple t = tupFac.newTuple(objList.size());
        List subFields = hs.getFields();
        for (int i = 0; i < subFields.size(); ++i) {
            t.set(i, PigHCatUtil.extractPigObject(objList.get(i), (HCatFieldSchema)subFields.get(i)));
        }
        return t;
    }

    private static Map<String, Object> transformToPigMap(Map<?, ?> map, HCatFieldSchema hfs) throws Exception {
        if (map == null) {
            return null;
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            if (entry.getKey() == null) continue;
            result.put(entry.getKey().toString(), PigHCatUtil.extractPigObject(entry.getValue(), hfs.getMapValueSchema().get(0)));
        }
        return result;
    }

    private static DataBag transformToBag(List<?> list, HCatFieldSchema hfs) throws Exception {
        if (list == null) {
            return null;
        }
        HCatFieldSchema elementSubFieldSchema = (HCatFieldSchema)hfs.getArrayElementSchema().getFields().get(0);
        DefaultDataBag db = new DefaultDataBag();
        for (Object o : list) {
            Tuple tuple = elementSubFieldSchema.getType() == HCatFieldSchema.Type.STRUCT ? PigHCatUtil.transformToTuple((List)o, elementSubFieldSchema) : tupFac.newTuple(PigHCatUtil.extractPigObject(o, elementSubFieldSchema));
            db.add(tuple);
        }
        return db;
    }

    private static void validateHCatSchemaFollowsPigRules(HCatSchema tblSchema) throws PigException {
        for (HCatFieldSchema hcatField : tblSchema.getFields()) {
            PigHCatUtil.validateHcatFieldFollowsPigRules(hcatField);
        }
    }

    private static void validateHcatFieldFollowsPigRules(HCatFieldSchema hcatField) throws PigException {
        try {
            HCatFieldSchema.Type hType = hcatField.getType();
            switch (hType) {
                case BOOLEAN: {
                    if (pigHasBooleanSupport) break;
                    throw new PigException("Incompatible type found in HCat table schema: " + String.valueOf(hcatField), 1115);
                }
                case ARRAY: {
                    PigHCatUtil.validateHCatSchemaFollowsPigRules(hcatField.getArrayElementSchema());
                    break;
                }
                case STRUCT: {
                    PigHCatUtil.validateHCatSchemaFollowsPigRules(hcatField.getStructSubSchema());
                    break;
                }
                case MAP: {
                    if (hcatField.getMapKeyType() != HCatFieldSchema.Type.STRING) {
                        LOG.info("Converting non-String key of map " + hcatField.getName() + " from " + String.valueOf(hcatField.getMapKeyType()) + " to String.");
                    }
                    PigHCatUtil.validateHCatSchemaFollowsPigRules(hcatField.getMapValueSchema());
                }
            }
        }
        catch (HCatException e) {
            throw new PigException("Incompatible type found in hcat table schema: " + String.valueOf(hcatField), 1115, (Throwable)e);
        }
    }

    public static void validateHCatTableSchemaFollowsPigRules(HCatSchema hcatTableSchema) throws IOException {
        PigHCatUtil.validateHCatSchemaFollowsPigRules(hcatTableSchema);
    }

    public static void getConfigFromUDFProperties(Properties p, Configuration config, String propName) {
        if (p.getProperty(propName) != null) {
            config.set(propName, p.getProperty(propName));
        }
    }

    public static void saveConfigIntoUDFProperties(Properties p, Configuration config, String propName) {
        if (config.get(propName) != null) {
            p.setProperty(propName, config.get(propName));
        }
    }

    static {
        try {
            Schema schema = Utils.getSchemaFromString((String)"myBooleanField: boolean");
            pigHasBooleanSupport = schema.getField((String)"myBooleanField").type == 5;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (!pigHasBooleanSupport) {
            LOG.info("This version of Pig does not support boolean fields. To enable boolean-to-integer conversion, set the hcat.data.convert.boolean.to.integer=true configuration parameter.");
        }
    }
}

