/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.TableName;
import org.apache.hadoop.hive.common.ValidTxnList;
import org.apache.hadoop.hive.common.ValidWriteIdList;
import org.apache.hadoop.hive.common.classification.RetrySemantics;
import org.apache.hadoop.hive.metastore.PartitionDropOptions;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.annotation.NoReconnect;
import org.apache.hadoop.hive.metastore.api.AbortCompactResponse;
import org.apache.hadoop.hive.metastore.api.AbortCompactionRequest;
import org.apache.hadoop.hive.metastore.api.AbortTxnRequest;
import org.apache.hadoop.hive.metastore.api.AbortTxnsRequest;
import org.apache.hadoop.hive.metastore.api.AddPackageRequest;
import org.apache.hadoop.hive.metastore.api.AggrStats;
import org.apache.hadoop.hive.metastore.api.AllTableConstraintsRequest;
import org.apache.hadoop.hive.metastore.api.AlreadyExistsException;
import org.apache.hadoop.hive.metastore.api.Catalog;
import org.apache.hadoop.hive.metastore.api.CheckConstraintsRequest;
import org.apache.hadoop.hive.metastore.api.CmRecycleRequest;
import org.apache.hadoop.hive.metastore.api.CmRecycleResponse;
import org.apache.hadoop.hive.metastore.api.ColumnStatistics;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.CommitTxnRequest;
import org.apache.hadoop.hive.metastore.api.CompactionInfoStruct;
import org.apache.hadoop.hive.metastore.api.CompactionMetricsDataRequest;
import org.apache.hadoop.hive.metastore.api.CompactionMetricsDataStruct;
import org.apache.hadoop.hive.metastore.api.CompactionRequest;
import org.apache.hadoop.hive.metastore.api.CompactionResponse;
import org.apache.hadoop.hive.metastore.api.ConfigValSecurityException;
import org.apache.hadoop.hive.metastore.api.CreateTableRequest;
import org.apache.hadoop.hive.metastore.api.CreationMetadata;
import org.apache.hadoop.hive.metastore.api.CurrentNotificationEventId;
import org.apache.hadoop.hive.metastore.api.DataConnector;
import org.apache.hadoop.hive.metastore.api.DataOperationType;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.DefaultConstraintsRequest;
import org.apache.hadoop.hive.metastore.api.DeleteColumnStatisticsRequest;
import org.apache.hadoop.hive.metastore.api.DropDatabaseRequest;
import org.apache.hadoop.hive.metastore.api.DropPackageRequest;
import org.apache.hadoop.hive.metastore.api.EnvironmentContext;
import org.apache.hadoop.hive.metastore.api.ExtendedTableInfo;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.FindNextCompactRequest;
import org.apache.hadoop.hive.metastore.api.FindSchemasByColsResp;
import org.apache.hadoop.hive.metastore.api.FindSchemasByColsRqst;
import org.apache.hadoop.hive.metastore.api.FireEventRequest;
import org.apache.hadoop.hive.metastore.api.FireEventResponse;
import org.apache.hadoop.hive.metastore.api.ForeignKeysRequest;
import org.apache.hadoop.hive.metastore.api.Function;
import org.apache.hadoop.hive.metastore.api.GetAllFunctionsResponse;
import org.apache.hadoop.hive.metastore.api.GetAllWriteEventInfoRequest;
import org.apache.hadoop.hive.metastore.api.GetDatabaseObjectsRequest;
import org.apache.hadoop.hive.metastore.api.GetDatabaseObjectsResponse;
import org.apache.hadoop.hive.metastore.api.GetFieldsRequest;
import org.apache.hadoop.hive.metastore.api.GetFieldsResponse;
import org.apache.hadoop.hive.metastore.api.GetFunctionsRequest;
import org.apache.hadoop.hive.metastore.api.GetFunctionsResponse;
import org.apache.hadoop.hive.metastore.api.GetLatestCommittedCompactionInfoRequest;
import org.apache.hadoop.hive.metastore.api.GetLatestCommittedCompactionInfoResponse;
import org.apache.hadoop.hive.metastore.api.GetOpenTxnsInfoResponse;
import org.apache.hadoop.hive.metastore.api.GetOpenTxnsResponse;
import org.apache.hadoop.hive.metastore.api.GetPackageRequest;
import org.apache.hadoop.hive.metastore.api.GetPartitionNamesPsRequest;
import org.apache.hadoop.hive.metastore.api.GetPartitionNamesPsResponse;
import org.apache.hadoop.hive.metastore.api.GetPartitionRequest;
import org.apache.hadoop.hive.metastore.api.GetPartitionResponse;
import org.apache.hadoop.hive.metastore.api.GetPartitionsByNamesRequest;
import org.apache.hadoop.hive.metastore.api.GetPartitionsByNamesResult;
import org.apache.hadoop.hive.metastore.api.GetPartitionsPsWithAuthRequest;
import org.apache.hadoop.hive.metastore.api.GetPartitionsPsWithAuthResponse;
import org.apache.hadoop.hive.metastore.api.GetPartitionsRequest;
import org.apache.hadoop.hive.metastore.api.GetPartitionsResponse;
import org.apache.hadoop.hive.metastore.api.GetPrincipalsInRoleRequest;
import org.apache.hadoop.hive.metastore.api.GetPrincipalsInRoleResponse;
import org.apache.hadoop.hive.metastore.api.GetProjectionsSpec;
import org.apache.hadoop.hive.metastore.api.GetReplicationMetricsRequest;
import org.apache.hadoop.hive.metastore.api.GetRoleGrantsForPrincipalRequest;
import org.apache.hadoop.hive.metastore.api.GetRoleGrantsForPrincipalResponse;
import org.apache.hadoop.hive.metastore.api.GetSchemaRequest;
import org.apache.hadoop.hive.metastore.api.GetSchemaResponse;
import org.apache.hadoop.hive.metastore.api.GetTableRequest;
import org.apache.hadoop.hive.metastore.api.HeartbeatTxnRangeResponse;
import org.apache.hadoop.hive.metastore.api.HiveObjectPrivilege;
import org.apache.hadoop.hive.metastore.api.HiveObjectRef;
import org.apache.hadoop.hive.metastore.api.ISchema;
import org.apache.hadoop.hive.metastore.api.InvalidInputException;
import org.apache.hadoop.hive.metastore.api.InvalidObjectException;
import org.apache.hadoop.hive.metastore.api.InvalidOperationException;
import org.apache.hadoop.hive.metastore.api.InvalidPartitionException;
import org.apache.hadoop.hive.metastore.api.ListPackageRequest;
import org.apache.hadoop.hive.metastore.api.ListStoredProcedureRequest;
import org.apache.hadoop.hive.metastore.api.LockRequest;
import org.apache.hadoop.hive.metastore.api.LockResponse;
import org.apache.hadoop.hive.metastore.api.Materialization;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.MetadataPpdResult;
import org.apache.hadoop.hive.metastore.api.NoSuchLockException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.NoSuchTxnException;
import org.apache.hadoop.hive.metastore.api.NotNullConstraintsRequest;
import org.apache.hadoop.hive.metastore.api.NotificationEvent;
import org.apache.hadoop.hive.metastore.api.NotificationEventRequest;
import org.apache.hadoop.hive.metastore.api.NotificationEventResponse;
import org.apache.hadoop.hive.metastore.api.NotificationEventsCountRequest;
import org.apache.hadoop.hive.metastore.api.NotificationEventsCountResponse;
import org.apache.hadoop.hive.metastore.api.OpenTxnsResponse;
import org.apache.hadoop.hive.metastore.api.OptionalCompactionInfoStruct;
import org.apache.hadoop.hive.metastore.api.Package;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.PartitionEventType;
import org.apache.hadoop.hive.metastore.api.PartitionSpec;
import org.apache.hadoop.hive.metastore.api.PartitionValuesRequest;
import org.apache.hadoop.hive.metastore.api.PartitionValuesResponse;
import org.apache.hadoop.hive.metastore.api.PartitionsByExprRequest;
import org.apache.hadoop.hive.metastore.api.PartitionsRequest;
import org.apache.hadoop.hive.metastore.api.PartitionsResponse;
import org.apache.hadoop.hive.metastore.api.PrimaryKeysRequest;
import org.apache.hadoop.hive.metastore.api.PrincipalPrivilegeSet;
import org.apache.hadoop.hive.metastore.api.PrincipalType;
import org.apache.hadoop.hive.metastore.api.PrivilegeBag;
import org.apache.hadoop.hive.metastore.api.ReplayedTxnsForPolicyResult;
import org.apache.hadoop.hive.metastore.api.ReplicationMetricList;
import org.apache.hadoop.hive.metastore.api.RequestPartsSpec;
import org.apache.hadoop.hive.metastore.api.Role;
import org.apache.hadoop.hive.metastore.api.RuntimeStat;
import org.apache.hadoop.hive.metastore.api.SQLAllTableConstraints;
import org.apache.hadoop.hive.metastore.api.SQLCheckConstraint;
import org.apache.hadoop.hive.metastore.api.SQLDefaultConstraint;
import org.apache.hadoop.hive.metastore.api.SQLForeignKey;
import org.apache.hadoop.hive.metastore.api.SQLNotNullConstraint;
import org.apache.hadoop.hive.metastore.api.SQLPrimaryKey;
import org.apache.hadoop.hive.metastore.api.SQLUniqueConstraint;
import org.apache.hadoop.hive.metastore.api.ScheduledQuery;
import org.apache.hadoop.hive.metastore.api.ScheduledQueryKey;
import org.apache.hadoop.hive.metastore.api.ScheduledQueryMaintenanceRequest;
import org.apache.hadoop.hive.metastore.api.ScheduledQueryPollRequest;
import org.apache.hadoop.hive.metastore.api.ScheduledQueryPollResponse;
import org.apache.hadoop.hive.metastore.api.ScheduledQueryProgressInfo;
import org.apache.hadoop.hive.metastore.api.SchemaVersion;
import org.apache.hadoop.hive.metastore.api.SchemaVersionState;
import org.apache.hadoop.hive.metastore.api.SerDeInfo;
import org.apache.hadoop.hive.metastore.api.SetPartitionsStatsRequest;
import org.apache.hadoop.hive.metastore.api.ShowCompactRequest;
import org.apache.hadoop.hive.metastore.api.ShowCompactResponse;
import org.apache.hadoop.hive.metastore.api.ShowLocksRequest;
import org.apache.hadoop.hive.metastore.api.ShowLocksResponse;
import org.apache.hadoop.hive.metastore.api.StoredProcedure;
import org.apache.hadoop.hive.metastore.api.StoredProcedureRequest;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.api.TableMeta;
import org.apache.hadoop.hive.metastore.api.TableValidWriteIds;
import org.apache.hadoop.hive.metastore.api.TxnAbortedException;
import org.apache.hadoop.hive.metastore.api.TxnOpenException;
import org.apache.hadoop.hive.metastore.api.TxnToWriteId;
import org.apache.hadoop.hive.metastore.api.TxnType;
import org.apache.hadoop.hive.metastore.api.UniqueConstraintsRequest;
import org.apache.hadoop.hive.metastore.api.UnknownDBException;
import org.apache.hadoop.hive.metastore.api.UnknownPartitionException;
import org.apache.hadoop.hive.metastore.api.UnknownTableException;
import org.apache.hadoop.hive.metastore.api.UpdateTransactionalStatsRequest;
import org.apache.hadoop.hive.metastore.api.WMFullResourcePlan;
import org.apache.hadoop.hive.metastore.api.WMMapping;
import org.apache.hadoop.hive.metastore.api.WMNullablePool;
import org.apache.hadoop.hive.metastore.api.WMNullableResourcePlan;
import org.apache.hadoop.hive.metastore.api.WMPool;
import org.apache.hadoop.hive.metastore.api.WMResourcePlan;
import org.apache.hadoop.hive.metastore.api.WMTrigger;
import org.apache.hadoop.hive.metastore.api.WMValidateResourcePlanResponse;
import org.apache.hadoop.hive.metastore.api.WriteEventInfo;
import org.apache.hadoop.hive.metastore.api.WriteNotificationLogBatchRequest;
import org.apache.hadoop.hive.metastore.api.WriteNotificationLogRequest;
import org.apache.hadoop.hive.metastore.partition.spec.PartitionSpecProxy;
import org.apache.thrift.TException;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public interface IMetaStoreClient
extends AutoCloseable {
    default public boolean isCompatibleWith(Configuration configuration) {
        return false;
    }

    default public void setHiveAddedJars(String addedJars) {
        throw new UnsupportedOperationException("MetaStore client does not support setting added jars");
    }

    default public boolean isLocalMetaStore() {
        throw new UnsupportedOperationException("MetaStore client does not support checking if metastore is local");
    }

    public void reconnect() throws MetaException;

    @Override
    @NoReconnect
    public void close();

    default public void setMetaConf(String key, String value) throws TException {
        throw new UnsupportedOperationException("MetaStore client does not support setting meta variables");
    }

    default public String getMetaConf(String key) throws TException {
        return "";
    }

    default public void createCatalog(Catalog catalog) throws AlreadyExistsException, InvalidObjectException, MetaException, TException {
        throw new UnsupportedOperationException("MetaStore client does not support creating catalogs");
    }

    default public void alterCatalog(String catalogName, Catalog newCatalog) throws NoSuchObjectException, InvalidObjectException, MetaException, TException {
        throw new UnsupportedOperationException("MetaStore client does not support altering catalogs");
    }

    default public Catalog getCatalog(String catName) throws NoSuchObjectException, MetaException, TException {
        throw new UnsupportedOperationException("MetaStore client does not support fetching catalogs");
    }

    default public List<String> getCatalogs() throws MetaException, TException {
        throw new UnsupportedOperationException("MetaStore client does not support fetching catalogs");
    }

    default public void dropCatalog(String catName) throws NoSuchObjectException, InvalidOperationException, MetaException, TException {
        throw new UnsupportedOperationException("MetaStore client does not support dropping catalogs");
    }

    default public void dropCatalog(String catName, boolean ifExists) throws TException {
        throw new UnsupportedOperationException("MetaStore client does not support dropping catalogs");
    }

    public List<String> getDatabases(String var1) throws MetaException, TException;

    public List<String> getDatabases(String var1, String var2) throws MetaException, TException;

    public List<String> getAllDatabases() throws MetaException, TException;

    public List<String> getAllDatabases(String var1) throws MetaException, TException;

    public List<String> getTables(String var1, String var2) throws MetaException, TException, UnknownDBException;

    public List<String> getTables(String var1, String var2, String var3) throws MetaException, TException, UnknownDBException;

    public List<String> getTables(String var1, String var2, TableType var3) throws MetaException, TException, UnknownDBException;

    default public List<String> getTables(String catName, String dbName, String tablePattern, TableType tableType) throws MetaException, TException, UnknownDBException {
        throw new UnsupportedOperationException("MetaStore client does not support fetching tables with table type");
    }

    default public List<Table> getAllMaterializedViewObjectsForRewriting() throws MetaException, TException, UnknownDBException {
        throw new UnsupportedOperationException("MetaStore client does not support fetching materialized views");
    }

    default public List<ExtendedTableInfo> getTablesExt(String catName, String dbName, String tablePattern, int requestedFields, int limit) throws MetaException, TException {
        throw new UnsupportedOperationException("MetaStore client does not support fetching extended table info");
    }

    default public List<String> getMaterializedViewsForRewriting(String dbName) throws MetaException, TException, UnknownDBException {
        throw new UnsupportedOperationException("MetaStore client does not support fetching materialized views");
    }

    default public List<String> getMaterializedViewsForRewriting(String catName, String dbName) throws MetaException, TException, UnknownDBException {
        throw new UnsupportedOperationException("MetaStore client does not support fetching materialized views");
    }

    default public List<TableMeta> getTableMeta(String dbPatterns, String tablePatterns, List<String> tableTypes) throws MetaException, TException, UnknownDBException {
        throw new UnsupportedOperationException("MetaStore client does not support fetching table metadata");
    }

    default public List<TableMeta> getTableMeta(String catName, String dbPatterns, String tablePatterns, List<String> tableTypes) throws MetaException, TException, UnknownDBException {
        throw new UnsupportedOperationException("MetaStore client does not support fetching table metadata");
    }

    public List<String> getAllTables(String var1) throws MetaException, TException, UnknownDBException;

    public List<String> getAllTables(String var1, String var2) throws MetaException, TException, UnknownDBException;

    default public List<String> listTableNamesByFilter(String dbName, String filter, short maxTables) throws TException, InvalidOperationException, UnknownDBException {
        throw new UnsupportedOperationException("MetaStore client does not support listing table names by filter");
    }

    default public List<String> listTableNamesByFilter(String catName, String dbName, String filter, int maxTables) throws TException, InvalidOperationException, UnknownDBException {
        throw new UnsupportedOperationException("MetaStore client does not support listing table names by filter");
    }

    public void dropTable(String var1, String var2, boolean var3, boolean var4) throws MetaException, TException, NoSuchObjectException;

    @Deprecated
    public void dropTable(String var1, String var2, boolean var3, boolean var4, boolean var5) throws MetaException, TException, NoSuchObjectException;

    public void dropTable(Table var1, boolean var2, boolean var3, boolean var4) throws TException;

    public void dropTable(String var1, String var2) throws MetaException, TException, NoSuchObjectException;

    public void dropTable(String var1, String var2, String var3, boolean var4, boolean var5, boolean var6) throws MetaException, NoSuchObjectException, TException;

    default public void dropTable(String catName, String dbName, String tableName, boolean deleteData, boolean ignoreUnknownTable) throws MetaException, NoSuchObjectException, TException {
        this.dropTable(catName, dbName, tableName, deleteData, ignoreUnknownTable, false);
    }

    default public void dropTable(String catName, String dbName, String tableName) throws MetaException, NoSuchObjectException, TException {
        this.dropTable(catName, dbName, tableName, true, true, false);
    }

    @Deprecated
    default public void truncateTable(String dbName, String tableName, List<String> partNames) throws MetaException, TException {
        throw new UnsupportedOperationException("MetaStore client does not support truncating tables");
    }

    default public void truncateTable(TableName table, List<String> partNames) throws TException {
        throw new UnsupportedOperationException("MetaStore client does not support truncating tables");
    }

    default public void truncateTable(String dbName, String tableName, List<String> partNames, String validWriteIds, long writeId) throws TException {
        throw new UnsupportedOperationException("MetaStore client does not support truncating tables with write ids");
    }

    default public void truncateTable(String dbName, String tableName, List<String> partNames, String validWriteIds, long writeId, boolean deleteData) throws TException {
        throw new UnsupportedOperationException("MetaStore client does not support truncating tables with write ids");
    }

    default public void truncateTable(String catName, String dbName, String tableName, String ref, List<String> partNames, String validWriteIds, long writeId, boolean deleteData, EnvironmentContext context) throws TException {
        throw new UnsupportedOperationException("MetaStore client does not support truncating tables with write ids");
    }

    default public CmRecycleResponse recycleDirToCmPath(CmRecycleRequest request) throws TException {
        throw new UnsupportedOperationException("MetaStore client does not support recycling directories to cmroot");
    }

    public boolean tableExists(String var1, String var2) throws MetaException, TException, UnknownDBException;

    public boolean tableExists(String var1, String var2, String var3) throws MetaException, TException, UnknownDBException;

    public Database getDatabase(String var1) throws NoSuchObjectException, MetaException, TException;

    public Database getDatabase(String var1, String var2) throws NoSuchObjectException, MetaException, TException;

    @Deprecated
    public Table getTable(String var1, String var2) throws MetaException, TException, NoSuchObjectException;

    @Deprecated
    public Table getTable(String var1, String var2, boolean var3, String var4) throws MetaException, TException, NoSuchObjectException;

    @Deprecated
    public Table getTable(String var1, String var2, String var3) throws MetaException, TException;

    @Deprecated
    public Table getTable(String var1, String var2, String var3, String var4, boolean var5, String var6) throws TException;

    public Table getTable(GetTableRequest var1) throws MetaException, TException, NoSuchObjectException;

    default public List<Table> getTableObjectsByName(String dbName, List<String> tableNames) throws MetaException, InvalidOperationException, UnknownDBException, TException {
        throw new UnsupportedOperationException("MetaStore client does not support fetching table objects by name");
    }

    default public List<Table> getTables(String catName, String dbName, List<String> tableNames, GetProjectionsSpec projectionsSpec) throws MetaException, InvalidOperationException, UnknownDBException, TException {
        throw new UnsupportedOperationException("MetaStore client does not support fetching tables");
    }

    default public List<Table> getTableObjectsByName(String catName, String dbName, List<String> tableNames) throws MetaException, InvalidOperationException, UnknownDBException, TException {
        throw new UnsupportedOperationException("MetaStore client does not support fetching table objects by name");
    }

    default public Materialization getMaterializationInvalidationInfo(CreationMetadata cm, String validTxnList) throws TException {
        throw new UnsupportedOperationException("MetaStore client does not support fetching materialization invalidation info");
    }

    default public void updateCreationMetadata(String dbName, String tableName, CreationMetadata cm) throws TException {
        throw new UnsupportedOperationException("MetaStore client does not support updating creation metadata");
    }

    default public void updateCreationMetadata(String catName, String dbName, String tableName, CreationMetadata cm) throws TException {
        throw new UnsupportedOperationException("MetaStore client does not support updating creation metadata");
    }

    default public Partition appendPartition(String dbName, String tableName, List<String> partVals) throws InvalidObjectException, AlreadyExistsException, MetaException, TException {
        throw new UnsupportedOperationException("MetaStore client does not support appending partitions");
    }

    default public Partition appendPartition(String catName, String dbName, String tableName, List<String> partVals) throws InvalidObjectException, AlreadyExistsException, MetaException, TException {
        throw new UnsupportedOperationException("MetaStore client does not support appending partitions");
    }

    default public Partition appendPartition(String dbName, String tableName, String name) throws InvalidObjectException, AlreadyExistsException, MetaException, TException {
        throw new UnsupportedOperationException("MetaStore client does not support appending partitions");
    }

    default public Partition appendPartition(String catName, String dbName, String tableName, String name) throws InvalidObjectException, AlreadyExistsException, MetaException, TException {
        throw new UnsupportedOperationException("MetaStore client does not support appending partitions");
    }

    default public Partition add_partition(Partition partition) throws InvalidObjectException, AlreadyExistsException, MetaException, TException {
        throw new UnsupportedOperationException("MetaStore client does not support adding partitions");
    }

    default public int add_partitions(List<Partition> partitions) throws InvalidObjectException, AlreadyExistsException, MetaException, TException {
        throw new UnsupportedOperationException("MetaStore client does not support adding partitions");
    }

    default public int add_partitions_pspec(PartitionSpecProxy partitionSpec) throws InvalidObjectException, AlreadyExistsException, MetaException, TException {
        throw new UnsupportedOperationException("MetaStore client does not support adding partitions using a spec proxy");
    }

    default public List<Partition> add_partitions(List<Partition> partitions, boolean ifNotExists, boolean needResults) throws TException {
        throw new UnsupportedOperationException("MetaStore client does not support adding partitions");
    }

    default public Partition getPartition(String dbName, String tblName, List<String> partVals) throws NoSuchObjectException, MetaException, TException {
        throw new UnsupportedOperationException("MetaStore client does not support getting partitions");
    }

    default public GetPartitionResponse getPartitionRequest(GetPartitionRequest req) throws NoSuchObjectException, MetaException, TException {
        throw new UnsupportedOperationException("MetaStore client does not support getting partitions");
    }

    default public Partition getPartition(String catName, String dbName, String tblName, List<String> partVals) throws NoSuchObjectException, MetaException, TException {
        throw new UnsupportedOperationException("MetaStore client does not support getting partitions");
    }

    default public Partition exchange_partition(Map<String, String> partitionSpecs, String sourceDb, String sourceTable, String destdb, String destTableName) throws MetaException, NoSuchObjectException, InvalidObjectException, TException {
        throw new UnsupportedOperationException("MetaStore client does not support exchanging partitions");
    }

    default public Partition exchange_partition(Map<String, String> partitionSpecs, String sourceCat, String sourceDb, String sourceTable, String destCat, String destdb, String destTableName) throws MetaException, NoSuchObjectException, InvalidObjectException, TException {
        throw new UnsupportedOperationException("MetaStore client does not support exchanging partitions");
    }

    default public List<Partition> exchange_partitions(Map<String, String> partitionSpecs, String sourceDb, String sourceTable, String destdb, String destTableName) throws MetaException, NoSuchObjectException, InvalidObjectException, TException {
        throw new UnsupportedOperationException("MetaStore client does not support exchanging partitions");
    }

    default public List<Partition> exchange_partitions(Map<String, String> partitionSpecs, String sourceCat, String sourceDb, String sourceTable, String destCat, String destdb, String destTableName) throws MetaException, NoSuchObjectException, InvalidObjectException, TException {
        throw new UnsupportedOperationException("MetaStore client does not support exchanging partitions");
    }

    default public Partition getPartition(String dbName, String tblName, String name) throws MetaException, UnknownTableException, NoSuchObjectException, TException {
        throw new UnsupportedOperationException("MetaStore client does not support getting partitions");
    }

    default public Partition getPartition(String catName, String dbName, String tblName, String name) throws MetaException, UnknownTableException, NoSuchObjectException, TException {
        throw new UnsupportedOperationException("MetaStore client does not support getting partitions");
    }

    default public Partition getPartitionWithAuthInfo(String dbName, String tableName, List<String> pvals, String userName, List<String> groupNames) throws MetaException, UnknownTableException, NoSuchObjectException, TException {
        throw new UnsupportedOperationException("MetaStore client does not support getting partitions with auth info");
    }

    default public Partition getPartitionWithAuthInfo(String catName, String dbName, String tableName, List<String> pvals, String userName, List<String> groupNames) throws MetaException, UnknownTableException, NoSuchObjectException, TException {
        throw new UnsupportedOperationException("MetaStore client does not support getting partitions with auth info");
    }

    default public List<Partition> listPartitions(String db_name, String tbl_name, short max_parts) throws NoSuchObjectException, MetaException, TException {
        throw new UnsupportedOperationException("MetaStore client does not support listing partitions");
    }

    default public List<Partition> listPartitions(String catName, String db_name, String tbl_name, int max_parts) throws NoSuchObjectException, MetaException, TException {
        throw new UnsupportedOperationException("MetaStore client does not support listing partitions");
    }

    default public PartitionSpecProxy listPartitionSpecs(String dbName, String tableName, int maxParts) throws TException {
        throw new UnsupportedOperationException("MetaStore client does not support listing partition specs");
    }

    default public PartitionSpecProxy listPartitionSpecs(String catName, String dbName, String tableName, int maxParts) throws TException {
        throw new UnsupportedOperationException("MetaStore client does not support listing partition specs");
    }

    default public List<Partition> listPartitions(String db_name, String tbl_name, List<String> part_vals, short max_parts) throws NoSuchObjectException, MetaException, TException {
        throw new UnsupportedOperationException("MetaStore client does not support listing partitions");
    }

    default public List<Partition> listPartitions(String catName, String db_name, String tbl_name, List<String> part_vals, int max_parts) throws NoSuchObjectException, MetaException, TException {
        throw new UnsupportedOperationException("MetaStore client does not support listing partitions");
    }

    default public List<String> listPartitionNames(String db_name, String tbl_name, short max_parts) throws NoSuchObjectException, MetaException, TException {
        throw new UnsupportedOperationException("MetaStore client does not support listing partition names");
    }

    default public GetPartitionNamesPsResponse listPartitionNamesRequest(GetPartitionNamesPsRequest req) throws NoSuchObjectException, MetaException, TException {
        throw new UnsupportedOperationException("MetaStore client does not support listing partition names");
    }

    default public List<String> listPartitionNames(String catName, String db_name, String tbl_name, int max_parts) throws NoSuchObjectException, MetaException, TException {
        throw new UnsupportedOperationException("MetaStore client does not support listing partition names");
    }

    default public List<String> listPartitionNames(String db_name, String tbl_name, List<String> part_vals, short max_parts) throws MetaException, TException, NoSuchObjectException {
        throw new UnsupportedOperationException("MetaStore client does not support listing partition names");
    }

    default public List<String> listPartitionNames(String catName, String db_name, String tbl_name, List<String> part_vals, int max_parts) throws MetaException, TException, NoSuchObjectException {
        throw new UnsupportedOperationException("MetaStore client does not support listing partition names");
    }

    default public List<String> listPartitionNames(PartitionsByExprRequest request) throws MetaException, TException, NoSuchObjectException {
        throw new UnsupportedOperationException("MetaStore client does not support listing partition names");
    }

    default public PartitionValuesResponse listPartitionValues(PartitionValuesRequest request) throws MetaException, TException, NoSuchObjectException {
        throw new UnsupportedOperationException("MetaStore client does not support listing partition values");
    }

    default public int getNumPartitionsByFilter(String dbName, String tableName, String filter) throws MetaException, NoSuchObjectException, TException {
        throw new UnsupportedOperationException("MetaStore client does not support getting number of partitions by filter");
    }

    default public int getNumPartitionsByFilter(String catName, String dbName, String tableName, String filter) throws MetaException, NoSuchObjectException, TException {
        throw new UnsupportedOperationException("MetaStore client does not support getting number of partitions by filter");
    }

    default public List<Partition> listPartitionsByFilter(String db_name, String tbl_name, String filter, short max_parts) throws MetaException, NoSuchObjectException, TException {
        throw new UnsupportedOperationException("MetaStore client does not support listing partitions by filter");
    }

    default public List<Partition> listPartitionsByFilter(String catName, String db_name, String tbl_name, String filter, int max_parts) throws MetaException, NoSuchObjectException, TException {
        throw new UnsupportedOperationException("MetaStore client does not support listing partitions by filter");
    }

    default public PartitionSpecProxy listPartitionSpecsByFilter(String db_name, String tbl_name, String filter, int max_parts) throws MetaException, NoSuchObjectException, TException {
        throw new UnsupportedOperationException("MetaStore client does not support listing partition specs by filter");
    }

    default public PartitionSpecProxy listPartitionSpecsByFilter(String catName, String db_name, String tbl_name, String filter, int max_parts) throws MetaException, NoSuchObjectException, TException {
        throw new UnsupportedOperationException("MetaStore client does not support listing partition specs by filter");
    }

    default public boolean listPartitionsSpecByExpr(PartitionsByExprRequest req, List<PartitionSpec> result) throws TException {
        throw new UnsupportedOperationException("MetaStore client does not support listing partition specs by expr");
    }

    default public boolean listPartitionsByExpr(String db_name, String tbl_name, byte[] expr, String default_partition_name, short max_parts, List<Partition> result) throws TException {
        throw new UnsupportedOperationException("MetaStore client does not support listing partitions by expr");
    }

    default public boolean listPartitionsByExpr(String catName, String db_name, String tbl_name, byte[] expr, String default_partition_name, int max_parts, List<Partition> result) throws TException {
        throw new UnsupportedOperationException("tMetaStore client does not support listing partitions by expr");
    }

    default public boolean listPartitionsByExpr(PartitionsByExprRequest req, List<Partition> result) throws TException {
        throw new UnsupportedOperationException("MetaStore client does not support listing partitions by expr");
    }

    default public List<Partition> listPartitionsWithAuthInfo(String dbName, String tableName, short maxParts, String userName, List<String> groupNames) throws MetaException, TException, NoSuchObjectException {
        throw new UnsupportedOperationException("MetaStore client does not support listing partitions with auth info");
    }

    default public GetPartitionsPsWithAuthResponse listPartitionsWithAuthInfoRequest(GetPartitionsPsWithAuthRequest req) throws MetaException, TException, NoSuchObjectException {
        throw new UnsupportedOperationException("MetaStore client does not support listing partitions with auth info");
    }

    default public List<Partition> listPartitionsWithAuthInfo(String catName, String dbName, String tableName, int maxParts, String userName, List<String> groupNames) throws MetaException, TException, NoSuchObjectException {
        throw new UnsupportedOperationException("MetaStore client does not support listing partitions with auth info");
    }

    @Deprecated
    default public List<Partition> getPartitionsByNames(String db_name, String tbl_name, List<String> part_names) throws NoSuchObjectException, MetaException, TException {
        throw new UnsupportedOperationException("MetaStore client does not support getting partitions by names");
    }

    default public PartitionsResponse getPartitionsRequest(PartitionsRequest req) throws NoSuchObjectException, MetaException, TException {
        throw new UnsupportedOperationException("MetaStore client does not support getting partitions request");
    }

    default public GetPartitionsByNamesResult getPartitionsByNames(GetPartitionsByNamesRequest req) throws TException {
        throw new UnsupportedOperationException("MetaStore client does not support getting partitions by names");
    }

    default public List<Partition> listPartitionsWithAuthInfo(String dbName, String tableName, List<String> partialPvals, short maxParts, String userName, List<String> groupNames) throws MetaException, TException, NoSuchObjectException {
        throw new UnsupportedOperationException("MetaStore client does not support listing partitions with auth info");
    }

    default public List<Partition> listPartitionsWithAuthInfo(String catName, String dbName, String tableName, List<String> partialPvals, int maxParts, String userName, List<String> groupNames) throws MetaException, TException, NoSuchObjectException {
        throw new UnsupportedOperationException("MetaStore client does not support listing partitions with auth info");
    }

    default public void markPartitionForEvent(String db_name, String tbl_name, Map<String, String> partKVs, PartitionEventType eventType) throws MetaException, NoSuchObjectException, TException, UnknownTableException, UnknownDBException, UnknownPartitionException, InvalidPartitionException {
        throw new UnsupportedOperationException("MetaStore client does not support marking partition for event");
    }

    default public void markPartitionForEvent(String catName, String db_name, String tbl_name, Map<String, String> partKVs, PartitionEventType eventType) throws MetaException, NoSuchObjectException, TException, UnknownTableException, UnknownDBException, UnknownPartitionException, InvalidPartitionException {
        throw new UnsupportedOperationException("MetaStore client does not support marking partition for event");
    }

    default public boolean isPartitionMarkedForEvent(String db_name, String tbl_name, Map<String, String> partKVs, PartitionEventType eventType) throws MetaException, NoSuchObjectException, TException, UnknownTableException, UnknownDBException, UnknownPartitionException, InvalidPartitionException {
        throw new UnsupportedOperationException("MetaStore client does not support checking if partition is marked for event");
    }

    default public boolean isPartitionMarkedForEvent(String catName, String db_name, String tbl_name, Map<String, String> partKVs, PartitionEventType eventType) throws MetaException, NoSuchObjectException, TException, UnknownTableException, UnknownDBException, UnknownPartitionException, InvalidPartitionException {
        throw new UnsupportedOperationException("MetaStore client does not support checking if partition is marked for event");
    }

    default public void validatePartitionNameCharacters(List<String> partVals) throws TException, MetaException {
        throw new UnsupportedOperationException("MetaStore client does not support validating partition name characters");
    }

    default public Table getTranslateTableDryrun(Table tbl) throws TException {
        return new Table();
    }

    public void createTable(Table var1) throws AlreadyExistsException, InvalidObjectException, MetaException, NoSuchObjectException, TException;

    public void createTable(CreateTableRequest var1) throws AlreadyExistsException, InvalidObjectException, MetaException, NoSuchObjectException, TException;

    default public void alter_table(String databaseName, String tblName, Table table) throws InvalidOperationException, MetaException, TException {
        throw new UnsupportedOperationException("MetaStore client does not support altering table");
    }

    default public void alter_table(String catName, String dbName, String tblName, Table newTable) throws InvalidOperationException, MetaException, TException {
        this.alter_table(catName, dbName, tblName, newTable, null);
    }

    default public void alter_table(String catName, String dbName, String tblName, Table newTable, EnvironmentContext envContext) throws InvalidOperationException, MetaException, TException {
        throw new UnsupportedOperationException("MetaStore client does not support altering table");
    }

    @Deprecated
    default public void alter_table(String defaultDatabaseName, String tblName, Table table, boolean cascade) throws TException {
        throw new UnsupportedOperationException("MetaStore client does not support altering table with cascade option");
    }

    @Deprecated
    default public void alter_table_with_environmentContext(String databaseName, String tblName, Table table, EnvironmentContext environmentContext) throws InvalidOperationException, MetaException, TException {
        throw new UnsupportedOperationException("MetaStore client does not support altering table with environment context");
    }

    default public void alter_table(String catName, String databaseName, String tblName, Table table, EnvironmentContext environmentContext, String validWriteIdList) throws TException {
    }

    public void createDatabase(Database var1) throws InvalidObjectException, AlreadyExistsException, MetaException, TException;

    public void dropDatabase(String var1) throws NoSuchObjectException, InvalidOperationException, MetaException, TException;

    public void dropDatabase(String var1, boolean var2, boolean var3) throws NoSuchObjectException, InvalidOperationException, MetaException, TException;

    public void dropDatabase(String var1, boolean var2, boolean var3, boolean var4) throws NoSuchObjectException, InvalidOperationException, MetaException, TException;

    @Deprecated
    default public void dropDatabase(String catName, String dbName, boolean deleteData, boolean ignoreUnknownDb, boolean cascade) throws NoSuchObjectException, InvalidOperationException, MetaException, TException {
        DropDatabaseRequest req = new DropDatabaseRequest();
        req.setName(dbName);
        req.setCatalogName(catName);
        req.setIgnoreUnknownDb(ignoreUnknownDb);
        req.setDeleteData(deleteData);
        req.setCascade(cascade);
        this.dropDatabase(req);
    }

    public void dropDatabase(DropDatabaseRequest var1) throws TException;

    default public void alterDatabase(String name, Database db) throws NoSuchObjectException, MetaException, TException {
        throw new UnsupportedOperationException("MetaStore client does not support altering database");
    }

    default public void alterDatabase(String catName, String dbName, Database newDb) throws NoSuchObjectException, MetaException, TException {
        throw new UnsupportedOperationException("MetaStore client does not support altering database");
    }

    default public void createDataConnector(DataConnector connector) throws InvalidObjectException, AlreadyExistsException, MetaException, TException {
        throw new UnsupportedOperationException("MetaStore client does not support creating dataconnector");
    }

    default public void dropDataConnector(String name, boolean ifNotExists, boolean checkReferences) throws NoSuchObjectException, InvalidOperationException, MetaException, TException {
        throw new UnsupportedOperationException("MetaStore client does not support dropping dataconnector");
    }

    default public void alterDataConnector(String name, DataConnector connector) throws NoSuchObjectException, MetaException, TException {
        throw new UnsupportedOperationException("MetaStore client does not support altering dataconnector");
    }

    default public DataConnector getDataConnector(String name) throws MetaException, TException {
        throw new UnsupportedOperationException("MetaStore client does not support getting dataconnector by name");
    }

    default public List<String> getAllDataConnectorNames() throws MetaException, TException {
        throw new UnsupportedOperationException("MetaStore client does not support getting all dataconnector names");
    }

    default public boolean dropPartition(String db_name, String tbl_name, List<String> part_vals, boolean deleteData) throws NoSuchObjectException, MetaException, TException {
        throw new UnsupportedOperationException("MetaStore client does not support dropping partition");
    }

    default public boolean dropPartition(String catName, String db_name, String tbl_name, List<String> part_vals, boolean deleteData) throws NoSuchObjectException, MetaException, TException {
        throw new UnsupportedOperationException("MetaStore client does not support dropping partition");
    }

    default public boolean dropPartition(String db_name, String tbl_name, List<String> part_vals, PartitionDropOptions options) throws NoSuchObjectException, MetaException, TException {
        throw new UnsupportedOperationException("MetaStore client does not support dropping partition");
    }

    default public boolean dropPartition(String catName, String db_name, String tbl_name, List<String> part_vals, PartitionDropOptions options) throws NoSuchObjectException, MetaException, TException {
        throw new UnsupportedOperationException("MetaStore client does not support dropping partition");
    }

    @Deprecated
    default public List<Partition> dropPartitions(String dbName, String tblName, List<Pair<Integer, byte[]>> partExprs, boolean deleteData, boolean ifExists) throws NoSuchObjectException, MetaException, TException {
        throw new UnsupportedOperationException("MetaStore client does not support dropping partitions by expression");
    }

    @Deprecated
    default public List<Partition> dropPartitions(String catName, String dbName, String tblName, List<Pair<Integer, byte[]>> partExprs, boolean deleteData, boolean ifExists) throws NoSuchObjectException, MetaException, TException {
        return this.dropPartitions(catName, dbName, tblName, partExprs, PartitionDropOptions.instance().deleteData(deleteData).ifExists(ifExists));
    }

    @Deprecated
    default public List<Partition> dropPartitions(String dbName, String tblName, List<Pair<Integer, byte[]>> partExprs, boolean deleteData, boolean ifExists, boolean needResults) throws TException {
        throw new UnsupportedOperationException("MetaStore client does not support dropping partitions by expression");
    }

    @Deprecated
    default public List<Partition> dropPartitions(String catName, String dbName, String tblName, List<Pair<Integer, byte[]>> partExprs, boolean deleteData, boolean ifExists, boolean needResults) throws NoSuchObjectException, MetaException, TException {
        return this.dropPartitions(catName, dbName, tblName, partExprs, PartitionDropOptions.instance().deleteData(deleteData).ifExists(ifExists).returnResults(needResults));
    }

    @Deprecated
    default public List<Partition> dropPartitions(String dbName, String tblName, List<Pair<Integer, byte[]>> partExprs, PartitionDropOptions options) throws NoSuchObjectException, MetaException, TException {
        throw new UnsupportedOperationException("MetaStore client does not support dropping partitions by expression");
    }

    @Deprecated
    default public List<Partition> dropPartitions(String catName, String dbName, String tblName, List<Pair<Integer, byte[]>> partExprs, PartitionDropOptions options) throws NoSuchObjectException, MetaException, TException {
        throw new UnsupportedOperationException("MetaStore client does not support dropping partitions by expression");
    }

    @Deprecated
    default public List<Partition> dropPartitions(String catName, String dbName, String tblName, List<Pair<Integer, byte[]>> partExprs, PartitionDropOptions options, EnvironmentContext context) throws TException {
        throw new UnsupportedOperationException("MetaStore client does not support dropping partitions by expression");
    }

    default public List<Partition> dropPartitions(TableName tableName, RequestPartsSpec partsSpec, PartitionDropOptions options, EnvironmentContext context) throws TException {
        throw new UnsupportedOperationException("MetaStore client does not support dropping partition");
    }

    default public boolean dropPartition(String db_name, String tbl_name, String name, boolean deleteData) throws NoSuchObjectException, MetaException, TException {
        throw new UnsupportedOperationException("MetaStore client does not support dropping partition");
    }

    default public boolean dropPartition(String catName, String db_name, String tbl_name, String name, boolean deleteData) throws NoSuchObjectException, MetaException, TException {
        throw new UnsupportedOperationException("MetaStore client does not support dropping partition");
    }

    default public void alter_partition(String dbName, String tblName, Partition newPart) throws InvalidOperationException, MetaException, TException {
        throw new UnsupportedOperationException("MetaStore client does not support altering partition");
    }

    @Deprecated
    default public void alter_partition(String dbName, String tblName, Partition newPart, EnvironmentContext environmentContext) throws InvalidOperationException, MetaException, TException {
        throw new UnsupportedOperationException("MetaStore client does not support altering partition");
    }

    default public void alter_partition(String catName, String dbName, String tblName, Partition newPart, EnvironmentContext environmentContext, String writeIdList) throws TException {
        throw new UnsupportedOperationException("MetaStore client does not support altering partition");
    }

    default public void alter_partition(String catName, String dbName, String tblName, Partition newPart, EnvironmentContext environmentContext) throws InvalidOperationException, MetaException, TException {
        throw new UnsupportedOperationException("MetaStore client does not support altering partition");
    }

    @Deprecated
    default public void alter_partitions(String dbName, String tblName, List<Partition> newParts) throws InvalidOperationException, MetaException, TException {
        throw new UnsupportedOperationException("MetaStore client does not support altering partitions");
    }

    @Deprecated
    default public void alter_partitions(String dbName, String tblName, List<Partition> newParts, EnvironmentContext environmentContext) throws InvalidOperationException, MetaException, TException {
        throw new UnsupportedOperationException("MetaStore client does not support altering partitions");
    }

    default public void alter_partitions(String dbName, String tblName, List<Partition> newParts, EnvironmentContext environmentContext, String writeIdList, long writeId) throws TException {
        throw new UnsupportedOperationException("MetaStore client does not support altering partitions");
    }

    default public void alter_partitions(String catName, String dbName, String tblName, List<Partition> newParts, EnvironmentContext environmentContext, String writeIdList, long writeId) throws InvalidOperationException, MetaException, TException {
        throw new UnsupportedOperationException("MetaStore client does not support altering partitions");
    }

    @Deprecated
    default public void renamePartition(String dbname, String tableName, List<String> part_vals, Partition newPart) throws InvalidOperationException, MetaException, TException {
        throw new UnsupportedOperationException("MetaStore client does not support renaming partition");
    }

    default public void renamePartition(String catName, String dbname, String tableName, List<String> part_vals, Partition newPart, String validWriteIds) throws TException {
        this.renamePartition(catName, dbname, tableName, part_vals, newPart, validWriteIds, 0L, false);
    }

    default public void renamePartition(String catName, String dbname, String tableName, List<String> part_vals, Partition newPart, String validWriteIds, long txnId, boolean makeCopy) throws TException {
        throw new UnsupportedOperationException("MetaStore client does not support renaming partition");
    }

    default public List<FieldSchema> getFields(String db, String tableName) throws MetaException, TException, UnknownTableException, UnknownDBException {
        throw new UnsupportedOperationException("MetaStore client does not support getting fields for a table");
    }

    default public List<FieldSchema> getFields(String catName, String db, String tableName) throws MetaException, TException, UnknownTableException, UnknownDBException {
        throw new UnsupportedOperationException("MetaStore client does not support getting fields for a table");
    }

    default public GetFieldsResponse getFieldsRequest(GetFieldsRequest req) throws MetaException, TException, UnknownTableException, UnknownDBException {
        throw new UnsupportedOperationException("MetaStore client does not support getting fields for a table");
    }

    default public List<FieldSchema> getSchema(String db, String tableName) throws MetaException, TException, UnknownTableException, UnknownDBException {
        throw new UnsupportedOperationException("MetaStore client does not support getting schema for a table");
    }

    default public List<FieldSchema> getSchema(String catName, String db, String tableName) throws MetaException, TException, UnknownTableException, UnknownDBException {
        throw new UnsupportedOperationException("MetaStore client does not support getting schema for a table");
    }

    default public GetSchemaResponse getSchemaRequest(GetSchemaRequest req) throws MetaException, TException, UnknownTableException, UnknownDBException {
        throw new UnsupportedOperationException("MetaStore client does not support getting schema for a table");
    }

    default public String getConfigValue(String name, String defaultValue) throws TException, ConfigValSecurityException {
        return "50";
    }

    default public List<String> partitionNameToVals(String name) throws MetaException, TException {
        throw new UnsupportedOperationException("MetaStore client does not support converting partition name to values");
    }

    default public Map<String, String> partitionNameToSpec(String name) throws MetaException, TException {
        throw new UnsupportedOperationException("MetaStore client does not support converting partition name to spec");
    }

    default public boolean updateTableColumnStatistics(ColumnStatistics statsObj) throws NoSuchObjectException, InvalidObjectException, MetaException, TException, InvalidInputException {
        throw new UnsupportedOperationException("MetaStore client does not support updating table column statistics");
    }

    default public boolean updatePartitionColumnStatistics(ColumnStatistics statsObj) throws NoSuchObjectException, InvalidObjectException, MetaException, TException, InvalidInputException {
        throw new UnsupportedOperationException("MetaStore client does not support updating partition column statistics");
    }

    default public List<ColumnStatisticsObj> getTableColumnStatistics(String dbName, String tableName, List<String> colNames, String engine) throws NoSuchObjectException, MetaException, TException {
        throw new UnsupportedOperationException("MetaStore client does not support getting table column statistics");
    }

    default public List<ColumnStatisticsObj> getTableColumnStatistics(String dbName, String tableName, List<String> colNames, String engine, String validWriteIdList) throws TException {
        throw new UnsupportedOperationException("MetaStore client does not support getting table column statistics");
    }

    default public List<ColumnStatisticsObj> getTableColumnStatistics(String catName, String dbName, String tableName, List<String> colNames, String engine) throws NoSuchObjectException, MetaException, TException {
        throw new UnsupportedOperationException("MetaStore client does not support getting table column statistics");
    }

    default public List<ColumnStatisticsObj> getTableColumnStatistics(String catName, String dbName, String tableName, List<String> colNames, String engine, String validWriteIdList) throws TException {
        throw new UnsupportedOperationException("MetaStore client does not support getting table column statistics");
    }

    default public Map<String, List<ColumnStatisticsObj>> getPartitionColumnStatistics(String dbName, String tableName, List<String> partNames, List<String> colNames, String engine) throws NoSuchObjectException, MetaException, TException {
        throw new UnsupportedOperationException("MetaStore client does not support getting partition column statistics");
    }

    default public Map<String, List<ColumnStatisticsObj>> getPartitionColumnStatistics(String dbName, String tableName, List<String> partNames, List<String> colNames, String engine, String validWriteIdList) throws TException {
        throw new UnsupportedOperationException("MetaStore client does not support getting partition column statistics");
    }

    default public Map<String, List<ColumnStatisticsObj>> getPartitionColumnStatistics(String catName, String dbName, String tableName, List<String> partNames, List<String> colNames, String engine) throws NoSuchObjectException, MetaException, TException {
        throw new UnsupportedOperationException("MetaStore client does not support getting partition column statistics");
    }

    default public Map<String, List<ColumnStatisticsObj>> getPartitionColumnStatistics(String catName, String dbName, String tableName, List<String> partNames, List<String> colNames, String engine, String validWriteIdList) throws TException {
        throw new UnsupportedOperationException("MetaStore client does not support getting partition column statistics");
    }

    @Deprecated
    default public boolean deletePartitionColumnStatistics(String dbName, String tableName, String partName, String colName, String engine) throws NoSuchObjectException, MetaException, InvalidObjectException, TException, InvalidInputException {
        DeleteColumnStatisticsRequest request = new DeleteColumnStatisticsRequest(dbName, tableName);
        request.setEngine(engine);
        if (colName != null) {
            request.addToCol_names(colName);
        }
        if (partName != null) {
            request.addToPart_names(partName);
        }
        return this.deleteColumnStatistics(request);
    }

    @Deprecated
    default public boolean deletePartitionColumnStatistics(String catName, String dbName, String tableName, String partName, String colName, String engine) throws NoSuchObjectException, MetaException, InvalidObjectException, TException, InvalidInputException {
        DeleteColumnStatisticsRequest request = new DeleteColumnStatisticsRequest(dbName, tableName);
        request.setCat_name(catName);
        request.setEngine(engine);
        if (colName != null) {
            request.addToCol_names(colName);
        }
        if (partName != null) {
            request.addToPart_names(partName);
        }
        return this.deleteColumnStatistics(request);
    }

    @Deprecated
    default public boolean deleteTableColumnStatistics(String dbName, String tableName, String colName, String engine) throws NoSuchObjectException, MetaException, InvalidObjectException, TException, InvalidInputException {
        DeleteColumnStatisticsRequest request = new DeleteColumnStatisticsRequest(dbName, tableName);
        request.setEngine(engine);
        if (colName != null) {
            request.addToCol_names(colName);
        }
        request.setTableLevel(true);
        return this.deleteColumnStatistics(request);
    }

    @Deprecated
    default public boolean deleteTableColumnStatistics(String catName, String dbName, String tableName, String colName, String engine) throws NoSuchObjectException, MetaException, InvalidObjectException, TException, InvalidInputException {
        DeleteColumnStatisticsRequest request = new DeleteColumnStatisticsRequest(dbName, tableName);
        request.setCat_name(catName);
        request.setEngine(engine);
        if (colName != null) {
            request.addToCol_names(colName);
        }
        request.setTableLevel(true);
        return this.deleteColumnStatistics(request);
    }

    default public boolean deleteColumnStatistics(DeleteColumnStatisticsRequest req) throws TException {
        throw new UnsupportedOperationException("MetaStore client does not support deleting column statistics");
    }

    default public void updateTransactionalStatistics(UpdateTransactionalStatsRequest req) throws TException {
        throw new UnsupportedOperationException("MetaStore client does not support updating transactional statistics");
    }

    default public boolean create_role(Role role) throws MetaException, TException {
        throw new UnsupportedOperationException("MetaStore client does not support creating roles");
    }

    default public boolean drop_role(String role_name) throws MetaException, TException {
        throw new UnsupportedOperationException("MetaStore client does not support dropping roles");
    }

    default public List<String> listRoleNames() throws MetaException, TException {
        throw new UnsupportedOperationException("MetaStore client does not support listing role names");
    }

    default public boolean grant_role(String role_name, String user_name, PrincipalType principalType, String grantor, PrincipalType grantorType, boolean grantOption) throws MetaException, TException {
        throw new UnsupportedOperationException("MetaStore client does not support granting roles");
    }

    default public boolean revoke_role(String role_name, String user_name, PrincipalType principalType, boolean grantOption) throws MetaException, TException {
        throw new UnsupportedOperationException("MetaStore client does not support revoking roles");
    }

    default public List<Role> list_roles(String principalName, PrincipalType principalType) throws MetaException, TException {
        throw new UnsupportedOperationException("MetaStore client does not support listing roles");
    }

    default public PrincipalPrivilegeSet get_privilege_set(HiveObjectRef hiveObject, String user_name, List<String> group_names) throws MetaException, TException {
        throw new UnsupportedOperationException("MetaStore client does not support getting privilege set");
    }

    default public List<HiveObjectPrivilege> list_privileges(String principal_name, PrincipalType principal_type, HiveObjectRef hiveObject) throws MetaException, TException {
        throw new UnsupportedOperationException("MetaStore client does not support listing privileges");
    }

    default public boolean grant_privileges(PrivilegeBag privileges) throws MetaException, TException {
        throw new UnsupportedOperationException("MetaStore client does not support granting privileges");
    }

    default public boolean revoke_privileges(PrivilegeBag privileges, boolean grantOption) throws MetaException, TException {
        throw new UnsupportedOperationException("MetaStore client does not support revoking privileges");
    }

    default public boolean refresh_privileges(HiveObjectRef objToRefresh, String authorizer, PrivilegeBag grantPrivileges) throws MetaException, TException {
        throw new UnsupportedOperationException("MetaStore client does not support refreshing privileges");
    }

    default public String getDelegationToken(String owner, String renewerKerberosPrincipalName) throws MetaException, TException {
        throw new UnsupportedOperationException("MetaStore client does not support getting delegation token");
    }

    default public long renewDelegationToken(String tokenStrForm) throws MetaException, TException {
        throw new UnsupportedOperationException("MetaStore client does not support renewing delegation token");
    }

    default public void cancelDelegationToken(String tokenStrForm) throws MetaException, TException {
        throw new UnsupportedOperationException("MetaStore client does not support canceling delegation token");
    }

    default public String getTokenStrForm() throws IOException {
        throw new UnsupportedOperationException("MetaStore client does not support getting token string form");
    }

    default public boolean addToken(String tokenIdentifier, String delegationToken) throws TException {
        throw new UnsupportedOperationException("MetaStore client does not support adding tokens");
    }

    default public boolean removeToken(String tokenIdentifier) throws TException {
        throw new UnsupportedOperationException("MetaStore client does not support removing tokens");
    }

    default public String getToken(String tokenIdentifier) throws TException {
        throw new UnsupportedOperationException("MetaStore client does not support getting tokens");
    }

    default public List<String> getAllTokenIdentifiers() throws TException {
        throw new UnsupportedOperationException("MetaStore client does not support getting all tokens");
    }

    default public int addMasterKey(String key) throws TException {
        throw new UnsupportedOperationException("MetaStore client does not support adding master keys");
    }

    default public void updateMasterKey(Integer seqNo, String key) throws TException {
        throw new UnsupportedOperationException("MetaStore client does not support updating master keys");
    }

    default public boolean removeMasterKey(Integer keySeq) throws TException {
        throw new UnsupportedOperationException("MetaStore client does not support removing master keys");
    }

    default public String[] getMasterKeys() throws TException {
        throw new UnsupportedOperationException("MetaStore client does not support getting master keys");
    }

    default public void createFunction(Function func) throws InvalidObjectException, MetaException, TException {
        throw new UnsupportedOperationException("MetaStore client does not support creating functions");
    }

    default public void alterFunction(String dbName, String funcName, Function newFunction) throws InvalidObjectException, MetaException, TException {
        throw new UnsupportedOperationException("MetaStore client does not support altering functions");
    }

    default public void alterFunction(String catName, String dbName, String funcName, Function newFunction) throws InvalidObjectException, MetaException, TException {
        throw new UnsupportedOperationException("MetaStore client does not support altering functions");
    }

    default public void dropFunction(String dbName, String funcName) throws MetaException, NoSuchObjectException, InvalidObjectException, InvalidInputException, TException {
        throw new UnsupportedOperationException("MetaStore client does not support dropping functions");
    }

    default public void dropFunction(String catName, String dbName, String funcName) throws MetaException, NoSuchObjectException, InvalidObjectException, InvalidInputException, TException {
        throw new UnsupportedOperationException("MetaStore client does not support dropping functions");
    }

    default public Function getFunction(String dbName, String funcName) throws MetaException, TException {
        throw new UnsupportedOperationException("MetaStore client does not support getting functions");
    }

    default public Function getFunction(String catName, String dbName, String funcName) throws MetaException, TException {
        throw new UnsupportedOperationException("MetaStore client does not support getting functions");
    }

    @Deprecated
    default public List<String> getFunctions(String dbName, String pattern) throws MetaException, TException {
        throw new UnsupportedOperationException("MetaStore client does not support getting functions");
    }

    default public GetFunctionsResponse getFunctionsRequest(GetFunctionsRequest functionRequest) throws TException {
        throw new UnsupportedOperationException("MetaStore client does not support getting functions");
    }

    @Deprecated
    default public List<String> getFunctions(String catName, String dbName, String pattern) throws MetaException, TException {
        throw new UnsupportedOperationException("MetaStore client does not support getting functions");
    }

    default public GetAllFunctionsResponse getAllFunctions() throws MetaException, TException {
        return new GetAllFunctionsResponse();
    }

    default public GetOpenTxnsResponse getOpenTxns() throws TException {
        throw new UnsupportedOperationException("MetaStore client does not support getting open transactions");
    }

    default public ValidTxnList getValidTxns() throws TException {
        throw new UnsupportedOperationException("MetaStore client does not support getting valid transactions");
    }

    default public ValidTxnList getValidTxns(long currentTxn) throws TException {
        throw new UnsupportedOperationException("MetaStore client does not support getting valid transactions");
    }

    default public ValidTxnList getValidTxns(long currentTxn, List<TxnType> excludeTxnTypes) throws TException {
        throw new UnsupportedOperationException("MetaStore client does not support getting valid transactions");
    }

    default public ValidWriteIdList getValidWriteIds(String fullTableName) throws TException {
        throw new UnsupportedOperationException("MetaStore client does not support getting valid write ids");
    }

    default public ValidWriteIdList getValidWriteIds(String fullTableName, Long writeId) throws TException {
        throw new UnsupportedOperationException("MetaStore client does not support getting valid write ids");
    }

    default public List<TableValidWriteIds> getValidWriteIds(List<String> tablesList, String validTxnList) throws TException {
        throw new UnsupportedOperationException("MetaStore client does not support getting valid write ids");
    }

    default public void addWriteIdsToMinHistory(long txnId, Map<String, Long> writeIds) throws TException {
        throw new UnsupportedOperationException("MetaStore client does not support adding write ids to min history");
    }

    default public long openTxn(String user) throws TException {
        throw new UnsupportedOperationException("MetaStore client does not support opening transactions");
    }

    default public long openTxn(String user, TxnType txnType) throws TException {
        throw new UnsupportedOperationException("MetaStore client does not support opening transactions with type");
    }

    default public List<Long> replOpenTxn(String replPolicy, List<Long> srcTxnIds, String user, TxnType txnType) throws TException {
        throw new UnsupportedOperationException("MetaStore client does not support opening repl replayed or hive replication transactions");
    }

    default public OpenTxnsResponse openTxns(String user, int numTxns) throws TException {
        throw new UnsupportedOperationException("MetaStore client does not support opening transactions in batch");
    }

    default public void rollbackTxn(long txnid) throws NoSuchTxnException, TException {
        throw new UnsupportedOperationException("MetaStore client does not support rolling back transactions");
    }

    default public void rollbackTxn(AbortTxnRequest abortTxnRequest) throws NoSuchTxnException, TException {
        throw new UnsupportedOperationException("MetaStore client does not support rolling back transactions");
    }

    default public void replRollbackTxn(long srcTxnid, String replPolicy, TxnType txnType) throws NoSuchTxnException, TException {
        throw new UnsupportedOperationException("MetaStore client does not support rolling back transactions");
    }

    default public ReplayedTxnsForPolicyResult getReplayedTxnsForPolicy(String replPolicy) throws TException {
        throw new UnsupportedOperationException("MetaStore client does not support getting replayed transactions for policy");
    }

    default public void commitTxn(long txnid) throws NoSuchTxnException, TxnAbortedException, TException {
        throw new UnsupportedOperationException("MetaStore client does not support committing transactions");
    }

    default public void commitTxnWithKeyValue(long txnid, long tableId, String key, String value) throws NoSuchTxnException, TxnAbortedException, TException {
        throw new UnsupportedOperationException("MetaStore client does not support committing transactions with key/value");
    }

    default public void commitTxn(CommitTxnRequest rqst) throws NoSuchTxnException, TxnAbortedException, TException {
        throw new UnsupportedOperationException("MetaStore client does not support committing transactions with request");
    }

    default public void abortTxns(List<Long> txnids) throws TException {
        throw new UnsupportedOperationException("MetaStore client does not support aborting transactions");
    }

    default public void abortTxns(AbortTxnsRequest abortTxnsRequest) throws TException {
        throw new UnsupportedOperationException("MetaStore client does not support aborting transactions with request");
    }

    default public long allocateTableWriteId(long txnId, String dbName, String tableName) throws TException {
        throw new UnsupportedOperationException("MetaStore client does not support allocating table write IDs");
    }

    default public long allocateTableWriteId(long txnId, String dbName, String tableName, boolean reallocate) throws TException {
        throw new UnsupportedOperationException("MetaStore client does not support allocating table write IDs with reallocate option");
    }

    default public void replTableWriteIdState(String validWriteIdList, String dbName, String tableName, List<String> partNames) throws TException {
        throw new UnsupportedOperationException("MetaStore client does not support replicating table write IDs state");
    }

    default public List<TxnToWriteId> allocateTableWriteIdsBatch(List<Long> txnIds, String dbName, String tableName) throws TException {
        throw new UnsupportedOperationException("MetaStore client does not support allocating table write IDs in batch");
    }

    default public List<TxnToWriteId> replAllocateTableWriteIdsBatch(String dbName, String tableName, String replPolicy, List<TxnToWriteId> srcTxnToWriteIdList) throws TException {
        throw new UnsupportedOperationException("MetaStore client does not support replicating allocating table write IDs in batch");
    }

    default public long getMaxAllocatedWriteId(String dbName, String tableName) throws TException {
        throw new UnsupportedOperationException("MetaStore client does not support getting maximum allocated write IDs");
    }

    default public void seedWriteId(String dbName, String tableName, long seedWriteId) throws TException {
        throw new UnsupportedOperationException("MetaStore client does not support seeding write IDs");
    }

    default public void seedTxnId(long seedTxnId) throws TException {
        throw new UnsupportedOperationException("MetaStore client does not support seeding transaction IDs");
    }

    default public GetOpenTxnsInfoResponse showTxns() throws TException {
        throw new UnsupportedOperationException("MetaStore client does not support showing transactions");
    }

    @RetrySemantics.CannotRetry
    default public LockResponse lock(LockRequest request) throws NoSuchTxnException, TxnAbortedException, TException {
        throw new UnsupportedOperationException("MetaStore client does not support locking");
    }

    default public LockResponse checkLock(long lockid) throws NoSuchTxnException, TxnAbortedException, NoSuchLockException, TException {
        throw new UnsupportedOperationException("MetaStore client does not support checking locks");
    }

    default public void unlock(long lockid) throws NoSuchLockException, TxnOpenException, TException {
        throw new UnsupportedOperationException("MetaStore client does not support unlocking locks");
    }

    default public ShowLocksResponse showLocks(ShowLocksRequest showLocksRequest) throws TException {
        throw new UnsupportedOperationException("MetaStore client does not support showing locks");
    }

    default public void heartbeat(long txnid, long lockid) throws NoSuchLockException, NoSuchTxnException, TxnAbortedException, TException {
        throw new UnsupportedOperationException("MetaStore client does not support heartbeating");
    }

    default public HeartbeatTxnRangeResponse heartbeatTxnRange(long min, long max) throws TException {
        throw new UnsupportedOperationException("MetaStore client does not support heartbeating a range of transactions");
    }

    default public CompactionResponse compact2(CompactionRequest request) throws TException {
        throw new UnsupportedOperationException("MetaStore client does not support compacting tables or partitions");
    }

    default public ShowCompactResponse showCompactions() throws TException {
        throw new UnsupportedOperationException("MetaStore client does not support showing compactions");
    }

    default public ShowCompactResponse showCompactions(ShowCompactRequest request) throws TException {
        throw new UnsupportedOperationException("MetaStore client does not support showing compactions with request");
    }

    default public boolean submitForCleanup(CompactionRequest rqst, long highestWriteId, long txnId) throws TException {
        throw new UnsupportedOperationException("MetaStore client does not support submitting for cleanup");
    }

    default public GetLatestCommittedCompactionInfoResponse getLatestCommittedCompactionInfo(GetLatestCommittedCompactionInfoRequest request) throws TException {
        throw new UnsupportedOperationException("MetaStore client does not support getting latest committed compaction info");
    }

    default public void addDynamicPartitions(long txnId, long writeId, String dbName, String tableName, List<String> partNames, DataOperationType operationType) throws TException {
        throw new UnsupportedOperationException("MetaStore client does not support adding dynamic partitions");
    }

    default public void insertTable(Table table, boolean overwrite) throws MetaException {
        throw new UnsupportedOperationException("MetaStore client does not support inserting tables");
    }

    default public long getLatestTxnIdInConflict(long txnId) throws TException {
        throw new UnsupportedOperationException("MetaStore client does not support getting latest transaction id in conflict");
    }

    default public GetDatabaseObjectsResponse get_databases_req(GetDatabaseObjectsRequest request) throws TException {
        throw new UnsupportedOperationException("MetaStore client does not support getting database objects");
    }

    @InterfaceAudience.LimitedPrivate(value={"HCatalog"})
    default public NotificationEventResponse getNextNotification(long lastEventId, int maxEvents, NotificationFilter filter) throws TException {
        return new NotificationEventResponse();
    }

    @InterfaceAudience.LimitedPrivate(value={"HCatalog"})
    default public NotificationEventResponse getNextNotification(NotificationEventRequest request, boolean allowGapsInEventIds, NotificationFilter filter) throws TException {
        throw new UnsupportedOperationException("MetaStore client does not support getting next notification with request");
    }

    @InterfaceAudience.LimitedPrivate(value={"HCatalog"})
    default public CurrentNotificationEventId getCurrentNotificationEventId() throws TException {
        return new CurrentNotificationEventId();
    }

    @InterfaceAudience.LimitedPrivate(value={"HCatalog"})
    default public NotificationEventsCountResponse getNotificationEventsCount(NotificationEventsCountRequest rqst) throws TException {
        throw new UnsupportedOperationException("MetaStore client does not support getting notification events count");
    }

    @InterfaceAudience.LimitedPrivate(value={"Apache Hive, HCatalog"})
    default public FireEventResponse fireListenerEvent(FireEventRequest request) throws TException {
        throw new UnsupportedOperationException("MetaStore client does not support firing events");
    }

    @InterfaceAudience.LimitedPrivate(value={"Apache Hive, HCatalog"})
    default public void addWriteNotificationLog(WriteNotificationLogRequest rqst) throws TException {
        throw new UnsupportedOperationException("MetaStore client does not support adding write notification log");
    }

    @InterfaceAudience.LimitedPrivate(value={"Apache Hive, HCatalog"})
    default public void addWriteNotificationLogInBatch(WriteNotificationLogBatchRequest rqst) throws TException {
        throw new UnsupportedOperationException("MetaStore client does not support adding write notification log in batch");
    }

    default public GetPrincipalsInRoleResponse get_principals_in_role(GetPrincipalsInRoleRequest getPrincRoleReq) throws MetaException, TException {
        throw new UnsupportedOperationException("MetaStore client does not support getting principals in role");
    }

    default public GetRoleGrantsForPrincipalResponse get_role_grants_for_principal(GetRoleGrantsForPrincipalRequest getRolePrincReq) throws MetaException, TException {
        throw new UnsupportedOperationException("MetaStore client does not support getting role grants for principal");
    }

    default public AggrStats getAggrColStatsFor(String dbName, String tblName, List<String> colNames, List<String> partName, String engine) throws NoSuchObjectException, MetaException, TException {
        throw new UnsupportedOperationException("MetaStore client does not support getting aggregated column stats for partitions");
    }

    default public AggrStats getAggrColStatsFor(String dbName, String tblName, List<String> colNames, List<String> partName, String engine, String writeIdList) throws TException {
        throw new UnsupportedOperationException("MetaStore client does not support getting aggregated column stats for partitions with writeIdList");
    }

    default public AggrStats getAggrColStatsFor(String catName, String dbName, String tblName, List<String> colNames, List<String> partNames, String engine) throws NoSuchObjectException, MetaException, TException {
        throw new UnsupportedOperationException("MetaStore client does not support getting aggregated column stats for partitions with catalog name");
    }

    default public AggrStats getAggrColStatsFor(String catName, String dbName, String tblName, List<String> colNames, List<String> partNames, String engine, String writeIdList) throws TException {
        throw new UnsupportedOperationException("MetaStore client does not support getting aggregated column stats for partitions with catalog name and writeIdList");
    }

    default public boolean setPartitionColumnStatistics(SetPartitionsStatsRequest request) throws NoSuchObjectException, InvalidObjectException, MetaException, TException, InvalidInputException {
        throw new UnsupportedOperationException("MetaStore client does not support setting partition column statistics");
    }

    default public void flushCache() {
    }

    default public Iterable<Map.Entry<Long, ByteBuffer>> getFileMetadata(List<Long> fileIds) throws TException {
        throw new UnsupportedOperationException("MetaStore client does not support getting file metadata");
    }

    default public Iterable<Map.Entry<Long, MetadataPpdResult>> getFileMetadataBySarg(List<Long> fileIds, ByteBuffer sarg, boolean doGetFooters) throws TException {
        throw new UnsupportedOperationException("MetaStore client does not support getting file metadata by sarg");
    }

    default public void clearFileMetadata(List<Long> fileIds) throws TException {
        throw new UnsupportedOperationException("MetaStore client does not support clearing file metadata");
    }

    default public void putFileMetadata(List<Long> fileIds, List<ByteBuffer> metadata) throws TException {
        throw new UnsupportedOperationException("MetaStore client does not support putting file metadata");
    }

    default public boolean isSameConfObj(Configuration c) {
        throw new UnsupportedOperationException("MetaStore client does not support checking if the configuration object is the same");
    }

    default public boolean cacheFileMetadata(String dbName, String tableName, String partName, boolean allParts) throws TException {
        throw new UnsupportedOperationException("MetaStore client does not support caching file metadata");
    }

    default public List<SQLPrimaryKey> getPrimaryKeys(PrimaryKeysRequest request) throws MetaException, NoSuchObjectException, TException {
        throw new UnsupportedOperationException("MetaStore client does not support getting primary keys");
    }

    default public List<SQLForeignKey> getForeignKeys(ForeignKeysRequest request) throws MetaException, NoSuchObjectException, TException {
        throw new UnsupportedOperationException("MetaStore client does not support getting foreign keys");
    }

    default public List<SQLUniqueConstraint> getUniqueConstraints(UniqueConstraintsRequest request) throws MetaException, NoSuchObjectException, TException {
        throw new UnsupportedOperationException("MetaStore client does not support getting unique constraints");
    }

    default public List<SQLNotNullConstraint> getNotNullConstraints(NotNullConstraintsRequest request) throws MetaException, NoSuchObjectException, TException {
        return Collections.emptyList();
    }

    default public List<SQLDefaultConstraint> getDefaultConstraints(DefaultConstraintsRequest request) throws TException {
        throw new UnsupportedOperationException("MetaStore client does not support getting default constraints");
    }

    default public List<SQLCheckConstraint> getCheckConstraints(CheckConstraintsRequest request) throws TException {
        return Collections.emptyList();
    }

    default public SQLAllTableConstraints getAllTableConstraints(AllTableConstraintsRequest request) throws MetaException, NoSuchObjectException, TException {
        return new SQLAllTableConstraints();
    }

    default public void createTableWithConstraints(Table tTbl, List<SQLPrimaryKey> primaryKeys, List<SQLForeignKey> foreignKeys, List<SQLUniqueConstraint> uniqueConstraints, List<SQLNotNullConstraint> notNullConstraints, List<SQLDefaultConstraint> defaultConstraints, List<SQLCheckConstraint> checkConstraints) throws TException {
        throw new UnsupportedOperationException("MetaStore client does not support creating table with constraints");
    }

    default public void dropConstraint(String dbName, String tableName, String constraintName) throws MetaException, NoSuchObjectException, TException {
        throw new UnsupportedOperationException("MetaStore client does not support dropping constraints");
    }

    default public void dropConstraint(String catName, String dbName, String tableName, String constraintName) throws MetaException, NoSuchObjectException, TException {
        throw new UnsupportedOperationException("MetaStore client does not support dropping constraints with catalog name");
    }

    default public void addPrimaryKey(List<SQLPrimaryKey> primaryKeyCols) throws MetaException, NoSuchObjectException, TException {
        throw new UnsupportedOperationException("MetaStore client does not support adding primary keys");
    }

    default public void addForeignKey(List<SQLForeignKey> foreignKeyCols) throws MetaException, NoSuchObjectException, TException {
        throw new UnsupportedOperationException("MetaStore client does not support adding foreign keys");
    }

    default public void addUniqueConstraint(List<SQLUniqueConstraint> uniqueConstraintCols) throws MetaException, NoSuchObjectException, TException {
        throw new UnsupportedOperationException("MetaStore client does not support adding unique constraints");
    }

    default public void addNotNullConstraint(List<SQLNotNullConstraint> notNullConstraintCols) throws MetaException, NoSuchObjectException, TException {
        throw new UnsupportedOperationException("MetaStore client does not support adding not null constraints");
    }

    default public void addDefaultConstraint(List<SQLDefaultConstraint> defaultConstraints) throws TException {
        throw new UnsupportedOperationException("MetaStore client does not support adding default constraints");
    }

    default public void addCheckConstraint(List<SQLCheckConstraint> checkConstraints) throws TException {
        throw new UnsupportedOperationException("MetaStore client does not support adding check constraints");
    }

    default public String getMetastoreDbUuid() throws MetaException, TException {
        throw new UnsupportedOperationException("MetaStore client does not support getting metastore db uuid");
    }

    default public void createResourcePlan(WMResourcePlan resourcePlan, String copyFromName) throws TException {
        throw new UnsupportedOperationException("MetaStore client does not support creating resource plans");
    }

    default public WMFullResourcePlan getResourcePlan(String resourcePlanName, String ns) throws TException {
        throw new UnsupportedOperationException("MetaStore client does not support getting resource plans");
    }

    default public List<WMResourcePlan> getAllResourcePlans(String ns) throws TException {
        throw new UnsupportedOperationException("MetaStore client does not support getting all resource plans");
    }

    default public void dropResourcePlan(String resourcePlanName, String ns) throws TException {
        throw new UnsupportedOperationException("MetaStore client does not support dropping resource plans");
    }

    default public WMFullResourcePlan alterResourcePlan(String resourcePlanName, String ns, WMNullableResourcePlan resourcePlan, boolean canActivateDisabled, boolean isForceDeactivate, boolean isReplace) throws TException {
        throw new UnsupportedOperationException("MetaStore client does not support altering resource plans");
    }

    default public WMFullResourcePlan getActiveResourcePlan(String ns) throws TException {
        return new WMFullResourcePlan();
    }

    default public WMValidateResourcePlanResponse validateResourcePlan(String resourcePlanName, String ns) throws TException {
        throw new UnsupportedOperationException("this method is not supported");
    }

    default public void createWMTrigger(WMTrigger trigger) throws TException {
        throw new UnsupportedOperationException("MetaStore client does not support creating WM triggers");
    }

    default public void alterWMTrigger(WMTrigger trigger) throws TException {
        throw new UnsupportedOperationException("MetaStore client does not support altering WM triggers");
    }

    default public void dropWMTrigger(String resourcePlanName, String triggerName, String ns) throws TException {
        throw new UnsupportedOperationException("MetaStore client does not support dropping WM triggers");
    }

    default public List<WMTrigger> getTriggersForResourcePlan(String resourcePlan, String ns) throws TException {
        throw new UnsupportedOperationException("MetaStore client does not support getting WM triggers for resource plans");
    }

    default public void createWMPool(WMPool pool) throws TException {
        throw new UnsupportedOperationException("MetaStore client does not support creating WM pools");
    }

    default public void alterWMPool(WMNullablePool pool, String poolPath) throws TException {
        throw new UnsupportedOperationException("MetaStore client does not support altering WM pools");
    }

    default public void dropWMPool(String resourcePlanName, String poolPath, String ns) throws TException {
        throw new UnsupportedOperationException("MetaStore client does not support dropping WM pools");
    }

    default public void createOrUpdateWMMapping(WMMapping mapping, boolean isUpdate) throws TException {
        throw new UnsupportedOperationException("MetaStore client does not support creating or updating WM mappings");
    }

    default public void dropWMMapping(WMMapping mapping) throws TException {
        throw new UnsupportedOperationException("MetaStore client does not support dropping WM mappings");
    }

    default public void createOrDropTriggerToPoolMapping(String resourcePlanName, String triggerName, String poolPath, boolean shouldDrop, String ns) throws TException {
        throw new UnsupportedOperationException("MetaStore client does not support creating or dropping trigger to pool mappings");
    }

    default public void createISchema(ISchema schema) throws TException {
        throw new UnsupportedOperationException("MetaStore client does not support creating schemas");
    }

    default public void alterISchema(String catName, String dbName, String schemaName, ISchema newSchema) throws TException {
        throw new UnsupportedOperationException("MetaStore client does not support altering schemas");
    }

    default public ISchema getISchema(String catName, String dbName, String name) throws TException {
        throw new UnsupportedOperationException("MetaStore client does not support getting schemas");
    }

    default public void dropISchema(String catName, String dbName, String name) throws TException {
        throw new UnsupportedOperationException("MetaStore client does not support dropping schemas");
    }

    default public void addSchemaVersion(SchemaVersion schemaVersion) throws TException {
        throw new UnsupportedOperationException("MetaStore client does not support adding schema versions");
    }

    default public SchemaVersion getSchemaVersion(String catName, String dbName, String schemaName, int version) throws TException {
        throw new UnsupportedOperationException("MetaStore client does not support getting schema versions");
    }

    default public SchemaVersion getSchemaLatestVersion(String catName, String dbName, String schemaName) throws TException {
        throw new UnsupportedOperationException("MetaStore client does not support getting latest schema version");
    }

    default public List<SchemaVersion> getSchemaAllVersions(String catName, String dbName, String schemaName) throws TException {
        throw new UnsupportedOperationException("MetaStore client does not support getting all schema versions");
    }

    default public void dropSchemaVersion(String catName, String dbName, String schemaName, int version) throws TException {
        throw new UnsupportedOperationException("MetaStore client does not support dropping schema versions");
    }

    default public FindSchemasByColsResp getSchemaByCols(FindSchemasByColsRqst rqst) throws TException {
        throw new UnsupportedOperationException("MetaStore client does not support getting schemas by columns");
    }

    default public void mapSchemaVersionToSerde(String catName, String dbName, String schemaName, int version, String serdeName) throws TException {
        throw new UnsupportedOperationException("MetaStore client does not support mapping schema versions to serdes");
    }

    default public void setSchemaVersionState(String catName, String dbName, String schemaName, int version, SchemaVersionState state) throws TException {
        throw new UnsupportedOperationException("MetaStore client does not support setting schema version state");
    }

    default public void addSerDe(SerDeInfo serDeInfo) throws TException {
        throw new UnsupportedOperationException("MetaStore client does not support adding serdes");
    }

    default public SerDeInfo getSerDe(String serDeName) throws TException {
        throw new UnsupportedOperationException("MetaStore client does not support getting serdes");
    }

    default public LockResponse lockMaterializationRebuild(String dbName, String tableName, long txnId) throws TException {
        throw new UnsupportedOperationException("MetaStore client does not support acquiring materialization rebuild lock");
    }

    default public boolean heartbeatLockMaterializationRebuild(String dbName, String tableName, long txnId) throws TException {
        throw new UnsupportedOperationException("MetaStore client does not support heartbeating materialization rebuild lock");
    }

    default public void addRuntimeStat(RuntimeStat stat) throws TException {
        throw new UnsupportedOperationException("MetaStore client does not support adding runtime stats");
    }

    default public List<RuntimeStat> getRuntimeStats(int maxWeight, int maxCreateTime) throws TException {
        throw new UnsupportedOperationException("MetaStore client does not support reading runtime stats");
    }

    default public GetPartitionsResponse getPartitionsWithSpecs(GetPartitionsRequest request) throws TException {
        throw new UnsupportedOperationException("MetaStore client does not support getting partitions with specs");
    }

    default public OptionalCompactionInfoStruct findNextCompact(FindNextCompactRequest rqst) throws MetaException, TException {
        throw new UnsupportedOperationException("MetaStore client does not support finding next compaction");
    }

    default public void updateCompactorState(CompactionInfoStruct cr, long txnId) throws TException {
        throw new UnsupportedOperationException("MetaStore client does not support updating compactor state");
    }

    default public List<String> findColumnsWithStats(CompactionInfoStruct cr) throws TException {
        throw new UnsupportedOperationException("MetaStore client does not support finding columns with stats");
    }

    default public void markCleaned(CompactionInfoStruct cr) throws MetaException, TException {
        throw new UnsupportedOperationException("MetaStore client does not support marking compaction as cleaned");
    }

    default public void markCompacted(CompactionInfoStruct cr) throws MetaException, TException {
        throw new UnsupportedOperationException("MetaStore client does not support marking compaction as compacted");
    }

    default public void markFailed(CompactionInfoStruct cr) throws MetaException, TException {
        throw new UnsupportedOperationException("MetaStore client does not support marking compaction as failed");
    }

    default public void markRefused(CompactionInfoStruct cr) throws MetaException, TException {
        throw new UnsupportedOperationException("MetaStore client does not support marking compaction as refused");
    }

    default public boolean updateCompactionMetricsData(CompactionMetricsDataStruct struct) throws MetaException, TException {
        throw new UnsupportedOperationException("MetaStore client does not support updating compaction metrics data");
    }

    default public void removeCompactionMetricsData(CompactionMetricsDataRequest request) throws MetaException, TException {
        throw new UnsupportedOperationException("MetaStore client does not support removing compaction metrics data");
    }

    default public void setHadoopJobid(String jobId, long cqId) throws MetaException, TException {
        throw new UnsupportedOperationException("MetaStore client does not support setting hadoop job id for compaction");
    }

    default public String getServerVersion() throws TException {
        throw new UnsupportedOperationException("MetaStore client does not support getting server version");
    }

    default public ScheduledQuery getScheduledQuery(ScheduledQueryKey scheduleKey) throws TException {
        throw new UnsupportedOperationException("MetaStore client does not support getting scheduled query by key");
    }

    default public void scheduledQueryMaintenance(ScheduledQueryMaintenanceRequest request) throws TException {
        throw new UnsupportedOperationException("MetaStore client does not support scheduled query maintenance");
    }

    default public ScheduledQueryPollResponse scheduledQueryPoll(ScheduledQueryPollRequest request) throws TException {
        throw new UnsupportedOperationException("MetaStore client does not support scheduled query poll");
    }

    default public void scheduledQueryProgress(ScheduledQueryProgressInfo info) throws TException {
        throw new UnsupportedOperationException("MetaStore client does not support scheduled query progress");
    }

    default public void addReplicationMetrics(ReplicationMetricList replicationMetricList) throws TException {
        throw new UnsupportedOperationException("MetaStore client does not support adding replication metrics");
    }

    default public ReplicationMetricList getReplicationMetrics(GetReplicationMetricsRequest replicationMetricsRequest) throws TException {
        throw new UnsupportedOperationException("MetaStore client does not support getting replication metrics");
    }

    default public void createStoredProcedure(StoredProcedure proc) throws TException {
        throw new UnsupportedOperationException("MetaStore client does not support creating stored procedures");
    }

    default public StoredProcedure getStoredProcedure(StoredProcedureRequest request) throws TException {
        throw new UnsupportedOperationException("MetaStore client does not support getting stored procedures");
    }

    default public void dropStoredProcedure(StoredProcedureRequest request) throws TException {
        throw new UnsupportedOperationException("MetaStore client does not support dropping stored procedures");
    }

    default public List<String> getAllStoredProcedures(ListStoredProcedureRequest request) throws TException {
        throw new UnsupportedOperationException("MetaStore client does not support getting all stored procedures");
    }

    default public void addPackage(AddPackageRequest request) throws TException {
        throw new UnsupportedOperationException("MetaStore client does not support adding packages");
    }

    default public Package findPackage(GetPackageRequest request) throws TException {
        throw new UnsupportedOperationException("MetaStore client does not support finding packages");
    }

    default public List<String> listPackages(ListPackageRequest request) throws TException {
        throw new UnsupportedOperationException("MetaStore client does not support listing packages");
    }

    default public void dropPackage(DropPackageRequest request) throws TException {
        throw new UnsupportedOperationException("MetaStore client does not support dropping packages");
    }

    default public List<WriteEventInfo> getAllWriteEventInfo(GetAllWriteEventInfoRequest request) throws TException {
        throw new UnsupportedOperationException("MetaStore client does not support getting write events");
    }

    default public AbortCompactResponse abortCompactions(AbortCompactionRequest request) throws TException {
        throw new UnsupportedOperationException("MetaStore client does not support aborting compactions");
    }

    default public boolean setProperties(String nameSpace, Map<String, String> properties) throws TException {
        throw new UnsupportedOperationException();
    }

    default public Map<String, Map<String, String>> getProperties(String nameSpace, String mapPrefix, String mapPredicate, String ... selection) throws TException {
        throw new UnsupportedOperationException();
    }

    public static class IncompatibleMetastoreException
    extends MetaException {
        public IncompatibleMetastoreException(String message) {
            super(message);
        }
    }

    @InterfaceAudience.LimitedPrivate(value={"HCatalog"})
    public static interface NotificationFilter {
        public boolean accept(NotificationEvent var1);
    }
}

