/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.daemon.impl;

import java.lang.management.ThreadMXBean;
import java.lang.reflect.Field;
import java.util.Stack;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hive.llap.LlapThreadLocalStatistics;
import org.apache.hadoop.hive.llap.LlapUtil;
import org.apache.hadoop.hive.llap.io.encoded.TezCounterSource;
import org.apache.tez.common.CallableWithNdc;
import org.apache.tez.common.counters.FileSystemCounter;
import org.apache.tez.common.counters.TezCounters;
import org.apache.tez.runtime.task.TaskRunner2Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class StatsRecordingThreadPool
extends ThreadPoolExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(StatsRecordingThreadPool.class);
    private Thread.UncaughtExceptionHandler uncaughtExceptionHandler;
    private final ThreadMXBean mxBean;

    public StatsRecordingThreadPool(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory) {
        this(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory, (Thread.UncaughtExceptionHandler)null);
    }

    public StatsRecordingThreadPool(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory, Thread.UncaughtExceptionHandler handler) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory);
        this.uncaughtExceptionHandler = handler;
        this.mxBean = LlapUtil.initThreadMxBean();
    }

    @Override
    protected <T> RunnableFuture<T> newTaskFor(Callable<T> callable) {
        return new FutureTask<T>(new WrappedCallable<T>(callable, this.uncaughtExceptionHandler, this.mxBean));
    }

    public void setUncaughtExceptionHandler(Thread.UncaughtExceptionHandler handler) {
        this.uncaughtExceptionHandler = handler;
    }

    private static <V> TezCounters getTezCounters(Callable<V> actualCallable) {
        TezCounters tezCounters = null;
        if (actualCallable instanceof TaskRunner2Callable) {
            TaskRunner2Callable taskRunner2Callable = (TaskRunner2Callable)actualCallable;
            tezCounters = taskRunner2Callable.addAndGetTezCounter(FileSystemCounter.class.getName());
        } else if (actualCallable instanceof TezCounterSource) {
            tezCounters = ((TezCounterSource)((Object)actualCallable)).getTezCounters();
        } else {
            LOG.warn("Unexpected callable {}; cannot get counters", actualCallable);
        }
        return tezCounters;
    }

    private static class WrappedCallable<V>
    implements Callable<V> {
        private Callable<V> actualCallable;
        private Thread.UncaughtExceptionHandler uncaughtExceptionHandler;
        private ThreadMXBean mxBean;

        WrappedCallable(Callable<V> callable, Thread.UncaughtExceptionHandler uncaughtExceptionHandler, ThreadMXBean mxBean) {
            this.actualCallable = callable;
            this.uncaughtExceptionHandler = uncaughtExceptionHandler;
            this.mxBean = mxBean;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V call() throws Exception {
            Thread thread = Thread.currentThread();
            if (this.uncaughtExceptionHandler != null) {
                thread.setUncaughtExceptionHandler(this.uncaughtExceptionHandler);
            }
            LlapThreadLocalStatistics statsBefore = new LlapThreadLocalStatistics(this.mxBean);
            this.setupMDCFromNDC(this.actualCallable);
            try {
                V v = this.actualCallable.call();
                return v;
            }
            finally {
                this.updateCounters(statsBefore, this.actualCallable);
                MDC.clear();
            }
        }

        private void setupMDCFromNDC(Callable<V> actualCallable) {
            if (actualCallable instanceof CallableWithNdc) {
                CallableWithNdc callableWithNdc = (CallableWithNdc)actualCallable;
                try {
                    Field field = callableWithNdc.getClass().getSuperclass().getDeclaredField("ndcStack");
                    field.setAccessible(true);
                    Stack ndcStack = (Stack)field.get(callableWithNdc);
                    Stack clonedStack = (Stack)ndcStack.clone();
                    String fragmentId = (String)clonedStack.pop();
                    String queryId = (String)clonedStack.pop();
                    String dagId = (String)clonedStack.pop();
                    MDC.put((String)"dagId", (String)dagId);
                    MDC.put((String)"queryId", (String)queryId);
                    MDC.put((String)"fragmentId", (String)fragmentId);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Received dagId: {} queryId: {} instanceType: {}", new Object[]{dagId, queryId, actualCallable.getClass().getSimpleName()});
                    }
                }
                catch (Exception e) {
                    LOG.warn("Not setting up MDC as NDC stack cannot be accessed reflectively for instance type: {} exception type: {}", (Object)actualCallable.getClass().getSimpleName(), (Object)e.getClass().getSimpleName());
                }
            } else {
                LOG.warn("Not setting up MDC as unknown callable instance type received: {}", (Object)actualCallable.getClass().getSimpleName());
            }
        }

        private void updateCounters(LlapThreadLocalStatistics statsBefore, Callable<V> actualCallable) {
            Thread thread = Thread.currentThread();
            TezCounters tezCounters = StatsRecordingThreadPool.getTezCounters(actualCallable);
            if (tezCounters != null) {
                if (statsBefore != null) {
                    LlapThreadLocalStatistics currentStats = new LlapThreadLocalStatistics(this.mxBean);
                    currentStats.subtract(statsBefore).fill(tezCounters);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Updated stats: instance: {} thread name: {} thread id: {} stats: {}", new Object[]{actualCallable.getClass().getSimpleName(), thread.getName(), thread.getId(), currentStats});
                    }
                } else {
                    LOG.warn("File system statistics snapshot before execution of thread is null.Thread name: {} id: {}", (Object)thread.getName(), (Object)thread.getId());
                }
            } else {
                LOG.warn("TezCounters is null for callable type: {}", (Object)actualCallable.getClass().getSimpleName());
            }
        }
    }
}

