/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2.objectinspector.primitive;

import java.util.Arrays;
import org.apache.hadoop.hive.serde2.lazy.LazyUtils;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.AbstractPrimitiveWritableObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.SettableBinaryObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.io.BytesWritable;

public class WritableBinaryObjectInspector
extends AbstractPrimitiveWritableObjectInspector
implements SettableBinaryObjectInspector {
    WritableBinaryObjectInspector() {
        super(TypeInfoFactory.binaryTypeInfo);
    }

    @Override
    public BytesWritable copyObject(Object o) {
        if (null == o) {
            return null;
        }
        BytesWritable incoming = (BytesWritable)o;
        byte[] bytes = new byte[incoming.getLength()];
        System.arraycopy(incoming.getBytes(), 0, bytes, 0, incoming.getLength());
        return new BytesWritable(bytes);
    }

    @Override
    public byte[] getPrimitiveJavaObject(Object o) {
        return o == null ? null : LazyUtils.createByteArray((BytesWritable)o);
    }

    @Override
    public BytesWritable getPrimitiveWritableObject(Object o) {
        return null == o ? null : (BytesWritable)o;
    }

    @Override
    public BytesWritable set(Object o, byte[] bb) {
        BytesWritable incoming = (BytesWritable)o;
        if (bb != null) {
            incoming.set(bb, 0, bb.length);
        }
        return incoming;
    }

    @Override
    public BytesWritable set(Object o, BytesWritable bw) {
        BytesWritable incoming = (BytesWritable)o;
        if (bw != null) {
            incoming.set(bw);
        }
        return incoming;
    }

    @Override
    public BytesWritable create(byte[] bb) {
        return new BytesWritable(Arrays.copyOf(bb, bb.length));
    }

    @Override
    public BytesWritable create(BytesWritable bw) {
        BytesWritable newCpy = new BytesWritable();
        if (null != bw) {
            newCpy.set(bw);
        }
        return newCpy;
    }
}

