/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.common.log;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.slf4j.Logger;

public class LogRedirector
implements Runnable {
    private static final long MAX_ERR_LOG_LINES_FOR_RPC = 1000L;
    private final Logger logger;
    private final BufferedReader in;
    private final LogSourceCallback callback;
    private List<String> errLogs;
    private int numErrLogLines = 0;

    public LogRedirector(InputStream in, Logger logger, LogSourceCallback callback) {
        this.in = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));
        this.callback = callback;
        this.logger = logger;
    }

    public LogRedirector(InputStream in, Logger logger, List<String> errLogs, LogSourceCallback callback) {
        this.in = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));
        this.errLogs = errLogs;
        this.callback = callback;
        this.logger = logger;
    }

    @Override
    public void run() {
        try {
            String line = null;
            while ((line = this.in.readLine()) != null) {
                this.logger.info(line);
                if (this.errLogs == null || (long)this.numErrLogLines++ >= 1000L) continue;
                this.errLogs.add(line);
            }
        }
        catch (IOException e) {
            if (this.callback.isAlive()) {
                this.logger.warn("I/O error in redirector thread.", e);
            } else {
                this.logger.debug("I/O error in redirector thread while stopping the remote driver", e);
            }
        }
        catch (Exception e) {
            this.logger.warn("Error in redirector thread.", e);
        }
    }

    public static void redirect(String name, LogRedirector redirector) {
        Thread thread = new Thread(redirector);
        thread.setName(name);
        thread.setDaemon(true);
        thread.start();
    }

    public static interface LogSourceCallback {
        public boolean isAlive();
    }
}

