/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.collector.metrics;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import java.time.Duration;
import java.util.Map;
import org.apache.hertzbeat.common.entity.job.Job;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class HertzBeatMetricsCollector {
    private static final Logger log = LoggerFactory.getLogger(HertzBeatMetricsCollector.class);
    private final MeterRegistry meterRegistry;

    public HertzBeatMetricsCollector(MeterRegistry meterRegistry) {
        this.meterRegistry = meterRegistry;
        log.info("MetricsService initialized with MeterRegistry: {}", (Object)meterRegistry.getClass().getSimpleName());
    }

    public void recordCollectMetrics(Job job, long durationMillis, String status) {
        String monitorTarget;
        if (job == null) {
            return;
        }
        Map<String, String> metadata = job.getMetadata();
        String monitorName = metadata != null ? metadata.get("instancename") : "unknown";
        String string = monitorTarget = metadata != null ? metadata.get("instancehost") : "unknown";
        if (!StringUtils.hasText(monitorTarget)) {
            monitorTarget = "unknown";
        }
        Counter.builder("hertzbeat.collect.total").description("The total number of collection tasks executed").tag("status", status).tag("monitor_type", job.getApp()).tag("monitor_id", String.valueOf(job.getMonitorId())).tag("monitor_name", monitorName).tag("monitor_target", monitorTarget).register(this.meterRegistry).increment();
        Timer.builder("hertzbeat.collect.duration").description("The duration of collection task executions").tag("status", status).tag("monitor_type", job.getApp()).tag("monitor_id", String.valueOf(job.getMonitorId())).tag("monitor_name", monitorName).tag("monitor_target", monitorTarget).register(this.meterRegistry).record(Duration.ofMillis(durationMillis));
        if (log.isDebugEnabled()) {
            log.debug("Recorded metrics for monitor [{}] ({}): status={}, duration={}ms", monitorName, job.getMonitorId(), status, durationMillis);
        }
    }
}

