/*
 * Decompiled with CFR 0.152.
 */
package com.xugu.cloudjdbc;

import com.xugu.cloudjdbc.Connection;
import com.xugu.cloudjdbc.Error;
import com.xugu.cloudjdbc.LobClass;
import com.xugu.cloudjdbc.OracleMethod;
import com.xugu.cloudjdbc.ResultSet;
import com.xugu.cloudjdbc.Statement;
import com.xugu.cloudjdbc.WatchableOutputStream;
import com.xugu.cloudjdbc.WatchableWriter;
import com.xugu.common.ReplaceEnum;
import com.xugu.common.SQLCommon;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.sql.SQLException;

public class Clob
extends LobClass
implements java.sql.Clob,
Serializable {
    long clobByteLen;
    long clob_index;
    ResultSet clob_rs;
    int colNum;
    static OracleMethod orclMethod = null;

    public Clob() {
        this.charData = new String();
    }

    public Clob(String charDataInit) {
        super(charDataInit);
    }

    Clob(String charDataInit, ResultSet rs, Connection clobConn, int col_index) {
        super(charDataInit);
        this.lobConnection = clobConn;
        this.clob_rs = rs;
        this.colNum = col_index;
    }

    Clob(byte[] charDataInit, boolean is_path, Statement stm) throws SQLException {
        super("clob", charDataInit, stm, is_path);
        if (is_path) {
            int sepIndex = this.charData.indexOf(32);
            this.lobDesciptor = this.charData.substring(0, sepIndex);
            this.clobByteLen = Long.parseLong(this.charData.substring(sepIndex + 1));
            if (this.clobByteLen == 0L) {
                this.lobLen = 0L;
            }
            this.lobStm.checkClosed();
            java.sql.ResultSet rsLob = this.lobStm.getLobResultSet(this.lobDesciptor, 0L, this.clobByteLen);
            if (rsLob.next()) {
                this.lobLen = rsLob.getString(1).length();
            }
            rsLob.close();
        }
    }

    Clob(byte[] charDataInit, boolean is_path, Statement stm, ResultSet rs, int col_index) throws SQLException {
        super("clob", charDataInit, stm, is_path);
        this.clob_rs = rs;
        this.colNum = col_index;
        if (is_path) {
            int sepIndex = this.charData.indexOf(32);
            this.lobDesciptor = this.charData.substring(0, sepIndex);
            this.clobByteLen = Long.parseLong(this.charData.substring(sepIndex + 1));
            if (this.clobByteLen == 0L) {
                this.lobLen = 0L;
            }
            this.lobStm.checkClosed();
            java.sql.ResultSet rsLob = this.lobStm.getLobResultSet(this.lobDesciptor, 0L, this.clobByteLen);
            if (rsLob.next()) {
                this.lobLen = rsLob.getString(1).length();
            }
            rsLob.close();
        } else {
            this.charData = this.charData.substring(1, this.charData.length());
            this.lobLen = this.charData.length();
        }
    }

    public Clob(Reader rd) {
        if (rd == null) {
            this.charData = new String();
        } else {
            StringBuffer clob_str = new StringBuffer();
            try {
                boolean times = false;
                char[] chars = new char[1024];
                int length = 0;
                while ((length = rd.read(chars)) != -1) {
                    clob_str.append(chars, 0, length);
                }
                this.charData = clob_str.toString();
                this.lobLen = this.charData.length();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getAsciiStream() throws SQLException {
        this.checkLobFree();
        if (this.islobEmpty()) {
            return new ByteArrayInputStream(new byte[0]);
        }
        ByteArrayInputStream clobInputStream = null;
        java.sql.ResultSet rs = null;
        byte[] asciiBytes = null;
        if (this.charData != null) {
            try {
                if (!this.getIsPath()) {
                    asciiBytes = this.charData.getBytes("US-ASCII");
                    clobInputStream = new ByteArrayInputStream(asciiBytes);
                } else {
                    if (this.lobLen == 0L) {
                        InputStream inputStream = null;
                        return inputStream;
                    }
                    rs = this.lobStm.getLobResultSet(this.lobDesciptor, 0L, this.clobByteLen);
                    if (rs.next()) {
                        clobInputStream = new ByteArrayInputStream(rs.getString(1).getBytes("US-ASCII"));
                    }
                }
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
            return clobInputStream;
        }
        return null;
    }

    @Override
    public Reader getCharacterStream() throws SQLException {
        this.checkLobFree();
        if (this.islobEmpty()) {
            return new StringReader(new String(new byte[0]));
        }
        if (this.charData != null) {
            if (!this.getIsPath()) {
                return new StringReader(this.charData);
            }
            if (this.lobLen == 0L) {
                return null;
            }
            java.sql.ResultSet rs = this.lobStm.getLobResultSet(this.lobDesciptor, 0L, this.clobByteLen);
            if (rs.next()) {
                return new StringReader(rs.getString(1));
            }
            rs.close();
        }
        return null;
    }

    @Override
    public String getSubString(long startPos, int length) throws SQLException {
        int adjustedStartPos = (int)startPos - 1;
        this.checkGetIndexAndLength(startPos, length, true);
        String subString = null;
        if (this.islobEmpty()) {
            return new String("");
        }
        if (this.charData != null) {
            if (!this.getIsPath()) {
                subString = this.charData.substring(adjustedStartPos, adjustedStartPos + length);
            } else {
                if (this.lobLen == 0L) {
                    return null;
                }
                java.sql.ResultSet rs = this.lobStm.getLobResultSet(this.lobDesciptor, 0L, this.clobByteLen);
                if (rs.next()) {
                    subString = rs.getString(1).substring(adjustedStartPos, adjustedStartPos + length);
                }
                rs.close();
            }
        }
        return subString;
    }

    @Override
    public long length() throws SQLException {
        return super.length();
    }

    @Override
    public long position(java.sql.Clob searchstr, long start) throws SQLException {
        if (searchstr == null) {
            return -1L;
        }
        this.checkIndex(start);
        Reader clobRd = searchstr.getCharacterStream();
        StringBuffer clobSB = new StringBuffer();
        char[] cbuf = new char[1024];
        int readLen = 0;
        try {
            while ((readLen = clobRd.read(cbuf)) != -1) {
                clobSB.append(cbuf, 0, readLen);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this.position(clobSB.toString(), start);
    }

    @Override
    public long position(String stringToFind, long startPos) throws SQLException {
        int pos = -1;
        if (this.checkObjectParam(stringToFind) == -1) {
            return pos;
        }
        this.checkIndex(startPos);
        if (this.charData != null) {
            if (this.getIsPath()) {
                if (this.lobLen == 0L) {
                    return -1L;
                }
                java.sql.ResultSet rs = this.lobStm.getLobResultSet(this.lobDesciptor, 0L, this.clobByteLen);
                if (rs.next()) {
                    this.charData = rs.getString(1).substring(0, (int)this.lobLen);
                    this.setIsPath(false);
                }
                rs.close();
            }
            pos = this.charData.indexOf(stringToFind, (int)(startPos - 1L));
        }
        return pos == -1 ? -1L : (long)(pos + 1);
    }

    @Override
    public OutputStream setAsciiStream(long indexToWriteAt) throws SQLException {
        this.checkIndex(indexToWriteAt);
        WatchableOutputStream clobOut = new WatchableOutputStream();
        if (this.charData != null) {
            if (!this.getIsPath()) {
                clobOut.setWatcher(this, (int)indexToWriteAt);
            } else {
                if (this.lobLen == 0L) {
                    return null;
                }
                this.lobStm.checkClosed();
                java.sql.ResultSet rs = this.lobStm.getLobResultSet(this.lobDesciptor, 0L, this.clobByteLen);
                if (rs.next()) {
                    this.charData = rs.getString(1).substring(0, (int)this.lobLen);
                    this.setIsPath(false);
                    clobOut.setWatcher(this, (int)indexToWriteAt);
                }
                rs.close();
            }
        } else {
            return null;
        }
        this.setLobEmpty(false);
        return clobOut;
    }

    @Override
    public Writer setCharacterStream(long indexToWriteAt) throws SQLException {
        this.checkIndex(indexToWriteAt);
        this.clob_index = indexToWriteAt;
        StringBuffer comString = new StringBuffer();
        WatchableWriter clobWriter = new WatchableWriter();
        if (this.charData != null) {
            if (!this.getIsPath()) {
                clobWriter.setWatcher(this, indexToWriteAt);
            } else {
                if (this.lobLen == 0L) {
                    return null;
                }
                this.lobStm.checkClosed();
                java.sql.ResultSet rs = this.lobStm.getLobResultSet(this.lobDesciptor, 0L, this.clobByteLen);
                if (rs.next()) {
                    this.charData = rs.getString(1).substring(0, (int)this.lobLen);
                    this.setIsPath(false);
                    clobWriter.setWatcher(this, indexToWriteAt);
                }
                rs.close();
            }
            this.setLobEmpty(false);
            return clobWriter;
        }
        return null;
    }

    @Override
    public int setString(long pos, String str) throws SQLException {
        if (this.checkObjectParam(str) == -1) {
            return 0;
        }
        return this.setString(pos, str, 1, str.length());
    }

    @Override
    public int setString(long pos, String str, int offset, int len) throws SQLException {
        if (this.checkObjectParam(str) == -1) {
            return 0;
        }
        this.checkGetIndexAndLength(pos, len, false);
        if (offset > str.length() || offset < 0) {
            throw Error.createSQLException("[E50053]Blob: \u5199\u5165\u53c2\u6570\u9519\u8bef", ReplaceEnum.excStr.getReplaceStr() + 50051, 50051);
        }
        StringBuffer clobBuffer = new StringBuffer();
        String realClob = this.charData;
        if (str == null) {
            return 0;
        }
        if (realClob != null) {
            if (this.getIsPath() && this.lobLen > 0L) {
                java.sql.ResultSet rs = this.lobStm.getLobResultSet(this.lobDesciptor, 0L, this.clobByteLen);
                if (rs.next()) {
                    realClob = rs.getString(1).substring(0, (int)this.lobLen);
                }
                rs.close();
            }
            clobBuffer.append(realClob.substring(0, (int)(pos - 1L)));
        }
        clobBuffer.append(str.substring(offset - 1, offset - 1 + len));
        if (pos - 1L + (long)len < (long)realClob.length()) {
            clobBuffer.append(realClob.substring((int)pos + len - 1));
        }
        this.is_path = false;
        this.charData = clobBuffer.toString();
        this.setLobEmpty(false);
        return len;
    }

    @Override
    public void truncate(long length) throws SQLException {
        this.checkIndex(length);
        if (this.charData != null) {
            if (!this.getIsPath()) {
                this.charData = this.charData.substring(0, (int)length);
            } else {
                if (this.lobLen != 0L) {
                    java.sql.ResultSet rs = this.lobStm.getLobResultSet(this.lobDesciptor, 0L, this.clobByteLen);
                    if (rs.next()) {
                        this.charData = rs.getString(1).substring(0, (int)length);
                    }
                    rs.close();
                } else {
                    this.charData = null;
                }
                this.is_path = false;
            }
        }
    }

    public void writerClosed(char[] charDataBeingWritten) {
        this.charData = new String(charDataBeingWritten);
    }

    public void writerClosed(WatchableWriter out) {
        this.charData = out.getWriterString();
    }

    @Override
    public synchronized void free() throws SQLException {
        if (this.isFree) {
            return;
        }
        this.isFree = true;
        this.charData = null;
        this.lobDesciptor = null;
        this.clob_rs = null;
        this.lobStm = null;
        this.lobConnection = null;
    }

    @Override
    public Reader getCharacterStream(long pos, long length) throws SQLException {
        this.checkGetIndexAndLength(pos, length, true);
        StringReader r = null;
        if (this.islobEmpty()) {
            return new StringReader(new String(new byte[0]));
        }
        if (this.charData != null) {
            if (!this.getIsPath()) {
                String sub_charData = this.charData.substring((int)pos - 1, (int)(pos + length - 1L));
                r = new StringReader(sub_charData);
            } else {
                if (this.lobLen == 0L) {
                    return null;
                }
                this.lobStm.checkClosed();
                java.sql.ResultSet rs = this.lobStm.getLobResultSet(this.lobDesciptor, 0L, this.clobByteLen);
                if (rs.next()) {
                    String s = rs.getString(1).substring((int)(pos - 1L), (int)(pos + length - 1L));
                    r = new StringReader(s);
                }
                rs.close();
            }
        }
        return r;
    }

    void setCharData(byte[] bytedata) throws SQLException {
        if (this.getIsPath()) {
            throw SQLCommon.unSupportException("Clob.setCharData", "byte[]");
        }
        this.charData = new String(bytedata);
        this.setLobEmpty(false);
    }

    String getCharData() {
        if (this.islobEmpty()) {
            return new String(new byte[0]);
        }
        return this.charData;
    }

    public static Clob getEmptyCLOB() {
        return OracleMethod.getEmptyCLOB();
    }

    ResultSet getClobRS() {
        return this.clob_rs;
    }

    int getColNum() {
        return this.colNum;
    }

    public String getClobDesciptor() {
        return this.lobDesciptor + "," + this.lobLen;
    }

    public static Clob createTemporary(Connection clobConnection, boolean cache, int duration, short flag) {
        return OracleMethod.createTemporary(clobConnection, cache, duration, flag);
    }

    public static Clob createTemporary(Connection clobConnection, boolean cache, int duration) {
        return Clob.createTemporary(clobConnection, cache, duration, (short)1);
    }

    public static void freeTemporary(Clob clob) throws SQLException {
        OracleMethod.freeTemporary(clob);
    }

    public void freeTemporary() throws SQLException {
        Clob.freeTemporary(this);
    }

    Connection getClobConnection() {
        return this.lobConnection;
    }
}

