/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import org.apache.hadoop.yarn.server.resourcemanager.scheduler.QueueResourceQuotas;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceUsage;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueueMetrics;

public class CSQueueUsageTracker {
    private final CSQueueMetrics metrics;
    private int numContainers;
    private long lastSubmittedTimestamp;
    private final ResourceUsage queueUsage;
    private final QueueResourceQuotas queueResourceQuotas;

    public CSQueueUsageTracker(CSQueueMetrics metrics) {
        this.metrics = metrics;
        this.queueUsage = new ResourceUsage();
        this.queueResourceQuotas = new QueueResourceQuotas();
    }

    public int getNumContainers() {
        return this.numContainers;
    }

    public synchronized void increaseNumContainers() {
        ++this.numContainers;
    }

    public synchronized void decreaseNumContainers() {
        --this.numContainers;
    }

    public CSQueueMetrics getMetrics() {
        return this.metrics;
    }

    public long getLastSubmittedTimestamp() {
        return this.lastSubmittedTimestamp;
    }

    public void setLastSubmittedTimestamp(long lastSubmittedTimestamp) {
        this.lastSubmittedTimestamp = lastSubmittedTimestamp;
    }

    public ResourceUsage getQueueUsage() {
        return this.queueUsage;
    }

    public QueueResourceQuotas getQueueResourceQuotas() {
        return this.queueResourceQuotas;
    }
}

