/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.server.blockmanagement.SlowPeerTracker;
import org.apache.hadoop.util.FakeTimer;
import org.apache.hadoop.util.Timer;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestSlowPeerTracker {
    public static final Logger LOG = LoggerFactory.getLogger(TestSlowPeerTracker.class);
    @Rule
    public Timeout testTimeout = new Timeout(300000);
    private Configuration conf;
    private SlowPeerTracker tracker;
    private FakeTimer timer;
    private long reportValidityMs;

    @Before
    public void setup() {
        this.conf = new HdfsConfiguration();
        this.timer = new FakeTimer();
        this.tracker = new SlowPeerTracker(this.conf, (Timer)this.timer);
        this.reportValidityMs = this.tracker.getReportValidityMs();
    }

    @Test
    public void testEmptyReports() {
        Assert.assertTrue((boolean)this.tracker.getReportsForAllDataNodes().isEmpty());
        Assert.assertTrue((boolean)this.tracker.getReportsForNode("noSuchNode").isEmpty());
    }

    @Test
    public void testReportsAreRetrieved() {
        this.tracker.addReport("node2", "node1");
        this.tracker.addReport("node3", "node1");
        this.tracker.addReport("node3", "node2");
        Assert.assertThat((Object)this.tracker.getReportsForAllDataNodes().size(), (Matcher)Is.is((Object)2));
        Assert.assertThat((Object)this.tracker.getReportsForNode("node2").size(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)this.tracker.getReportsForNode("node3").size(), (Matcher)Is.is((Object)2));
        Assert.assertThat((Object)this.tracker.getReportsForNode("node1").size(), (Matcher)Is.is((Object)0));
    }

    @Test
    public void testAllReportsAreExpired() {
        this.tracker.addReport("node2", "node1");
        this.tracker.addReport("node3", "node2");
        this.tracker.addReport("node1", "node3");
        this.timer.advance(1L);
        Assert.assertThat((Object)this.tracker.getReportsForAllDataNodes().size(), (Matcher)Is.is((Object)3));
        this.timer.advance(this.reportValidityMs);
        Assert.assertTrue((boolean)this.tracker.getReportsForAllDataNodes().isEmpty());
        Assert.assertTrue((boolean)this.tracker.getReportsForNode("node1").isEmpty());
        Assert.assertTrue((boolean)this.tracker.getReportsForNode("node2").isEmpty());
        Assert.assertTrue((boolean)this.tracker.getReportsForNode("node3").isEmpty());
    }

    @Test
    public void testSomeReportsAreExpired() {
        this.tracker.addReport("node3", "node1");
        this.tracker.addReport("node3", "node2");
        this.timer.advance(this.reportValidityMs);
        this.tracker.addReport("node3", "node4");
        Assert.assertThat((Object)this.tracker.getReportsForAllDataNodes().size(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)this.tracker.getReportsForNode("node3").size(), (Matcher)Is.is((Object)1));
        Assert.assertTrue((boolean)this.tracker.getReportsForNode("node3").contains("node4"));
    }

    @Test
    public void testReplacement() {
        this.tracker.addReport("node2", "node1");
        this.timer.advance(this.reportValidityMs);
        Assert.assertThat((Object)this.tracker.getReportsForAllDataNodes().size(), (Matcher)Is.is((Object)0));
        this.tracker.addReport("node2", "node1");
        Assert.assertThat((Object)this.tracker.getReportsForAllDataNodes().size(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)this.tracker.getReportsForNode("node2").size(), (Matcher)Is.is((Object)1));
    }

    @Test
    public void testGetJson() throws IOException {
        this.tracker.addReport("node1", "node2");
        this.tracker.addReport("node2", "node3");
        this.tracker.addReport("node2", "node1");
        this.tracker.addReport("node4", "node1");
        Set<SlowPeerTracker.ReportForJson> reports = this.getAndDeserializeJson();
        Assert.assertThat((Object)reports.size(), (Matcher)Is.is((Object)3));
        Assert.assertTrue((boolean)this.isNodeInReports(reports, "node1"));
        Assert.assertTrue((boolean)this.isNodeInReports(reports, "node2"));
        Assert.assertTrue((boolean)this.isNodeInReports(reports, "node4"));
        Assert.assertFalse((boolean)this.isNodeInReports(reports, "node3"));
    }

    @Test
    public void testGetJsonSizeIsLimited() throws IOException {
        this.tracker.addReport("node1", "node2");
        this.tracker.addReport("node1", "node3");
        this.tracker.addReport("node2", "node3");
        this.tracker.addReport("node2", "node4");
        this.tracker.addReport("node3", "node4");
        this.tracker.addReport("node3", "node5");
        this.tracker.addReport("node4", "node6");
        this.tracker.addReport("node5", "node6");
        this.tracker.addReport("node5", "node7");
        this.tracker.addReport("node6", "node7");
        this.tracker.addReport("node6", "node8");
        Set<SlowPeerTracker.ReportForJson> reports = this.getAndDeserializeJson();
        Assert.assertFalse((boolean)this.isNodeInReports(reports, "node4"));
        Assert.assertTrue((boolean)this.isNodeInReports(reports, "node1"));
        Assert.assertTrue((boolean)this.isNodeInReports(reports, "node2"));
        Assert.assertTrue((boolean)this.isNodeInReports(reports, "node3"));
        Assert.assertTrue((boolean)this.isNodeInReports(reports, "node5"));
        Assert.assertTrue((boolean)this.isNodeInReports(reports, "node6"));
    }

    @Test
    public void testLowRankedElementsIgnored() throws IOException {
        int i;
        for (i = 0; i < 5; ++i) {
            this.tracker.addReport("node" + i, "reporter1");
            this.tracker.addReport("node" + i, "reporter2");
        }
        for (i = 10; i < 20; ++i) {
            this.tracker.addReport("node" + i, "reporter1");
        }
        Set<SlowPeerTracker.ReportForJson> reports = this.getAndDeserializeJson();
        for (int i2 = 0; i2 < 5; ++i2) {
            Assert.assertTrue((boolean)this.isNodeInReports(reports, "node" + i2));
        }
    }

    private boolean isNodeInReports(Set<SlowPeerTracker.ReportForJson> reports, String node) {
        for (SlowPeerTracker.ReportForJson report : reports) {
            if (!report.getSlowNode().equalsIgnoreCase(node)) continue;
            return true;
        }
        return false;
    }

    private Set<SlowPeerTracker.ReportForJson> getAndDeserializeJson() throws IOException {
        String json = this.tracker.getJson();
        LOG.info("Got JSON: {}", (Object)json);
        return (Set)new ObjectMapper().readValue(json, (TypeReference)new TypeReference<Set<SlowPeerTracker.ReportForJson>>(){});
    }
}

