/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.balancer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ClusterMetrics;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.RegionMetrics;
import org.apache.hadoop.hbase.ServerMetrics;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.Size;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.RegionPlan;
import org.apache.hadoop.hbase.master.balancer.BalancerTestBase;
import org.apache.hadoop.hbase.master.balancer.CacheAwareLoadBalancer;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hbase.thirdparty.com.google.common.collect.Lists;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={LargeTests.class})
public class TestCacheAwareLoadBalancer
extends BalancerTestBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestCacheAwareLoadBalancer.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestCacheAwareLoadBalancer.class);
    private static CacheAwareLoadBalancer loadBalancer;
    static List<ServerName> servers;
    static List<TableDescriptor> tableDescs;
    static Map<TableName, String> tableMap;
    static TableName[] tables;

    private static List<ServerName> generateServers(int numServers) {
        ArrayList<ServerName> servers = new ArrayList<ServerName>(numServers);
        ThreadLocalRandom rand = ThreadLocalRandom.current();
        for (int i = 0; i < numServers; ++i) {
            String host = "server" + ((Random)rand).nextInt(100000);
            int port = ((Random)rand).nextInt(60000);
            servers.add(ServerName.valueOf((String)host, (int)port, (long)-1L));
        }
        return servers;
    }

    private static List<TableDescriptor> constructTableDesc(boolean hasBogusTable) {
        ArrayList tds = Lists.newArrayList();
        for (int i = 0; i < tables.length; ++i) {
            TableDescriptor htd = TableDescriptorBuilder.newBuilder((TableName)tables[i]).build();
            tds.add(htd);
        }
        return tds;
    }

    private ServerMetrics mockServerMetricsWithRegionCacheInfo(ServerName server, List<RegionInfo> regionsOnServer, float currentCacheRatio, List<RegionInfo> oldRegionCacheInfo, int oldRegionCachedSize, int regionSize) {
        ServerMetrics serverMetrics = (ServerMetrics)Mockito.mock(ServerMetrics.class);
        TreeMap<byte[], RegionMetrics> regionLoadMap = new TreeMap<byte[], RegionMetrics>(Bytes.BYTES_COMPARATOR);
        for (RegionInfo info : regionsOnServer) {
            RegionMetrics rl = (RegionMetrics)Mockito.mock(RegionMetrics.class);
            Mockito.when((Object)rl.getReadRequestCount()).thenReturn((Object)0L);
            Mockito.when((Object)rl.getWriteRequestCount()).thenReturn((Object)0L);
            Mockito.when((Object)rl.getMemStoreSize()).thenReturn((Object)Size.ZERO);
            Mockito.when((Object)rl.getStoreFileSize()).thenReturn((Object)Size.ZERO);
            Mockito.when((Object)Float.valueOf(rl.getCurrentRegionCachedRatio())).thenReturn((Object)Float.valueOf(currentCacheRatio));
            Mockito.when((Object)rl.getRegionSizeMB()).thenReturn((Object)new Size((double)regionSize, Size.Unit.MEGABYTE));
            regionLoadMap.put(info.getRegionName(), rl);
        }
        Mockito.when((Object)serverMetrics.getRegionMetrics()).thenReturn(regionLoadMap);
        HashMap<String, Integer> oldCacheRatioMap = new HashMap<String, Integer>();
        for (RegionInfo info : oldRegionCacheInfo) {
            oldCacheRatioMap.put(info.getEncodedName(), oldRegionCachedSize);
        }
        Mockito.when((Object)serverMetrics.getRegionCachedInfo()).thenReturn(oldCacheRatioMap);
        return serverMetrics;
    }

    @BeforeClass
    public static void beforeAllTests() throws Exception {
        servers = TestCacheAwareLoadBalancer.generateServers(3);
        tableDescs = TestCacheAwareLoadBalancer.constructTableDesc(false);
        Configuration conf = HBaseConfiguration.create();
        conf.set("hbase.bucketcache.persistent.path", "prefetch_file_list");
        loadBalancer = new CacheAwareLoadBalancer();
        MasterServices services = (MasterServices)Mockito.mock(MasterServices.class);
        Mockito.when((Object)services.getConfiguration()).thenReturn((Object)conf);
        loadBalancer.setMasterServices(services);
        loadBalancer.loadConf(conf);
    }

    @Test
    public void testRegionsNotCachedOnOldServerAndCurrentServer() throws Exception {
        HashMap<ServerName, List<RegionInfo>> clusterState = new HashMap<ServerName, List<RegionInfo>>();
        ServerName server0 = servers.get(0);
        ServerName server1 = servers.get(1);
        ServerName server2 = servers.get(2);
        List<RegionInfo> regionsOnServer0 = this.randomRegions(10);
        List<RegionInfo> regionsOnServer1 = this.randomRegions(0);
        List<RegionInfo> regionsOnServer2 = this.randomRegions(5);
        clusterState.put(server0, regionsOnServer0);
        clusterState.put(server1, regionsOnServer1);
        clusterState.put(server2, regionsOnServer2);
        TreeMap<ServerName, ServerMetrics> serverMetricsMap = new TreeMap<ServerName, ServerMetrics>();
        serverMetricsMap.put(server0, this.mockServerMetricsWithRegionCacheInfo(server0, regionsOnServer0, 0.0f, new ArrayList<RegionInfo>(), 0, 10));
        serverMetricsMap.put(server1, this.mockServerMetricsWithRegionCacheInfo(server1, regionsOnServer1, 0.0f, new ArrayList<RegionInfo>(), 0, 10));
        serverMetricsMap.put(server2, this.mockServerMetricsWithRegionCacheInfo(server2, regionsOnServer2, 0.0f, new ArrayList<RegionInfo>(), 0, 10));
        ClusterMetrics clusterMetrics = (ClusterMetrics)Mockito.mock(ClusterMetrics.class);
        Mockito.when((Object)clusterMetrics.getLiveServerMetrics()).thenReturn(serverMetricsMap);
        loadBalancer.updateClusterMetrics(clusterMetrics);
        HashMap<TableName, TreeMap<ServerName, List<RegionInfo>>> LoadOfAllTable = this.mockClusterServersWithTables(clusterState);
        List plans = loadBalancer.balanceCluster(LoadOfAllTable);
        HashSet<RegionInfo> regionsMovedFromServer0 = new HashSet<RegionInfo>();
        HashMap targetServers = new HashMap();
        for (RegionPlan plan : plans) {
            if (!plan.getSource().equals((Object)server0)) continue;
            regionsMovedFromServer0.add(plan.getRegionInfo());
            if (!targetServers.containsKey(plan.getDestination())) {
                targetServers.put(plan.getDestination(), new ArrayList());
            }
            ((List)targetServers.get(plan.getDestination())).add(plan.getRegionInfo());
        }
        Assert.assertEquals((long)5L, (long)regionsMovedFromServer0.size());
        Assert.assertEquals((long)5L, (long)((List)targetServers.get(server1)).size());
    }

    @Test
    public void testRegionsPartiallyCachedOnOldServerAndNotCachedOnCurrentServer() throws Exception {
        HashMap<ServerName, List<RegionInfo>> clusterState = new HashMap<ServerName, List<RegionInfo>>();
        ServerName server0 = servers.get(0);
        ServerName server1 = servers.get(1);
        ServerName server2 = servers.get(2);
        List<RegionInfo> regionsOnServer0 = this.randomRegions(10);
        List<RegionInfo> regionsOnServer1 = this.randomRegions(0);
        List<RegionInfo> regionsOnServer2 = this.randomRegions(5);
        clusterState.put(server0, regionsOnServer0);
        clusterState.put(server1, regionsOnServer1);
        clusterState.put(server2, regionsOnServer2);
        List<RegionInfo> oldCachedRegions = regionsOnServer0.subList(5, regionsOnServer0.size() - 1);
        TreeMap<ServerName, ServerMetrics> serverMetricsMap = new TreeMap<ServerName, ServerMetrics>();
        serverMetricsMap.put(server0, this.mockServerMetricsWithRegionCacheInfo(server0, regionsOnServer0, 0.0f, new ArrayList<RegionInfo>(), 0, 10));
        serverMetricsMap.put(server1, this.mockServerMetricsWithRegionCacheInfo(server1, regionsOnServer1, 0.0f, oldCachedRegions, 6, 10));
        serverMetricsMap.put(server2, this.mockServerMetricsWithRegionCacheInfo(server2, regionsOnServer2, 0.0f, new ArrayList<RegionInfo>(), 0, 10));
        ClusterMetrics clusterMetrics = (ClusterMetrics)Mockito.mock(ClusterMetrics.class);
        Mockito.when((Object)clusterMetrics.getLiveServerMetrics()).thenReturn(serverMetricsMap);
        loadBalancer.updateClusterMetrics(clusterMetrics);
        HashMap<TableName, TreeMap<ServerName, List<RegionInfo>>> LoadOfAllTable = this.mockClusterServersWithTables(clusterState);
        List plans = loadBalancer.balanceCluster(LoadOfAllTable);
        HashSet<RegionInfo> regionsMovedFromServer0 = new HashSet<RegionInfo>();
        HashMap targetServers = new HashMap();
        for (RegionPlan plan : plans) {
            if (!plan.getSource().equals((Object)server0)) continue;
            regionsMovedFromServer0.add(plan.getRegionInfo());
            if (!targetServers.containsKey(plan.getDestination())) {
                targetServers.put(plan.getDestination(), new ArrayList());
            }
            ((List)targetServers.get(plan.getDestination())).add(plan.getRegionInfo());
        }
        Assert.assertEquals((long)5L, (long)regionsMovedFromServer0.size());
        Assert.assertEquals((long)5L, (long)((List)targetServers.get(server1)).size());
        Assert.assertTrue((boolean)((List)targetServers.get(server1)).containsAll(oldCachedRegions));
    }

    @Test
    public void testThrottlingRegionBeyondThreshold() throws Exception {
        Configuration conf = HBaseConfiguration.create();
        CacheAwareLoadBalancer balancer = new CacheAwareLoadBalancer();
        MasterServices services = (MasterServices)Mockito.mock(MasterServices.class);
        Mockito.when((Object)services.getConfiguration()).thenReturn((Object)conf);
        balancer.setMasterServices(services);
        balancer.loadConf(conf);
        balancer.initialize();
        ServerName server0 = servers.get(0);
        ServerName server1 = servers.get(1);
        Pair regionRatio = new Pair();
        regionRatio.setFirst((Object)server0);
        regionRatio.setSecond((Object)Float.valueOf(1.0f));
        balancer.regionCacheRatioOnOldServerMap.put("region1", regionRatio);
        RegionInfo mockedInfo = (RegionInfo)Mockito.mock(RegionInfo.class);
        Mockito.when((Object)mockedInfo.getEncodedName()).thenReturn((Object)"region1");
        RegionPlan plan = new RegionPlan(mockedInfo, server1, server0);
        long startTime = EnvironmentEdgeManager.currentTime();
        balancer.throttle(plan);
        long endTime = EnvironmentEdgeManager.currentTime();
        Assert.assertTrue((endTime - startTime < 10L ? 1 : 0) != 0);
    }

    @Test
    public void testThrottlingRegionBelowThreshold() throws Exception {
        Configuration conf = HBaseConfiguration.create();
        conf.setLong("hbase.master.balancer.move.throttlingMillis", 100L);
        CacheAwareLoadBalancer balancer = new CacheAwareLoadBalancer();
        MasterServices services = (MasterServices)Mockito.mock(MasterServices.class);
        Mockito.when((Object)services.getConfiguration()).thenReturn((Object)conf);
        balancer.setMasterServices(services);
        balancer.loadConf(conf);
        balancer.initialize();
        ServerName server0 = servers.get(0);
        ServerName server1 = servers.get(1);
        Pair regionRatio = new Pair();
        regionRatio.setFirst((Object)server0);
        regionRatio.setSecond((Object)Float.valueOf(0.1f));
        balancer.regionCacheRatioOnOldServerMap.put("region1", regionRatio);
        RegionInfo mockedInfo = (RegionInfo)Mockito.mock(RegionInfo.class);
        Mockito.when((Object)mockedInfo.getEncodedName()).thenReturn((Object)"region1");
        RegionPlan plan = new RegionPlan(mockedInfo, server1, server0);
        long startTime = EnvironmentEdgeManager.currentTime();
        balancer.throttle(plan);
        long endTime = EnvironmentEdgeManager.currentTime();
        Assert.assertTrue((endTime - startTime >= 100L ? 1 : 0) != 0);
    }

    @Test
    public void testThrottlingCacheRatioUnknownOnTarget() throws Exception {
        Configuration conf = HBaseConfiguration.create();
        conf.setLong("hbase.master.balancer.move.throttlingMillis", 100L);
        CacheAwareLoadBalancer balancer = new CacheAwareLoadBalancer();
        MasterServices services = (MasterServices)Mockito.mock(MasterServices.class);
        Mockito.when((Object)services.getConfiguration()).thenReturn((Object)conf);
        balancer.setMasterServices(services);
        balancer.loadConf(conf);
        balancer.initialize();
        ServerName server0 = servers.get(0);
        ServerName server1 = servers.get(1);
        ServerName server3 = servers.get(2);
        Pair regionRatio = new Pair();
        regionRatio.setFirst((Object)server3);
        regionRatio.setSecond((Object)Float.valueOf(1.0f));
        balancer.regionCacheRatioOnOldServerMap.put("region1", regionRatio);
        RegionInfo mockedInfo = (RegionInfo)Mockito.mock(RegionInfo.class);
        Mockito.when((Object)mockedInfo.getEncodedName()).thenReturn((Object)"region1");
        RegionPlan plan = new RegionPlan(mockedInfo, server1, server0);
        long startTime = EnvironmentEdgeManager.currentTime();
        balancer.throttle(plan);
        long endTime = EnvironmentEdgeManager.currentTime();
        Assert.assertTrue((endTime - startTime >= 100L ? 1 : 0) != 0);
    }

    @Test
    public void testThrottlingCacheRatioUnknownForRegion() throws Exception {
        Configuration conf = HBaseConfiguration.create();
        conf.setLong("hbase.master.balancer.move.throttlingMillis", 100L);
        CacheAwareLoadBalancer balancer = new CacheAwareLoadBalancer();
        MasterServices services = (MasterServices)Mockito.mock(MasterServices.class);
        Mockito.when((Object)services.getConfiguration()).thenReturn((Object)conf);
        balancer.setMasterServices(services);
        balancer.loadConf(conf);
        balancer.initialize();
        ServerName server0 = servers.get(0);
        ServerName server1 = servers.get(1);
        ServerName server3 = servers.get(2);
        RegionInfo mockedInfo = (RegionInfo)Mockito.mock(RegionInfo.class);
        Mockito.when((Object)mockedInfo.getEncodedName()).thenReturn((Object)"region1");
        RegionPlan plan = new RegionPlan(mockedInfo, server1, server0);
        long startTime = EnvironmentEdgeManager.currentTime();
        balancer.throttle(plan);
        long endTime = EnvironmentEdgeManager.currentTime();
        Assert.assertTrue((endTime - startTime >= 100L ? 1 : 0) != 0);
    }

    @Test
    public void testRegionPlansSortedByCacheRatioOnTarget() throws Exception {
        HashMap<ServerName, List<RegionInfo>> clusterState = new HashMap<ServerName, List<RegionInfo>>();
        ServerName server0 = servers.get(0);
        ServerName server1 = servers.get(1);
        ServerName server2 = servers.get(2);
        List<RegionInfo> regionsOnServer0 = this.randomRegions(15);
        List<RegionInfo> regionsOnServer1 = this.randomRegions(0);
        List<RegionInfo> regionsOnServer2 = this.randomRegions(0);
        clusterState.put(server0, regionsOnServer0);
        clusterState.put(server1, regionsOnServer1);
        clusterState.put(server2, regionsOnServer2);
        List<RegionInfo> oldCachedRegions1 = regionsOnServer0.subList(5, 10);
        List<RegionInfo> oldCachedRegions2 = regionsOnServer0.subList(10, regionsOnServer0.size());
        TreeMap<ServerName, ServerMetrics> serverMetricsMap = new TreeMap<ServerName, ServerMetrics>();
        serverMetricsMap.put(server0, this.mockServerMetricsWithRegionCacheInfo(server0, regionsOnServer0, 0.0f, new ArrayList<RegionInfo>(), 0, 10));
        serverMetricsMap.put(server1, this.mockServerMetricsWithRegionCacheInfo(server1, regionsOnServer1, 0.0f, oldCachedRegions1, 10, 10));
        serverMetricsMap.put(server2, this.mockServerMetricsWithRegionCacheInfo(server2, regionsOnServer2, 0.0f, oldCachedRegions2, 8, 10));
        ClusterMetrics clusterMetrics = (ClusterMetrics)Mockito.mock(ClusterMetrics.class);
        Mockito.when((Object)clusterMetrics.getLiveServerMetrics()).thenReturn(serverMetricsMap);
        loadBalancer.updateClusterMetrics(clusterMetrics);
        HashMap<TableName, TreeMap<ServerName, List<RegionInfo>>> LoadOfAllTable = this.mockClusterServersWithTables(clusterState);
        List plans = loadBalancer.balanceCluster(LoadOfAllTable);
        LOG.debug("plans size: {}", (Object)plans.size());
        LOG.debug("plans: {}", (Object)plans);
        LOG.debug("server1 name: {}", (Object)server1.getServerName());
        int highCacheCount = 0;
        for (RegionPlan plan : plans) {
            LOG.debug("plan region: {}, target server: {}", (Object)plan.getRegionInfo().getEncodedName(), (Object)plan.getDestination().getServerName());
            if (highCacheCount < 5) {
                LOG.debug("Count: {}", (Object)highCacheCount);
                Assert.assertTrue((boolean)oldCachedRegions1.contains(plan.getRegionInfo()));
                Assert.assertFalse((boolean)oldCachedRegions2.contains(plan.getRegionInfo()));
                ++highCacheCount;
                continue;
            }
            Assert.assertTrue((boolean)oldCachedRegions2.contains(plan.getRegionInfo()));
            Assert.assertFalse((boolean)oldCachedRegions1.contains(plan.getRegionInfo()));
        }
    }

    @Test
    public void testRegionsFullyCachedOnOldServerAndNotCachedOnCurrentServers() throws Exception {
        HashMap<ServerName, List<RegionInfo>> clusterState = new HashMap<ServerName, List<RegionInfo>>();
        ServerName server0 = servers.get(0);
        ServerName server1 = servers.get(1);
        ServerName server2 = servers.get(2);
        List<RegionInfo> regionsOnServer0 = this.randomRegions(10);
        List<RegionInfo> regionsOnServer1 = this.randomRegions(0);
        List<RegionInfo> regionsOnServer2 = this.randomRegions(5);
        clusterState.put(server0, regionsOnServer0);
        clusterState.put(server1, regionsOnServer1);
        clusterState.put(server2, regionsOnServer2);
        List<RegionInfo> oldCachedRegions = regionsOnServer0.subList(5, regionsOnServer0.size() - 1);
        TreeMap<ServerName, ServerMetrics> serverMetricsMap = new TreeMap<ServerName, ServerMetrics>();
        serverMetricsMap.put(server0, this.mockServerMetricsWithRegionCacheInfo(server0, regionsOnServer0, 0.0f, new ArrayList<RegionInfo>(), 0, 10));
        serverMetricsMap.put(server1, this.mockServerMetricsWithRegionCacheInfo(server1, regionsOnServer1, 0.0f, oldCachedRegions, 10, 10));
        serverMetricsMap.put(server2, this.mockServerMetricsWithRegionCacheInfo(server2, regionsOnServer2, 0.0f, new ArrayList<RegionInfo>(), 0, 10));
        ClusterMetrics clusterMetrics = (ClusterMetrics)Mockito.mock(ClusterMetrics.class);
        Mockito.when((Object)clusterMetrics.getLiveServerMetrics()).thenReturn(serverMetricsMap);
        loadBalancer.updateClusterMetrics(clusterMetrics);
        HashMap<TableName, TreeMap<ServerName, List<RegionInfo>>> LoadOfAllTable = this.mockClusterServersWithTables(clusterState);
        List plans = loadBalancer.balanceCluster(LoadOfAllTable);
        HashSet<RegionInfo> regionsMovedFromServer0 = new HashSet<RegionInfo>();
        HashMap targetServers = new HashMap();
        for (RegionPlan plan : plans) {
            if (!plan.getSource().equals((Object)server0)) continue;
            regionsMovedFromServer0.add(plan.getRegionInfo());
            if (!targetServers.containsKey(plan.getDestination())) {
                targetServers.put(plan.getDestination(), new ArrayList());
            }
            ((List)targetServers.get(plan.getDestination())).add(plan.getRegionInfo());
        }
        Assert.assertEquals((long)5L, (long)regionsMovedFromServer0.size());
        Assert.assertEquals((long)5L, (long)((List)targetServers.get(server1)).size());
        Assert.assertTrue((boolean)((List)targetServers.get(server1)).containsAll(oldCachedRegions));
    }

    @Test
    public void testRegionsFullyCachedOnOldAndCurrentServers() throws Exception {
        HashMap<ServerName, List<RegionInfo>> clusterState = new HashMap<ServerName, List<RegionInfo>>();
        ServerName server0 = servers.get(0);
        ServerName server1 = servers.get(1);
        ServerName server2 = servers.get(2);
        List<RegionInfo> regionsOnServer0 = this.randomRegions(10);
        List<RegionInfo> regionsOnServer1 = this.randomRegions(0);
        List<RegionInfo> regionsOnServer2 = this.randomRegions(5);
        clusterState.put(server0, regionsOnServer0);
        clusterState.put(server1, regionsOnServer1);
        clusterState.put(server2, regionsOnServer2);
        List<RegionInfo> oldCachedRegions = regionsOnServer0.subList(5, regionsOnServer0.size() - 1);
        TreeMap<ServerName, ServerMetrics> serverMetricsMap = new TreeMap<ServerName, ServerMetrics>();
        serverMetricsMap.put(server0, this.mockServerMetricsWithRegionCacheInfo(server0, regionsOnServer0, 1.0f, new ArrayList<RegionInfo>(), 0, 10));
        serverMetricsMap.put(server1, this.mockServerMetricsWithRegionCacheInfo(server1, regionsOnServer1, 1.0f, oldCachedRegions, 10, 10));
        serverMetricsMap.put(server2, this.mockServerMetricsWithRegionCacheInfo(server2, regionsOnServer2, 1.0f, new ArrayList<RegionInfo>(), 0, 10));
        ClusterMetrics clusterMetrics = (ClusterMetrics)Mockito.mock(ClusterMetrics.class);
        Mockito.when((Object)clusterMetrics.getLiveServerMetrics()).thenReturn(serverMetricsMap);
        loadBalancer.updateClusterMetrics(clusterMetrics);
        HashMap<TableName, TreeMap<ServerName, List<RegionInfo>>> LoadOfAllTable = this.mockClusterServersWithTables(clusterState);
        List plans = loadBalancer.balanceCluster(LoadOfAllTable);
        HashSet<RegionInfo> regionsMovedFromServer0 = new HashSet<RegionInfo>();
        HashMap targetServers = new HashMap();
        for (RegionPlan plan : plans) {
            if (!plan.getSource().equals((Object)server0)) continue;
            regionsMovedFromServer0.add(plan.getRegionInfo());
            if (!targetServers.containsKey(plan.getDestination())) {
                targetServers.put(plan.getDestination(), new ArrayList());
            }
            ((List)targetServers.get(plan.getDestination())).add(plan.getRegionInfo());
        }
        Assert.assertEquals((long)5L, (long)regionsMovedFromServer0.size());
        Assert.assertEquals((long)5L, (long)((List)targetServers.get(server1)).size());
        Assert.assertTrue((boolean)((List)targetServers.get(server1)).containsAll(oldCachedRegions));
    }

    @Test
    public void testRegionsPartiallyCachedOnOldServerAndCurrentServer() throws Exception {
        HashMap<ServerName, List<RegionInfo>> clusterState = new HashMap<ServerName, List<RegionInfo>>();
        ServerName server0 = servers.get(0);
        ServerName server1 = servers.get(1);
        ServerName server2 = servers.get(2);
        List<RegionInfo> regionsOnServer0 = this.randomRegions(10);
        List<RegionInfo> regionsOnServer1 = this.randomRegions(0);
        List<RegionInfo> regionsOnServer2 = this.randomRegions(5);
        clusterState.put(server0, regionsOnServer0);
        clusterState.put(server1, regionsOnServer1);
        clusterState.put(server2, regionsOnServer2);
        List<RegionInfo> oldCachedRegions = regionsOnServer0.subList(5, regionsOnServer0.size() - 1);
        TreeMap<ServerName, ServerMetrics> serverMetricsMap = new TreeMap<ServerName, ServerMetrics>();
        serverMetricsMap.put(server0, this.mockServerMetricsWithRegionCacheInfo(server0, regionsOnServer0, 0.2f, new ArrayList<RegionInfo>(), 0, 10));
        serverMetricsMap.put(server1, this.mockServerMetricsWithRegionCacheInfo(server1, regionsOnServer1, 0.0f, oldCachedRegions, 6, 10));
        serverMetricsMap.put(server2, this.mockServerMetricsWithRegionCacheInfo(server2, regionsOnServer2, 1.0f, new ArrayList<RegionInfo>(), 0, 10));
        ClusterMetrics clusterMetrics = (ClusterMetrics)Mockito.mock(ClusterMetrics.class);
        Mockito.when((Object)clusterMetrics.getLiveServerMetrics()).thenReturn(serverMetricsMap);
        loadBalancer.updateClusterMetrics(clusterMetrics);
        HashMap<TableName, TreeMap<ServerName, List<RegionInfo>>> LoadOfAllTable = this.mockClusterServersWithTables(clusterState);
        List plans = loadBalancer.balanceCluster(LoadOfAllTable);
        HashSet<RegionInfo> regionsMovedFromServer0 = new HashSet<RegionInfo>();
        HashMap targetServers = new HashMap();
        for (RegionPlan plan : plans) {
            if (!plan.getSource().equals((Object)server0)) continue;
            regionsMovedFromServer0.add(plan.getRegionInfo());
            if (!targetServers.containsKey(plan.getDestination())) {
                targetServers.put(plan.getDestination(), new ArrayList());
            }
            ((List)targetServers.get(plan.getDestination())).add(plan.getRegionInfo());
        }
        Assert.assertEquals((long)5L, (long)regionsMovedFromServer0.size());
        Assert.assertEquals((long)5L, (long)((List)targetServers.get(server1)).size());
        Assert.assertTrue((boolean)((List)targetServers.get(server1)).containsAll(oldCachedRegions));
    }

    @Test
    public void testBalancerNotThrowNPEWhenBalancerPlansIsNull() throws Exception {
        HashMap<ServerName, List<RegionInfo>> clusterState = new HashMap<ServerName, List<RegionInfo>>();
        ServerName server0 = servers.get(0);
        ServerName server1 = servers.get(1);
        ServerName server2 = servers.get(2);
        List<RegionInfo> regionsOnServer0 = this.randomRegions(5);
        List<RegionInfo> regionsOnServer1 = this.randomRegions(5);
        List<RegionInfo> regionsOnServer2 = this.randomRegions(5);
        clusterState.put(server0, regionsOnServer0);
        clusterState.put(server1, regionsOnServer1);
        clusterState.put(server2, regionsOnServer2);
        TreeMap<ServerName, ServerMetrics> serverMetricsMap = new TreeMap<ServerName, ServerMetrics>();
        serverMetricsMap.put(server0, this.mockServerMetricsWithRegionCacheInfo(server0, regionsOnServer0, 0.0f, new ArrayList<RegionInfo>(), 0, 10));
        serverMetricsMap.put(server1, this.mockServerMetricsWithRegionCacheInfo(server1, regionsOnServer1, 0.0f, new ArrayList<RegionInfo>(), 0, 10));
        serverMetricsMap.put(server2, this.mockServerMetricsWithRegionCacheInfo(server2, regionsOnServer2, 0.0f, new ArrayList<RegionInfo>(), 0, 10));
        ClusterMetrics clusterMetrics = (ClusterMetrics)Mockito.mock(ClusterMetrics.class);
        Mockito.when((Object)clusterMetrics.getLiveServerMetrics()).thenReturn(serverMetricsMap);
        loadBalancer.updateClusterMetrics(clusterMetrics);
        HashMap<TableName, TreeMap<ServerName, List<RegionInfo>>> LoadOfAllTable = this.mockClusterServersWithTables(clusterState);
        try {
            List plans = loadBalancer.balanceCluster(LoadOfAllTable);
            Assert.assertNull((Object)plans);
        }
        catch (NullPointerException npe) {
            Assert.fail((String)"NPE should not be thrown");
        }
    }

    static {
        tableMap = new HashMap<TableName, String>();
        tables = new TableName[]{TableName.valueOf((String)"dt1"), TableName.valueOf((String)"dt2"), TableName.valueOf((String)"dt3"), TableName.valueOf((String)"dt4")};
    }
}

