/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.mavibot.btree;

import java.io.IOException;
import java.util.LinkedList;
import org.apache.directory.mavibot.btree.AbstractPage;
import org.apache.directory.mavibot.btree.BTree;
import org.apache.directory.mavibot.btree.ElementHolder;
import org.apache.directory.mavibot.btree.InternalUtil;
import org.apache.directory.mavibot.btree.Leaf;
import org.apache.directory.mavibot.btree.Node;
import org.apache.directory.mavibot.btree.Page;
import org.apache.directory.mavibot.btree.ParentPos;
import org.apache.directory.mavibot.btree.RecordManager;
import org.apache.directory.mavibot.btree.serializer.ElementSerializer;

public class BTreeFactory {
    public static BTree createBTree() {
        BTree btree = new BTree();
        return btree;
    }

    public static Node createNode(BTree btree, long revision, int nbElems) {
        Node node = new Node(btree, revision, nbElems);
        return node;
    }

    public static Leaf createLeaf(BTree btree, long revision, int nbElems) {
        Leaf leaf = new Leaf(btree, revision, nbElems);
        return leaf;
    }

    public static void setRoot(BTree<?, ?> btree, Page root) {
        btree.setRoot(root);
    }

    public static Page getRoot(BTree<?, ?> btree) {
        return btree.rootPage;
    }

    public static void setNbElems(BTree<?, ?> btree, long nbElems) {
        btree.setNbElems(nbElems);
    }

    public static void setRevision(BTree<?, ?> btree, long revision) {
        btree.setRevision(revision);
    }

    public static void setRootPageOffset(BTree<?, ?> btree, long rootPageOffset) {
        btree.setRootPageOffset(rootPageOffset);
    }

    public static void setNextBTreeOffset(BTree<?, ?> btree, long nextBTreeOffset) {
        btree.setNextBTreeOffset(nextBTreeOffset);
    }

    public static void setName(BTree<?, ?> btree, String name) {
        btree.setName(name);
    }

    public static void setKeySerializer(BTree<?, ?> btree, String keySerializerFqcn) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        Class<?> keySerializer = Class.forName(keySerializerFqcn);
        ElementSerializer instance = (ElementSerializer)keySerializer.newInstance();
        btree.setKeySerializer(instance);
        btree.setComparator(instance.getComparator());
    }

    public static void setValueSerializer(BTree<?, ?> btree, String valueSerializerFqcn) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        Class<?> valueSerializer = Class.forName(valueSerializerFqcn);
        btree.setValueSerializer((ElementSerializer)valueSerializer.newInstance());
    }

    public static void setPageSize(BTree<?, ?> btree, int pageSize) {
        btree.setPageSize(pageSize);
    }

    public static void setRecordManager(BTree<?, ?> btree, RecordManager recordManager) {
        btree.setRecordManager(recordManager);
    }

    public static void setKey(Page page, int pos, Object key) {
        ((AbstractPage)page).setKey(pos, key);
    }

    public static void setValue(Leaf page, int pos, ElementHolder value) {
        page.setValue(pos, value);
    }

    public static void setValue(Node page, int pos, ElementHolder value) {
        page.setValue(pos, value);
    }

    public static LinkedList getPathToRightMostLeaf(BTree btree) throws IOException {
        LinkedList stack = new LinkedList();
        ParentPos last = new ParentPos(btree.rootPage, btree.rootPage.getNbElems());
        stack.push(last);
        if (btree.rootPage instanceof Leaf) {
            InternalUtil.setLastDupsContainer(last, btree);
        } else {
            Page p;
            Node node = (Node)btree.rootPage;
            do {
                p = node.children[node.getNbElems()].getValue(btree);
                last = new ParentPos(p, p.getNbElems());
                stack.push(last);
            } while (!(p instanceof Leaf));
            InternalUtil.setLastDupsContainer(last, btree);
        }
        return stack;
    }
}

