/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.actions.searchRequest.filter;

import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.ber.Asn1Container;
import org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.ldap.codec.api.LdapMessageContainer;
import org.apache.directory.api.ldap.codec.decorators.SearchRequestDecorator;
import org.apache.directory.api.ldap.codec.search.ExtensibleMatchFilter;
import org.apache.directory.api.ldap.model.entry.BinaryValue;
import org.apache.directory.api.ldap.model.entry.Value;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoreMatchValue
extends GrammarAction<LdapMessageContainer<SearchRequestDecorator>> {
    private static final Logger LOG = LoggerFactory.getLogger(StoreMatchValue.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();

    public StoreMatchValue() {
        super("Store match Value");
    }

    public void action(LdapMessageContainer<SearchRequestDecorator> container) throws DecoderException {
        SearchRequestDecorator decorator = container.getMessage();
        TLV tlv = container.getCurrentTLV();
        ExtensibleMatchFilter extensibleMatchFilter = (ExtensibleMatchFilter)decorator.getTerminalFilter();
        byte[] value = tlv.getValue().getData();
        extensibleMatchFilter.setMatchValue((Value<?>)new BinaryValue(value));
        decorator.unstackFilters((Asn1Container)container);
        if (IS_DEBUG) {
            LOG.debug("Stored a match value : {}", (Object)value);
        }
    }
}

