/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.balancer;

import java.io.IOException;
import org.apache.hadoop.hbase.ScheduledChore;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class BalancerChore
extends ScheduledChore {
    private static final Logger LOG = LoggerFactory.getLogger(BalancerChore.class);
    private final HMaster master;

    public BalancerChore(HMaster master) {
        super(master.getServerName() + "-BalancerChore", master, master.getConfiguration().getInt("hbase.balancer.period", 300000));
        this.master = master;
    }

    @Override
    protected void chore() {
        try {
            this.master.balanceOrUpdateMetrics();
        }
        catch (IOException e) {
            LOG.error("Failed to balance.", (Throwable)e);
        }
    }
}

