/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import java.util.function.BooleanSupplier;
import java.util.function.IntSupplier;
import org.apache.hadoop.hbase.exceptions.ConnectionClosedException;
import org.apache.hadoop.hbase.ipc.MetricsHBaseServer;
import org.apache.hadoop.hbase.ipc.RpcResponse;
import org.apache.hadoop.hbase.ipc.RpcServer;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.NettyUnsafeUtils;
import org.apache.hbase.thirdparty.io.netty.channel.Channel;
import org.apache.hbase.thirdparty.io.netty.channel.ChannelDuplexHandler;
import org.apache.hbase.thirdparty.io.netty.channel.ChannelHandlerContext;
import org.apache.hbase.thirdparty.io.netty.channel.ChannelPromise;
import org.apache.hbase.thirdparty.io.netty.util.ReferenceCountUtil;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class NettyRpcServerChannelWritabilityHandler
extends ChannelDuplexHandler {
    static final String NAME = "NettyRpcServerChannelWritabilityHandler";
    private final MetricsHBaseServer metrics;
    private final IntSupplier pendingBytesFatalThreshold;
    private final BooleanSupplier isWritabilityBackpressureEnabled;
    private boolean writable = true;
    private long unwritableStartTime;

    NettyRpcServerChannelWritabilityHandler(MetricsHBaseServer metrics, IntSupplier pendingBytesFatalThreshold, BooleanSupplier isWritabilityBackpressureEnabled) {
        this.metrics = metrics;
        this.pendingBytesFatalThreshold = pendingBytesFatalThreshold;
        this.isWritabilityBackpressureEnabled = isWritabilityBackpressureEnabled;
    }

    @Override
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (this.handleFatalThreshold(ctx)) {
            promise.setFailure(new ConnectionClosedException("Channel outbound bytes exceeded fatal threshold"));
            if (msg instanceof RpcResponse) {
                ((RpcResponse)msg).done();
            } else {
                ReferenceCountUtil.release(msg);
            }
            return;
        }
        ctx.write(msg, promise);
    }

    @Override
    public void channelWritabilityChanged(ChannelHandlerContext ctx) throws Exception {
        if (this.isWritabilityBackpressureEnabled.getAsBoolean()) {
            this.handleWritabilityChanged(ctx);
        }
        ctx.fireChannelWritabilityChanged();
    }

    private boolean handleFatalThreshold(ChannelHandlerContext ctx) {
        int fatalThreshold = this.pendingBytesFatalThreshold.getAsInt();
        if (fatalThreshold <= 0) {
            return false;
        }
        Channel channel = ctx.channel();
        long outboundBytes = NettyUnsafeUtils.getTotalPendingOutboundBytes(channel);
        if (outboundBytes < (long)fatalThreshold) {
            return false;
        }
        if (channel.isOpen()) {
            this.metrics.maxOutboundBytesExceeded();
            RpcServer.LOG.warn("{}: Closing connection because outbound buffer size of {} exceeds fatal threshold of {}", new Object[]{channel.remoteAddress(), outboundBytes, fatalThreshold});
            NettyUnsafeUtils.closeImmediately(channel);
        }
        return true;
    }

    private void handleWritabilityChanged(ChannelHandlerContext ctx) {
        boolean oldWritableValue = this.writable;
        this.writable = ctx.channel().isWritable();
        ctx.channel().config().setAutoRead(this.writable);
        if (!oldWritableValue && this.writable) {
            this.metrics.unwritableTime(EnvironmentEdgeManager.currentTime() - this.unwritableStartTime);
            this.unwritableStartTime = 0L;
        } else if (oldWritableValue && !this.writable) {
            this.unwritableStartTime = EnvironmentEdgeManager.currentTime();
        }
    }
}

