/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.cosmosdb.internal.directconnectivity;

import com.microsoft.azure.cosmosdb.internal.SessionContainer;
import com.microsoft.azure.cosmosdb.internal.UserAgentContainer;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.GatewayServiceConfigurationReader;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.HttpTransportClient;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.IAddressResolver;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.Protocol;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.RntbdTransportClient;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.StoreClient;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.TransportClient;
import com.microsoft.azure.cosmosdb.rx.internal.Configs;
import com.microsoft.azure.cosmosdb.rx.internal.IAuthorizationTokenProvider;

public class StoreClientFactory
implements AutoCloseable {
    private final Configs configs;
    private final int maxConcurrentConnectionOpenRequests;
    private final int requestTimeoutInSeconds;
    private final Protocol protocol;
    private final TransportClient transportClient;
    private volatile boolean isClosed;

    public StoreClientFactory(Configs configs, int requestTimeoutInSeconds, int maxConcurrentConnectionOpenRequests, UserAgentContainer userAgent) {
        this.configs = configs;
        this.protocol = configs.getProtocol();
        this.requestTimeoutInSeconds = requestTimeoutInSeconds;
        this.maxConcurrentConnectionOpenRequests = maxConcurrentConnectionOpenRequests;
        if (this.protocol == Protocol.Https) {
            this.transportClient = new HttpTransportClient(configs, requestTimeoutInSeconds, userAgent);
        } else if (this.protocol == Protocol.Tcp) {
            this.transportClient = new RntbdTransportClient(configs, requestTimeoutInSeconds, userAgent);
        } else {
            throw new IllegalArgumentException(String.format("protocol: %s", this.protocol));
        }
    }

    @Override
    public void close() throws Exception {
        this.transportClient.close();
        this.isClosed = true;
    }

    public StoreClient createStoreClient(IAddressResolver addressResolver, SessionContainer sessionContainer, GatewayServiceConfigurationReader serviceConfigurationReader, IAuthorizationTokenProvider authorizationTokenProvider, boolean useMultipleWriteLocations) {
        this.throwIfClosed();
        return new StoreClient(this.configs, addressResolver, sessionContainer, serviceConfigurationReader, authorizationTokenProvider, this.transportClient, useMultipleWriteLocations);
    }

    private void throwIfClosed() {
        if (this.isClosed) {
            throw new IllegalStateException("storeClient already closed!");
        }
    }
}

